/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.physics.Consist;
import cam72cam.immersiverailroading.entity.physics.Simulation;
import cam72cam.immersiverailroading.entity.physics.SimulationState;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.net.SoundPacket;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.StrictTagMapper;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class EntityCoupleableRollingStock
extends EntityMoveableRollingStock {
    @TagSync
    @TagField(value="CoupledFront", mapper=StrictTagMapper.class)
    private UUID coupledFront = null;
    @TagSync
    @TagField(value="frontCouplerEngaged")
    private boolean frontCouplerEngaged = true;
    @TagSync
    @TagField(value="CoupledBack", mapper=StrictTagMapper.class)
    private UUID coupledBack = null;
    @TagSync
    @TagField(value="backCouplerEngaged")
    private boolean backCouplerEngaged = true;
    @TagField(value="consist", mapper=Consist.TagMapper.class)
    public Consist consist = new Consist(Collections.emptyList(), Collections.emptyList());
    @TagField(value="lastKnownFront")
    public Vec3i lastKnownFront = null;
    @TagField(value="lastKnownRear")
    public Vec3i lastKnownRear = null;
    @TagField(value="slackFront")
    @TagSync
    public float slackFrontPercent;
    @TagField(value="slackRear")
    @TagSync
    public float slackRearPercent;
    @TagSync
    @TagField(value="hasElectricalPower")
    private boolean hasElectricalPower;
    private boolean hadElectricalPower = false;
    private int gotElectricalPowerTick = -1;

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        if (player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_HOOK) && player.hasPermission(Permissions.COUPLING_HOOK)) {
            if (this.getWorld().isClient) {
                return ClickResult.ACCEPTED;
            }
            CouplerType coupler = CouplerType.FRONT;
            if (this.getCouplerPosition(CouplerType.FRONT).distanceTo(player.getPosition()) > this.getCouplerPosition(CouplerType.BACK).distanceTo(player.getPosition())) {
                coupler = CouplerType.BACK;
            }
            if (player.isCrouching()) {
                this.setCouplerEngaged(coupler, !this.isCouplerEngaged(coupler));
                if (this.isCouplerEngaged(coupler)) {
                    player.sendMessage(ChatText.COUPLER_ENGAGED.getMessage(new Object[]{coupler}));
                } else {
                    player.sendMessage(ChatText.COUPLER_DISENGAGED.getMessage(new Object[]{coupler}));
                }
            } else {
                EntityCoupleableRollingStock coupled = this.getCoupled(coupler);
                if (this.isCoupled(coupler) && this.isCouplerEngaged(coupler) && coupled != null) {
                    player.sendMessage(ChatText.COUPLER_STATUS_COUPLED.getMessage(new Object[]{coupler, coupled.getDefinition().name(), coupled.getPosition().x, coupled.getPosition().y, coupled.getPosition().z}));
                } else if (this.isCouplerEngaged(coupler)) {
                    player.sendMessage(ChatText.COUPLER_STATUS_DECOUPLED_ENGAGED.getMessage(new Object[]{coupler}));
                } else {
                    player.sendMessage(ChatText.COUPLER_STATUS_DECOUPLED_DISENGAGED.getMessage(new Object[]{coupler}));
                }
            }
            return ClickResult.ACCEPTED;
        }
        return super.onClick(player, hand);
    }

    @Override
    public void onTick() {
        super.onTick();
        World world = this.getWorld();
        if (world.isClient) {
            if (!this.hadElectricalPower && this.hasElectricalPower()) {
                this.gotElectricalPowerTick = this.getTickCount();
            }
            return;
        }
        for (Control<?> control : this.getDefinition().getModel().getControls()) {
            if (control.part.type != ModelComponentType.COUPLER_ENGAGED_X) continue;
            if (control.part.pos.contains(ModelComponentType.ModelPosition.FRONT) && this.isCouplerEngaged(CouplerType.FRONT) ^ (double)this.getControlPosition(control) < 0.5) {
                this.setCouplerEngaged(CouplerType.FRONT, (double)this.getControlPosition(control) < 0.5);
            }
            if (!control.part.pos.contains(ModelComponentType.ModelPosition.REAR) || !(this.isCouplerEngaged(CouplerType.BACK) ^ (double)this.getControlPosition(control) < 0.5)) continue;
            this.setCouplerEngaged(CouplerType.BACK, (double)this.getControlPosition(control) < 0.5);
        }
        if (this.getTickCount() % 5 == 0) {
            this.hasElectricalPower = false;
            this.mapTrain(this, false, stock -> {
                this.hasElectricalPower = this.hasElectricalPower || stock instanceof Locomotive && ((Locomotive)((Object)stock)).providesElectricalPower();
            });
        }
        this.hadElectricalPower = this.hasElectricalPower();
        if (this.getCurrentState() != null && !this.getCurrentState().atRest || Config.ConfigDebug.keepStockLoaded) {
            this.keepLoaded();
        }
        this.slackFrontPercent = 0.0f;
        this.slackRearPercent = 0.0f;
        SimulationState state = this.getCurrentState();
        if (state != null) {
            this.setCoupledUUID(CouplerType.FRONT, state.interactingFront);
            this.setCoupledUUID(CouplerType.BACK, state.interactingRear);
            this.consist = state.consist;
            if (this.getCoupledUUID(CouplerType.FRONT) != null) {
                EntityCoupleableRollingStock front = this.getCoupled(CouplerType.FRONT);
                if (front != null) {
                    this.lastKnownFront = front.getBlockPosition();
                }
            } else {
                this.lastKnownFront = null;
            }
            if (this.getCoupledUUID(CouplerType.BACK) != null) {
                EntityCoupleableRollingStock rear = this.getCoupled(CouplerType.BACK);
                if (rear != null) {
                    this.lastKnownRear = rear.getBlockPosition();
                }
            } else {
                this.lastKnownRear = null;
            }
            this.slackFrontPercent = state.slackFrontPercent;
            this.slackRearPercent = state.slackRearPercent;
        }
    }

    public void keepLoaded() {
        World world = this.getWorld();
        world.keepLoaded(this.getBlockPosition());
        if (this.getCurrentState() != null && !this.getCurrentState().atRest) {
            world.keepLoaded(new Vec3i(this.guessCouplerPosition(CouplerType.FRONT)));
            world.keepLoaded(new Vec3i(this.guessCouplerPosition(CouplerType.BACK)));
        }
    }

    private Vec3d guessCouplerPosition(CouplerType coupler) {
        return this.getPosition().add(VecUtil.fromWrongYaw(this.getDefinition().getLength(this.gauge) / 2.0 * (double)(coupler == CouplerType.FRONT ? 1 : -1), this.getRotationYaw()));
    }

    public final void setCoupledUUID(CouplerType coupler, UUID id) {
        UUID target;
        UUID uUID = target = coupler == CouplerType.FRONT ? this.coupledFront : this.coupledBack;
        if (Objects.equals(target, id)) {
            return;
        }
        if (target == null && this.isCouplerEngaged(coupler)) {
            new SoundPacket(this.getDefinition().couple_sound, this.getCouplerPosition(coupler), this.getVelocity(), 1.0f, 1.0f, (int)(200.0 * this.gauge.scale()), this.soundScale(), SoundPacket.PacketSoundCategory.COUPLE).sendToObserving((Entity)this);
        }
        switch (coupler) {
            case FRONT: {
                this.coupledFront = id;
                break;
            }
            case BACK: {
                this.coupledBack = id;
            }
        }
    }

    public final UUID getCoupledUUID(CouplerType coupler) {
        switch (coupler) {
            case FRONT: {
                return this.coupledFront;
            }
            case BACK: {
                return this.coupledBack;
            }
        }
        return null;
    }

    public EntityCoupleableRollingStock getCoupled(CouplerType coupler) {
        if (this.getCoupledUUID(coupler) != null) {
            return this.findByUUID(this.getCoupledUUID(coupler));
        }
        return null;
    }

    public CouplerType getCouplerFor(EntityCoupleableRollingStock stock) {
        if (stock == null) {
            return null;
        }
        for (CouplerType coupler : CouplerType.values()) {
            if (!stock.getUUID().equals(this.getCoupledUUID(coupler))) continue;
            return coupler;
        }
        return null;
    }

    public boolean isCouplerEngaged(CouplerType coupler) {
        if (coupler == null) {
            return false;
        }
        switch (coupler) {
            case FRONT: {
                return this.frontCouplerEngaged;
            }
            case BACK: {
                return this.backCouplerEngaged;
            }
        }
        return false;
    }

    public void setCouplerEngaged(CouplerType coupler, boolean engaged) {
        switch (coupler) {
            case FRONT: {
                this.frontCouplerEngaged = engaged;
                for (Control<?> control : this.getDefinition().getModel().getControls()) {
                    if (control.part.type != ModelComponentType.COUPLER_ENGAGED_X || !control.part.pos.contains(ModelComponentType.ModelPosition.FRONT)) continue;
                    this.setControlPosition(control, engaged ? 0.0f : 1.0f);
                }
                break;
            }
            case BACK: {
                this.backCouplerEngaged = engaged;
                for (Control<?> control : this.getDefinition().getModel().getControls()) {
                    if (control.part.type != ModelComponentType.COUPLER_ENGAGED_X || !control.part.pos.contains(ModelComponentType.ModelPosition.REAR)) continue;
                    this.setControlPosition(control, engaged ? 0.0f : 1.0f);
                }
                break;
            }
        }
    }

    public final boolean isCoupled() {
        return this.isCoupled(CouplerType.FRONT) && this.isCoupled(CouplerType.BACK);
    }

    public final boolean isCoupled(CouplerType coupler) {
        return this.getCoupledUUID(coupler) != null;
    }

    public Vec3d getCouplerPosition(CouplerType coupler) {
        SimulationState state = this.getCurrentState();
        if (state != null) {
            return coupler == CouplerType.FRONT ? state.couplerPositionFront : state.couplerPositionRear;
        }
        return this.getPosition();
    }

    public final List<EntityCoupleableRollingStock> getTrain() {
        return this.getTrain(true);
    }

    public final List<EntityCoupleableRollingStock> getTrain(boolean followDisengaged) {
        ArrayList<EntityCoupleableRollingStock> train = new ArrayList<EntityCoupleableRollingStock>();
        this.mapTrain(this, followDisengaged, train::add);
        return train;
    }

    public final void mapTrain(EntityCoupleableRollingStock prev, boolean followDisengaged, Consumer<EntityCoupleableRollingStock> fn) {
        this.mapTrain(prev, true, followDisengaged, (e, b) -> fn.accept((EntityCoupleableRollingStock)((Object)e)));
    }

    public final void mapTrain(EntityCoupleableRollingStock prev, boolean direction, boolean followDisengaged, BiConsumer<EntityCoupleableRollingStock, Boolean> fn) {
        for (DirectionalStock stock : this.getDirectionalTrain(followDisengaged)) {
            fn.accept(stock.stock, stock.direction);
        }
    }

    public Collection<DirectionalStock> getDirectionalTrain(boolean followDisengaged) {
        HashSet<UUID> trainMap = new HashSet<UUID>();
        ArrayList<DirectionalStock> trainList = new ArrayList<DirectionalStock>();
        Function<DirectionalStock, DirectionalStock> next = current -> {
            for (CouplerType coupler : CouplerType.values()) {
                EntityCoupleableRollingStock coupled;
                EntityCoupleableRollingStock stock = current.stock;
                boolean direction = current.direction;
                if (stock.getCoupledUUID(coupler) == null || trainMap.contains(stock.getCoupledUUID(coupler)) || !followDisengaged && !stock.isCouplerEngaged(coupler) || (coupled = stock.getCoupled(coupler)) == null) continue;
                CouplerType otherCoupler = coupled.getCouplerFor(stock);
                if (!followDisengaged && !coupled.isCouplerEngaged(otherCoupler)) continue;
                return new DirectionalStock(stock, coupled, coupler.opposite() == otherCoupler ? direction : !direction);
            }
            return null;
        };
        DirectionalStock start = new DirectionalStock(null, this, true);
        trainMap.add(start.stock.getUUID());
        trainList.add(start);
        for (int i = 0; i < 2; ++i) {
            DirectionalStock current2 = next.apply(start);
            while (current2 != null) {
                trainMap.add(current2.stock.getUUID());
                trainList.add(current2);
                current2 = next.apply(current2);
            }
        }
        return trainList;
    }

    public EntityCoupleableRollingStock findByUUID(UUID uuid) {
        return (EntityCoupleableRollingStock)this.getWorld().getEntity(uuid, EntityCoupleableRollingStock.class);
    }

    @Override
    public void setControlPosition(Control<?> component, float val) {
        super.setControlPosition(component, val);
        if (component.global) {
            this.mapTrain(this, false, stock -> stock.controlPositions.put(component.controlGroup, this.getControlData(component)));
        }
    }

    @Override
    public boolean hasElectricalPower() {
        return this.hasElectricalPower && (this.gotElectricalPowerTick == -1 || this.getTickCount() - this.gotElectricalPowerTick > 15 || (this.getTickCount() - this.gotElectricalPowerTick) / (int)((Math.random() + 2.0) * 4.0) % 2 == 0);
    }

    static {
        World.onTick(world -> {
            if (world.isClient) {
                return;
            }
            if (Config.ConfigDebug.lagServer > 0) {
                try {
                    Thread.sleep(Config.ConfigDebug.lagServer);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Simulation.simulate(world);
        });
    }

    public static class DirectionalStock {
        public final EntityCoupleableRollingStock prev;
        public final EntityCoupleableRollingStock stock;
        public final boolean direction;

        public DirectionalStock(EntityCoupleableRollingStock prev, EntityCoupleableRollingStock stock, boolean direction) {
            this.prev = prev;
            this.stock = stock;
            this.direction = direction;
        }
    }

    public static enum CouplerType {
        FRONT(0.0f),
        BACK(180.0f);

        public final float yaw;

        private CouplerType(float yaw) {
            this.yaw = yaw;
        }

        public CouplerType opposite() {
            return this == FRONT ? BACK : FRONT;
        }

        public String toString() {
            return (this == FRONT ? ChatText.COUPLER_FRONT : ChatText.COUPLER_BACK).toString();
        }
    }
}

