/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="torchmaster")
@Mod.EventBusSubscriber(modid="torchmaster")
public class TorchmasterConfig {
    @Config.RangeInt(min=0, max=512)
    @Config.Comment(value={"The radius of the spawn prevention. (Monster)"})
    public static int MegaTorchRange = 64;
    @Config.Comment(value={"The lighter item to light an unlit torch, see https://github.com/Xalcon/TorchMaster/wiki/Torch-Burnout for more info."})
    public static String[] MegaTorchLighterItems = new String[]{"minecraft:flint_and_steel"};
    @Config.RangeInt(min=0)
    @Config.Comment(value={"The speed at which the torch will extinguish. Set to 0 to disable."})
    public static int MegaTorchBurnoutRate = 0;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"The burnout value. This value is removed by the amount of burnout rate per tick"})
    public static int MegaTorchBurnoutValue = 1;
    @Config.Comment(value={"If set to true, the mega torch will drop as an unlit torch when harvesting it"})
    public static boolean MegaTorchExtinguishOnHarvest = false;
    @Config.Comment(value={"Allows to get the lit torch when harvested with silk touch. Has no effect if MegaTorchExtinguishOnHarvest is false)"})
    public static boolean MegaTorchAllowSilkTouch = true;
    @Config.Comment(value={"Controls if the mega torch should allow mob spawning from vanilla spawners"})
    public static boolean MegaTorchAllowVanillaSpawners = true;
    @Config.Comment(value={"Controls the amount of blocks between each segment in the visualizer", "You can increase this value in case you prefer less lines in the volume visualization", "or if the visualization causes a big FPS hit to your potato.", "Do not increase this value above the torch range or you might break the rendering.", "Higher values will render less lines. 1.0 = 1 block per segment, 2.0 = 2 blocks per segment"})
    @Config.RangeDouble(min=0.5)
    public static float TorchVisualizerSegmentationFactor = 2.0f;
    @Config.RangeInt(min=0, max=512)
    @Config.Comment(value={"The radius of the spawn prevention. (Passive Animals)"})
    public static int DreadLampRange = 64;
    @Config.Comment(value={"Some mods override the same method as torchmaster to handle mob spawning. Setting this to true might help with certain mods still being able to spawn things. (Unlikely though)"})
    public static boolean slighlyMoreAggressiveBlocking = false;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"The amount of torches to place in each direction. The effective range is multiplied by the torch spacing (32 * 5 = 160 blocks, default 7 * 5 = 35 blocks)"})
    public static int TerrainLighterTorchCount = 7;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"The spacing between each torch. Distance of 5 means there will be a torch every 5 blocks with 4 blocks space in between."})
    public static int TerrainLighterSpacing = 5;
    @Config.RangeInt(min=0, max=512)
    @Config.Comment(value={"This controls which torches are supported by the terrain lighter"})
    public static String[] TerrainLighterTorches = new String[]{"minecraft:torch", "tconstruct:stone_torch"};
    @Config.Comment(value={"Adds additional information about torchmaster items into the tooltip"})
    public static boolean BeginnerTooltips = true;
    @Config.Comment(value={"If this setting is enabled, the mega torch will block all natural spawn attempts from Lycanites Mobs in its radius"})
    @Config.RequiresMcRestart
    public static boolean LycanitesMobsBlockAll = true;
    @Config.Comment(value={"If this setting is enabled, the mega torch will block all natural spawn attempts from MoCreatures in its radius"})
    @Config.RequiresMcRestart
    public static boolean MoCreaturesBlockAll = true;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"The radius in which the feral flare should try to place lights"})
    public static int feralFlareRadius = 16;
    @Config.RangeInt(min=1)
    @Config.Comment(value={"Controls how often the flare should try to place lights. 1 means every tick, 10 every 10th tick, etc"})
    public static int feralFlareTickRate = 5;
    @Config.RangeInt(min=1, max=15)
    @Config.Comment(value={"The target minimum light level to place lights for"})
    public static int feralFlareMinLightLevel = 10;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"The maximum amount of invisble lights a feral flare lantern can place. Set to 0 to disable light placement.", "Warning: Setting this value too high in conjunction with the feralFlareMinLightLevel and Radius can lead to world corruption!", "(Badly compressed packet error)"})
    public static int FeralFlareLanternLightCountHardcap = 255;
    @Config.Comment(value={"If false, lights decay slowly after the lantern has been removed. If true, the lights will be removed instantly"})
    public static boolean feralFlareLightDecayInstantly = false;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Durability of the frozen pearl. Each removed light will remove one charge from the pearl. Set to 0 to disable durability"})
    @Config.RequiresMcRestart
    public static int frozenPearlDurability = 1024;
    @Config.Comment(value={"Use this setting to override the internal lists for entity blocking", "You can use this to block more entities or even allow certain entities to still spawn", "The + prefix will add the entity to the list, effectivly denying its spawns", "The - prefix will remove the entity from the list (if necessary), effectivly allowing its spawns", "Block zombies: +minecraft:zombie", "Allow creepers: -minecraft:creeper"})
    @Config.RequiresMcRestart
    public static String[] MegaTorchEntityBlockListOverrides = new String[0];
    @Config.Comment(value={"Same as the mega torch block list override, just for the dread lamp", "Block squid: +minecraft:squid", "Allow pigs: -minecraft:pig"})
    @Config.RequiresMcRestart
    public static String[] DreadLampEntityBlockListOverrides = new String[0];

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("torchmaster")) {
            ConfigManager.sync((String)"torchmaster", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

