/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class MyReflectionHelper {
    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name.replace('/', '.'));
        }
        catch (java.lang.ClassNotFoundException e) {
            throw new ClassNotFoundException(e);
        }
    }

    public static <T> T getPublicField(Object instance, String fieldName) throws UnableToAccessFieldException {
        try {
            Field field = instance.getClass().getField(fieldName);
            return (T)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new UnableToAccessFieldException(instance.getClass().getName(), e);
        }
    }

    public static <T> T getPublicStaticField(Class<?> classToAccess, String fieldName) throws UnableToAccessFieldException {
        try {
            Field field = classToAccess.getField(fieldName);
            return (T)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new UnableToAccessFieldException(classToAccess.getName(), e);
        }
    }

    public static <T> T getPublicStaticField(String classToAccess, String fieldName) throws UnableToAccessFieldException {
        Class<?> clazz = MyReflectionHelper.getClass(classToAccess);
        try {
            Field field = clazz.getField(fieldName);
            return (T)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new UnableToAccessFieldException(classToAccess, e);
        }
    }

    public static void setPublicField(Object instance, String fieldName, Object value) throws UnableToAccessFieldException {
        try {
            Field field = instance.getClass().getField(fieldName);
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new UnableToAccessFieldException(instance.getClass().getName(), e);
        }
    }

    public static <T> T invokePublicMethod(Object instance, String methodName, Object ... args) {
        Class<?>[] types = MyReflectionHelper.fromArgs(args);
        try {
            Method method = instance.getClass().getMethod(methodName, types);
            method.setAccessible(true);
            return (T)method.invoke(instance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnableToInvokeException(instance.getClass().getName(), e);
        }
    }

    public static <T> T getPrivateField(@Nonnull Object instance, String fieldName) throws UnableToAccessFieldException {
        return MyReflectionHelper.getPrivateFieldInternal(instance.getClass(), instance, fieldName);
    }

    public static <T> T getPrivateStaticField(Class<?> classToAccess, String fieldName) throws UnableToAccessFieldException {
        return MyReflectionHelper.getPrivateFieldInternal(classToAccess, null, fieldName);
    }

    public static <T> T getPrivateField(Class<?> classToAccess, @Nonnull Object instance, String fieldName) throws UnableToAccessFieldException {
        return MyReflectionHelper.getPrivateFieldInternal(classToAccess, instance, fieldName);
    }

    public static <T> T getPrivateField(String classToAccess, @Nonnull Object instance, String fieldName) throws UnableToAccessFieldException {
        Class<?> clazz = MyReflectionHelper.getClass(classToAccess);
        return MyReflectionHelper.getPrivateField(clazz, instance, fieldName);
    }

    public static <T> T getPrivateStaticField(String classToAccess, String fieldName) throws UnableToAccessFieldException {
        Class<?> clazz = MyReflectionHelper.getClass(classToAccess);
        return MyReflectionHelper.getPrivateStaticField(clazz, fieldName);
    }

    public static void setPrivateField(@Nonnull Object instance, String fieldName, Object value) throws UnableToAccessFieldException {
        MyReflectionHelper.setPrivateFieldInternal(instance.getClass(), instance, fieldName, value);
    }

    public static void setPrivateStaticField(Class<?> classToAccess, String fieldName, Object value) throws UnableToAccessFieldException {
        MyReflectionHelper.setPrivateFieldInternal(classToAccess, null, fieldName, value);
    }

    public static void setPrivateField(Class<?> classToAccess, @Nonnull Object instance, String fieldName, Object value) throws UnableToAccessFieldException {
        MyReflectionHelper.setPrivateFieldInternal(classToAccess, instance, fieldName, value);
    }

    public static void setPrivateField(String classToAccess, @Nonnull Object instance, String fieldName, Object value) throws UnableToAccessFieldException {
        Class<?> clazz = MyReflectionHelper.getClass(classToAccess);
        MyReflectionHelper.setPrivateField(clazz, instance, fieldName, value);
    }

    public static void setPrivateStaticField(String classToAccess, String fieldName, Object value) throws UnableToAccessFieldException {
        Class<?> clazz = MyReflectionHelper.getClass(classToAccess);
        MyReflectionHelper.setPrivateStaticField(clazz, fieldName, value);
    }

    public static <T> T invokePrivateMethod(@Nonnull Object instance, String methodName, Class<?>[] parameterTypes, Object[] args) {
        return MyReflectionHelper.invokePrivateMethodInternal(instance.getClass(), instance, methodName, parameterTypes, args);
    }

    public static <T> T invokePrivateStaticMethod(Class<?> classToAccess, String methodName, Class<?>[] parameterTypes, Object[] args) {
        return MyReflectionHelper.invokePrivateMethodInternal(classToAccess, null, methodName, parameterTypes, args);
    }

    public static <T> T invokePrivateMethod(@Nonnull Object instance, String methodName, Object ... args) {
        return MyReflectionHelper.invokePrivateMethodInternal(instance.getClass(), instance, methodName, args);
    }

    public static <T> T invokePrivateStaticMethod(Class<?> classToAccess, String methodName, Object ... args) {
        return MyReflectionHelper.invokePrivateMethodInternal(classToAccess, null, methodName, args);
    }

    public static <T> T invokePrivateMethod(Class<?> classToAccess, @Nonnull Object instance, String methodName, Class<?>[] parameterTypes, Object[] args) {
        return MyReflectionHelper.invokePrivateMethodInternal(classToAccess, instance, methodName, parameterTypes, args);
    }

    public static <T> T invokePrivateMethod(Class<?> classToAccess, @Nonnull Object instance, String methodName, Object ... args) {
        return MyReflectionHelper.invokePrivateMethodInternal(classToAccess, instance, methodName, args);
    }

    private static <T> T getPrivateFieldInternal(Class<?> classToAccess, @Nullable Object instance, String fieldName) throws UnableToAccessFieldException {
        try {
            Field field = classToAccess.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new UnableToAccessFieldException(classToAccess.getName(), e);
        }
    }

    private static <T> void setPrivateFieldInternal(Class<?> classToAccess, @Nullable Object instance, String fieldName, Object value) throws UnableToAccessFieldException {
        try {
            Field field = classToAccess.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new UnableToAccessFieldException(classToAccess.getName(), e);
        }
    }

    private static <T> T invokePrivateMethodInternal(Class<?> classToAccess, @Nullable Object instance, String methodName, Object ... args) {
        Class<?>[] types = MyReflectionHelper.fromArgs(args);
        return MyReflectionHelper.invokePrivateMethodInternal(classToAccess, instance, methodName, types, args);
    }

    private static <T> T invokePrivateMethodInternal(Class<?> classToAccess, @Nullable Object instance, String methodName, Class<?>[] parameterTypes, Object[] args) {
        try {
            Method method = classToAccess.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return (T)method.invoke(instance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnableToInvokeException(classToAccess.getName(), e);
        }
    }

    public static <T> T getObfPrivateValue(Object instance, String fieldName, @Nullable String fieldSrgName) throws UnableToAccessFieldException {
        return MyReflectionHelper.getObfPrivateValue(instance.getClass(), instance, fieldName, fieldSrgName);
    }

    public static <T> T getObfPrivateValue(Class<?> classToAccess, @Nullable Object instance, String fieldName, @Nullable String fieldSrgName) throws UnableToAccessFieldException {
        return (T)ReflectionHelper.getPrivateValue(classToAccess, (Object)instance, (String)fieldName, (String)fieldSrgName);
    }

    public static <T> void setObfPrivateValue(Class<?> classToAccess, @Nullable Object instance, @Nullable Object value, String fieldName, @Nullable String fieldSrgName) throws UnableToAccessFieldException {
        ReflectionHelper.setPrivateValue(classToAccess, (Object)instance, (Object)value, (String)fieldName, (String)fieldSrgName);
    }

    public static <T> T invokeObfPrivateMethod(Object instance, String methodName, @Nullable String methodSrgName, Object ... args) throws UnableToInvokeException {
        return MyReflectionHelper.invokeObfPrivateMethod(instance.getClass(), instance, methodName, methodSrgName, args);
    }

    public static <T> T invokeObfPrivateMethod(Class<?> classToAccess, @Nullable Object instance, String methodName, @Nullable String methodSrgName, Object ... args) throws UnableToInvokeException {
        return MyReflectionHelper.invokeObfPrivateMethod(classToAccess, instance, methodName, methodSrgName, MyReflectionHelper.fromArgs(args), args);
    }

    public static <T> T invokeObfPrivateMethod(Class<?> classToAccess, @Nullable Object instance, String methodName, @Nullable String methodSrgName, Class<?>[] parameterTypes, Object[] args) throws UnableToInvokeException {
        Method method = ReflectionHelper.findMethod(classToAccess, (String)methodName, (String)methodSrgName, (Class[])parameterTypes);
        try {
            return (T)method.invoke(instance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UnableToInvokeException(classToAccess.getName(), e);
        }
    }

    private static Class<?>[] fromArgs(Object ... args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Class<Object> type = arg.getClass();
            if (type == Boolean.class) {
                type = Boolean.TYPE;
            } else if (type == Integer.class) {
                type = Integer.TYPE;
            } else if (type == Short.class) {
                type = Short.TYPE;
            } else if (type == Character.class) {
                type = Character.TYPE;
            } else if (type == Byte.class) {
                type = Byte.TYPE;
            } else if (type == Long.class) {
                type = Long.TYPE;
            } else if (type == Float.class) {
                type = Float.TYPE;
            } else if (type == Double.class) {
                type = Double.TYPE;
            }
            types[i] = type;
        }
        return types;
    }

    public static class ClassNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ClassNotFoundException(Exception e) {
            super(e);
        }
    }

    public static class UnableToAccessFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToAccessFieldException(String className, Exception e) {
            super(e.toString() + " of class " + className, e);
        }
    }

    public static class UnableToInvokeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToInvokeException(String className, Exception e) {
            super(e.toString() + " of class " + className, e);
        }
    }
}

