/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core.adapters;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import kpan.nutrition_gtceu.asm.core.AsmUtil;
import kpan.nutrition_gtceu.asm.core.MyAsmNameRemapper;
import kpan.nutrition_gtceu.asm.core.adapters.MyClassVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class ReplaceMethodAdapter
extends MyClassVisitor {
    protected final String runtimeName;
    protected final String runtimeDesc;
    protected int access;
    @Nullable
    protected String runtimeGenerics;
    @Nullable
    protected String[] runtimeExceptions;
    protected boolean useAccess = false;
    protected boolean useGenerics = false;
    protected boolean useExceptions = false;
    private boolean found = false;

    public ReplaceMethodAdapter(ClassVisitor cv, MyAsmNameRemapper.MethodRemap method) {
        super(cv, method.mcpMethodName + " " + method.deobfMethodDesc);
        this.runtimeName = MyAsmNameRemapper.runtimeMethod(method);
        this.runtimeDesc = AsmUtil.runtimeDesc(method.deobfMethodDesc);
    }

    public ReplaceMethodAdapter(ClassVisitor cv, String runtimeMethodName, String runtimeDesc) {
        super(cv, runtimeMethodName + " " + runtimeDesc);
        this.runtimeName = runtimeMethodName;
        this.runtimeDesc = runtimeDesc;
    }

    public void setAccess(int access) {
        this.access = access;
        this.useAccess = true;
    }

    public void setGenerics(String deobfGenerics) {
        this.runtimeGenerics = AsmUtil.runtimeMethodGenerics(deobfGenerics);
        this.useGenerics = true;
    }

    public void setExceptions(String[] deobfExceptions) {
        this.runtimeExceptions = AsmUtil.runtimeExceptions(deobfExceptions);
        this.useExceptions = true;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isTarget(access, name, desc, signature, exceptions)) {
            this.found = true;
            if (!this.useAccess) {
                this.access = access;
            }
            if (!this.useGenerics) {
                this.runtimeGenerics = signature;
            }
            if (!this.useExceptions) {
                this.runtimeExceptions = exceptions;
            }
            return null;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.found) {
            MethodVisitor mv = super.visitMethod(this.access, this.runtimeName, this.runtimeDesc, this.runtimeGenerics, this.runtimeExceptions);
            if (mv != null) {
                mv.visitCode();
                this.methodBody(mv);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            this.success();
        }
        super.visitEnd();
    }

    protected abstract void methodBody(MethodVisitor var1);

    private boolean isTarget(int access, String name, String desc, String signature, String[] exceptions) {
        if (!name.equals(this.runtimeName)) {
            return false;
        }
        if (this.runtimeDesc != null && !desc.equals(this.runtimeDesc)) {
            return false;
        }
        if (this.useAccess && access != this.access) {
            return false;
        }
        if (this.useGenerics && !ReplaceMethodAdapter.equals(signature, this.runtimeGenerics)) {
            return false;
        }
        return !this.useExceptions || Arrays.equals(exceptions, this.runtimeExceptions);
    }

    private static boolean equals(Object a, Object b) {
        return Objects.equals(a, b);
    }
}

