/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core.adapters;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import kpan.nutrition_gtceu.asm.core.adapters.Instructions;
import kpan.nutrition_gtceu.asm.core.adapters.MyMethodVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ReplaceInstructionsAdapter
extends MyMethodVisitor {
    protected final Instructions targets;
    protected final Instructions instructions;
    protected final ArrayList<Instructions.Instr> holds = Lists.newArrayList();
    private int maxMatched = 0;

    public ReplaceInstructionsAdapter(@Nonnull MethodVisitor mv, String name, Instructions targets, Instructions instructions) {
        super(mv, name);
        this.targets = targets;
        this.instructions = instructions;
    }

    protected final boolean check(Instructions.Instr instr) {
        Instructions.Instr instr2 = this.targets.get(this.holds.size());
        instr2.solveLabel(this);
        if (instr.equals(instr2)) {
            this.holds.add(instr);
            if (this.holds.size() == this.targets.size()) {
                this.visitAllInstructions();
                this.holds.clear();
                this.success();
            }
            return true;
        }
        for (int start = 1; start < this.holds.size(); ++start) {
            if (!this.extracted(start)) continue;
            for (int i = 0; i < start; ++i) {
                this.holds.get(i).visit(this.mv, this);
            }
            this.holds.subList(0, start).clear();
            return true;
        }
        this.flushVisits();
        return false;
    }

    private boolean extracted(int start) {
        for (int i = 0; i < this.holds.size() - start; ++i) {
            Instructions.Instr instr = this.holds.get(start + i);
            if (instr.equals(this.targets.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void visitAllInstructions() {
        for (Instructions.Instr instruction : this.instructions) {
            instruction.visit(this.mv, this);
        }
    }

    protected final void flushVisits() {
        this.maxMatched = Math.max(this.maxMatched, this.holds.size());
        for (Instructions.Instr element : this.holds) {
            element.visit(this.mv, this);
        }
        this.holds.clear();
    }

    @Override
    public void visitEnd() {
        this.flushVisits();
        try {
            super.visitEnd();
        }
        catch (Exception e) {
            System.out.println("maxMatch:" + this.maxMatched);
            throw e;
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (!this.check(Instructions.Instr.fieldInsn(opcode, owner, name, desc))) {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void visitIincInsn(int var, int increment) {
        if (!this.check(Instructions.Instr.iincInsn(var, increment))) {
            super.visitIincInsn(var, increment);
        }
    }

    public void visitInsn(int opcode) {
        if (!this.check(Instructions.Instr.insn(opcode))) {
            super.visitInsn(opcode);
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        if (!this.check(Instructions.Instr.intInsn(opcode, operand))) {
            super.visitIntInsn(opcode, operand);
        }
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        if (!this.check(Instructions.Instr.dynamicInsn(name, desc, bsm, bsmArgs))) {
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.updateLabels(label);
        if (!this.check(Instructions.Instr.jumpInsn(opcode, label)) && this.mv != null) {
            this.mv.visitJumpInsn(opcode, label);
        }
    }

    @Override
    public void visitLabel(Label label) {
        this.updateLabels(label);
        if (!this.check(Instructions.Instr.label(label)) && this.mv != null) {
            super.visitLabel(label);
        }
    }

    public void visitLdcInsn(Object cst) {
        if (!this.check(Instructions.Instr.ldcInsn(cst))) {
            super.visitLdcInsn(cst);
        }
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.flushVisits();
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.flushVisits();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.api < 327680 || !this.check(Instructions.Instr.methodInsn(opcode, owner, name, desc, itf))) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.api >= 327680 || !this.check(Instructions.Instr.methodInsn(opcode, owner, name, desc, opcode == 185))) {
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.flushVisits();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.flushVisits();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.flushVisits();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitTypeInsn(int opcode, String type) {
        if (!this.check(Instructions.Instr.typeInsn(opcode, type))) {
            super.visitTypeInsn(opcode, type);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (!this.check(Instructions.Instr.varInsn(opcode, var))) {
            super.visitVarInsn(opcode, var);
        }
    }
}

