/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core.adapters;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import kpan.nutrition_gtceu.asm.core.AccessTransformerForMixin;
import kpan.nutrition_gtceu.asm.core.AsmTypes;
import kpan.nutrition_gtceu.asm.core.AsmUtil;
import kpan.nutrition_gtceu.asm.core.MyAsmNameRemapper;
import kpan.nutrition_gtceu.asm.core.adapters.MyClassVisitor;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.TypePath;

public class MixinAccessorAdapter
extends MyClassVisitor {
    private final String deobfTargetClassName;
    private final Class<?> accessor;
    private final HashMap<String, RuntimeInfo> fieldInfoMap = new HashMap();
    private final HashMap<String, MethodInfo> methodInfoMap = new HashMap();
    private static String mixinTarget = null;

    public MixinAccessorAdapter(ClassVisitor cv, String deobfTargetClassName, String accessorClassName) {
        super(cv, deobfTargetClassName);
        this.deobfTargetClassName = deobfTargetClassName;
        mixinTarget = deobfTargetClassName;
        try {
            this.accessor = Class.forName(accessorClassName.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        mixinTarget = null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, (String[])ArrayUtils.add((Object[])interfaces, (Object)this.accessor.getName().replace('.', '/')));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.fieldInfoMap.put(name, new RuntimeInfo(desc, (access & 8) != 0));
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.methodInfoMap.put(name, new MethodInfo(desc, (access & 8) != 0, (access & 2) != 0));
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        for (Method method : this.accessor.getMethods()) {
            String runtime_name;
            RuntimeInfo fieldInfo;
            String runtimeGenerics;
            String runtime_name2;
            String srg_name;
            String deobf_name;
            String methodName = method.getName();
            if (methodName.startsWith("get_")) {
                deobf_name = methodName.substring("get_".length());
                Class<?> type = method.getReturnType();
                boolean is_static = Modifier.isStatic(method.getModifiers());
                if (type == Void.TYPE) {
                    throw new IllegalStateException("return type of getter is void!:" + methodName);
                }
                if (method.getParameterCount() != 0) {
                    throw new IllegalStateException("parameters of getter are empty!:" + methodName);
                }
                srg_name = method.getAnnotation(SrgName.class) != null ? method.getAnnotation(SrgName.class).value() : deobf_name;
                runtime_name2 = MyAsmNameRemapper.runtimeField(new MyAsmNameRemapper.FieldRemap(this.deobfTargetClassName, deobf_name, type.getName(), srg_name));
                String runtime_desc = AsmUtil.runtimeDesc(AsmUtil.toDesc(type));
                if (method.getAnnotation(NewField.class) != null) {
                    FieldVisitor fv;
                    if (srg_name != null && !deobf_name.equals(srg_name) || !deobf_name.equals(runtime_name2)) {
                        throw new IllegalStateException("Field duplicated!:" + methodName);
                    }
                    if (!this.fieldInfoMap.containsKey(runtime_name2) && (fv = this.visitField(1 | (is_static ? 8 : 0), runtime_name2, runtime_desc, runtimeGenerics = null, null)) != null) {
                        fv.visitEnd();
                    }
                }
                if ((fieldInfo = this.fieldInfoMap.get(runtime_name2)) == null) {
                    throw new IllegalStateException("Unknown field:" + runtime_name2 + "(" + methodName + ")");
                }
                if (!fieldInfo.runtimeDesc.equals(runtime_desc)) {
                    throw new IllegalStateException("Unmatched field type:" + runtime_name2 + "(" + methodName + ")");
                }
                if (fieldInfo.isStatic != is_static) {
                    throw new IllegalStateException("Unmatched field access(static):" + runtime_name2 + "(" + methodName + ")");
                }
                MethodVisitor mv = this.visitMethod(1 | (is_static ? 8 : 0), methodName, AsmUtil.toMethodDesc(runtime_desc, new Object[0]), null, null);
                if (mv == null) continue;
                mv.visitCode();
                if (is_static) {
                    mv.visitFieldInsn(178, MyAsmNameRemapper.runtimeClass(this.deobfTargetClassName), runtime_name2, runtime_desc);
                } else {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, MyAsmNameRemapper.runtimeClass(this.deobfTargetClassName), runtime_name2, runtime_desc);
                }
                mv.visitInsn(AsmUtil.toReturnOpcode(runtime_desc));
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                continue;
            }
            if (methodName.startsWith("set_")) {
                deobf_name = methodName.substring("set_".length());
                Class<?> type = method.getParameterTypes()[0];
                boolean is_static = Modifier.isStatic(method.getModifiers());
                if (method.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException("return type of getter is not void!:" + methodName);
                }
                if (method.getParameterCount() != 1) {
                    throw new IllegalStateException("parameters num of getter is not 1!:" + methodName);
                }
                srg_name = method.getAnnotation(SrgName.class) != null ? method.getAnnotation(SrgName.class).value() : null;
                runtime_name2 = MyAsmNameRemapper.runtimeField(new MyAsmNameRemapper.FieldRemap(this.deobfTargetClassName, deobf_name, type.getName(), srg_name));
                String runtime_desc = AsmUtil.runtimeDesc(AsmUtil.toDesc(type));
                if (method.getAnnotation(NewField.class) != null) {
                    FieldVisitor fv;
                    if (srg_name != null && !deobf_name.equals(srg_name) || !deobf_name.equals(runtime_name2)) {
                        throw new IllegalStateException("Field duplicated!:" + methodName);
                    }
                    if (!this.fieldInfoMap.containsKey(runtime_name2) && (fv = this.visitField(1 | (is_static ? 8 : 0), runtime_name2, runtime_desc, runtimeGenerics = null, null)) != null) {
                        fv.visitEnd();
                    }
                }
                if ((fieldInfo = this.fieldInfoMap.get(runtime_name2)) == null) {
                    throw new IllegalStateException("Unknown field:" + runtime_name2 + "(" + methodName + ")");
                }
                if (!fieldInfo.runtimeDesc.equals(runtime_desc)) {
                    throw new IllegalStateException("Unmatched field type:" + runtime_name2 + "(" + methodName + ")");
                }
                if (fieldInfo.isStatic != is_static) {
                    throw new IllegalStateException("Unmatched field access(static):" + runtime_name2 + "(" + methodName + ")");
                }
                MethodVisitor mv = this.visitMethod(1 | (is_static ? 8 : 0), methodName, AsmUtil.toMethodDesc("V", runtime_desc), null, null);
                if (mv == null) continue;
                mv.visitCode();
                if (is_static) {
                    mv.visitVarInsn(AsmUtil.toLoadOpcode(runtime_desc), 0);
                    mv.visitFieldInsn(179, MyAsmNameRemapper.runtimeClass(this.deobfTargetClassName), runtime_name2, runtime_desc);
                } else {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(AsmUtil.toLoadOpcode(runtime_desc), 1);
                    mv.visitFieldInsn(181, MyAsmNameRemapper.runtimeClass(this.deobfTargetClassName), runtime_name2, runtime_desc);
                }
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                continue;
            }
            if (method.getAnnotation(NewMethod.class) != null) continue;
            String method_desc = AsmUtil.toDesc(method);
            boolean is_static = Modifier.isStatic(method.getModifiers());
            if (method.getAnnotation(SrgName.class) != null) {
                srg_name = method.getAnnotation(SrgName.class).value();
                runtime_name = MyAsmNameRemapper.runtimeMethod(new MyAsmNameRemapper.MethodRemap(this.deobfTargetClassName, methodName, method_desc, srg_name));
            } else {
                runtime_name = methodName;
            }
            if (methodName.equals(runtime_name)) {
                AccessTransformerForMixin.toPublic(this.deobfTargetClassName, methodName, method_desc);
                continue;
            }
            String runtime_desc = AsmUtil.runtimeDesc(method_desc);
            MethodInfo methodInfo = this.methodInfoMap.get(runtime_name);
            if (methodInfo == null) {
                throw new IllegalStateException("Unknown method:" + runtime_name + "(" + methodName + ")");
            }
            if (!methodInfo.runtimeDesc.equals(runtime_desc)) {
                throw new IllegalStateException("Unknown method desc:" + runtime_name + "(" + methodName + ")");
            }
            if (methodInfo.isStatic != is_static) {
                throw new IllegalStateException("Unknown method access(static):" + runtime_name + "(" + methodName + ")");
            }
            if (this.methodInfoMap.containsKey(methodName)) {
                throw new IllegalStateException("Duplicated method:" + runtime_name + "(" + methodName + ")");
            }
            boolean is_private = methodInfo.isPrivate;
            MethodVisitor mv = this.visitMethod(1 | (is_static ? 8 : 0), methodName, runtime_desc, null, null);
            if (mv == null) continue;
            mv.visitCode();
            int offset = 0;
            if (!is_static) {
                mv.visitVarInsn(25, 0);
                offset = 1;
            }
            for (int i = 0; i < method.getParameterCount(); ++i) {
                int opcode = AsmUtil.toLoadOpcode(AsmUtil.toDesc(method.getParameterTypes()[i]));
                mv.visitVarInsn(opcode, offset);
                if (opcode == 22 || opcode == Opcodes.DOUBLE) {
                    offset += 2;
                    continue;
                }
                ++offset;
            }
            if (is_static) {
                mv.visitMethodInsn(184, MyAsmNameRemapper.runtimeClass(this.deobfTargetClassName), runtime_name, runtime_desc, false);
            } else if (is_private) {
                mv.visitMethodInsn(183, MyAsmNameRemapper.runtimeClass(this.deobfTargetClassName), runtime_name, runtime_desc, false);
            } else {
                mv.visitMethodInsn(182, MyAsmNameRemapper.runtimeClass(this.deobfTargetClassName), runtime_name, runtime_desc, false);
            }
            mv.visitInsn(AsmUtil.toReturnOpcode(AsmUtil.toDesc(method.getReturnType())));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        this.success();
        super.visitEnd();
    }

    public static ClassVisitor transformAccessor(ClassVisitor cv, String transformedName) {
        if (mixinTarget == null || !transformedName.startsWith("kpan.nutrition_gtceu.asm.acc.")) {
            return cv;
        }
        cv = new MyClassVisitor(cv, transformedName, 0){

            public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ((access & 8) != 0) {
                    mv = new MethodVisitor(327680, mv){

                        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                        }

                        public void visitInsn(int opcode) {
                        }

                        public void visitIntInsn(int opcode, int operand) {
                        }

                        public void visitVarInsn(int opcode, int var) {
                        }

                        public void visitTypeInsn(int opcode, String type) {
                        }

                        public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                        }

                        public void visitMethodInsn(int opcode, String owner, String name2, String desc2) {
                        }

                        public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                        }

                        public void visitInvokeDynamicInsn(String name2, String desc2, Handle bsm, Object ... bsmArgs) {
                        }

                        public void visitJumpInsn(int opcode, Label label) {
                        }

                        public void visitLabel(Label label) {
                        }

                        public void visitLdcInsn(Object cst) {
                        }

                        public void visitIincInsn(int var, int increment) {
                        }

                        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                        }

                        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                        }

                        public void visitMultiANewArrayInsn(String desc2, int dims) {
                        }

                        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                            return null;
                        }

                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                        }

                        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                            return null;
                        }

                        public void visitLocalVariable(String name2, String desc2, String signature, Label start, Label end, int index) {
                        }

                        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc2, boolean visible) {
                            return null;
                        }

                        public void visitLineNumber(int line, Label start) {
                        }

                        public void visitMaxs(int maxStack, int maxLocals) {
                        }

                        public void visitEnd() {
                            if (name.startsWith("get_")) {
                                this.mv.visitMethodInsn(184, mixinTarget.replace('.', '/'), name, desc, false);
                                this.mv.visitInsn(AsmUtil.toReturnOpcode(desc.substring("()".length())));
                            } else if (name.startsWith("set_")) {
                                this.mv.visitVarInsn(AsmUtil.toLoadOpcode(desc.substring(1, desc.length() - 2)), 0);
                                this.mv.visitMethodInsn(184, mixinTarget.replace('.', '/'), name, desc, false);
                                this.mv.visitInsn(177);
                            } else {
                                AsmTypes.MethodDesc md = AsmTypes.MethodDesc.fromMethodDesc(desc);
                                AsmUtil.loadLocals(this.mv, md.paramsDesc, 0);
                                this.mv.visitMethodInsn(184, mixinTarget.replace('.', '/'), name, desc, false);
                                this.mv.visitInsn(AsmUtil.toReturnOpcode(md.returnDesc));
                            }
                            this.mv.visitMaxs(0, 0);
                            super.visitEnd();
                        }
                    };
                }
                return mv;
            }
        };
        return cv;
    }

    private static class RuntimeInfo {
        public final String runtimeDesc;
        public final boolean isStatic;

        private RuntimeInfo(String runtimeDesc, boolean isStatic) {
            this.runtimeDesc = runtimeDesc;
            this.isStatic = isStatic;
        }
    }

    private static class MethodInfo {
        public final String runtimeDesc;
        public final boolean isStatic;
        public final boolean isPrivate;

        private MethodInfo(String runtimeDesc, boolean isStatic, boolean isPrivate) {
            this.runtimeDesc = runtimeDesc;
            this.isStatic = isStatic;
            this.isPrivate = isPrivate;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface SrgName {
        public String value() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NewField {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NewMethod {
    }
}

