/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core.adapters;

import kpan.nutrition_gtceu.asm.core.adapters.Instructions;
import kpan.nutrition_gtceu.asm.core.adapters.MyMethodVisitor;
import kpan.nutrition_gtceu.asm.core.adapters.ReplaceInstructionsAdapter;
import org.objectweb.asm.MethodVisitor;

public class InjectInstructionsAdapter
extends ReplaceInstructionsAdapter {
    private final int injectIndex;

    public InjectInstructionsAdapter(MethodVisitor mv, String name, Instructions targets, Instructions instructions, int injectIndex) {
        super(mv, name, targets, instructions);
        if (injectIndex < 0) {
            injectIndex = targets.size() + injectIndex + 1;
        }
        this.injectIndex = injectIndex;
    }

    @Override
    protected void visitAllInstructions() {
        for (int i = 0; i < this.holds.size(); ++i) {
            if (i == this.injectIndex) {
                super.visitAllInstructions();
            }
            ((Instructions.Instr)this.holds.get(i)).visit(this.mv, this);
        }
        if (this.injectIndex >= this.holds.size()) {
            super.visitAllInstructions();
        }
    }

    public static InjectInstructionsAdapter before(MethodVisitor mv, String name, Instructions targets, Instructions instructions) {
        return new InjectInstructionsAdapter(mv, name, targets, instructions, 0);
    }

    public static InjectInstructionsAdapter after(MethodVisitor mv, String name, Instructions targets, Instructions instructions) {
        return new InjectInstructionsAdapter(mv, name, targets, instructions, -1);
    }

    public static ReplaceInstructionsAdapter beforeAfter(MethodVisitor mv, String name, Instructions targets, Instructions before, final Instructions after) {
        return new InjectInstructionsAdapter(mv, name, targets, before, 0){

            @Override
            protected void visitAllInstructions() {
                super.visitAllInstructions();
                for (Instructions.Instr instruction : after) {
                    instruction.visit(this.mv, this);
                }
            }
        };
    }

    public static MethodVisitor injectFirst(MethodVisitor mv, String nameForDebug, final Instructions instructions) {
        return new MyMethodVisitor(mv, nameForDebug){

            public void visitCode() {
                super.visitCode();
                for (Instructions.Instr instruction : instructions) {
                    instruction.visit(this.mv, this);
                }
                this.success();
            }
        };
    }

    public static MethodVisitor injectBeforeReturns(MethodVisitor mv, String nameForDebug, final Instructions instructions) {
        return new MyMethodVisitor(mv, nameForDebug){

            public void visitInsn(int opcode) {
                if (opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176 || opcode == 177) {
                    for (Instructions.Instr instruction : instructions) {
                        instruction.visit(this.mv, this);
                    }
                    this.success();
                }
                super.visitInsn(opcode);
            }

            @Override
            public void visitEnd() {
                if (this.mv != null) {
                    this.mv.visitEnd();
                }
            }
        };
    }
}

