/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import kpan.nutrition_gtceu.asm.core.AsmUtil;
import kpan.nutrition_gtceu.util.MyReflectionHelper;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.common.patcher.ClassPatchManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;

public class MyAsmNameRemapper {
    private static LaunchClassLoader classLoader;
    private static final Map<String, BiMap<String, String>> fieldObfSrgMap;
    private static final Map<String, BiMap<NameDescPair, NameDescPair>> methodObfSrgMap;
    private static final Set<String> srgMcpLoadedSet;
    private static Map<String, Map<String, String>> rawFieldMaps;
    private static Map<String, Map<String, String>> rawMethodMaps;

    public static void init() {
        if (classLoader == null) {
            classLoader = (LaunchClassLoader)MyReflectionHelper.getPrivateField(FMLDeobfuscatingRemapper.INSTANCE, "classLoader");
            MyAsmNameRemapper.loadDeobfMap();
            LogManager.getLogger().info("Obf Rename Mapping Loaded Completely");
        }
    }

    private static void loadDeobfMap() {
        rawFieldMaps = (Map)MyReflectionHelper.getPrivateField(FMLDeobfuscatingRemapper.INSTANCE, "rawFieldMaps");
        rawMethodMaps = (Map)MyReflectionHelper.getPrivateField(FMLDeobfuscatingRemapper.INSTANCE, "rawMethodMaps");
    }

    public static String runtimeClass(String deobfName) {
        if (AsmUtil.isDeobfEnvironment()) {
            return deobfName.replace('.', '/');
        }
        return MyAsmNameRemapper.getClassObfName(deobfName);
    }

    public static String runtimeField(FieldRemap fieldRemap) {
        if (AsmUtil.isDeobfEnvironment()) {
            return fieldRemap.mcpFieldName;
        }
        String obf_owner = MyAsmNameRemapper.getClassObfName(fieldRemap.deobfOwner);
        String srg_name = fieldRemap.srgFieldName;
        return MyAsmNameRemapper.srg2ObfFieldName(obf_owner, srg_name);
    }

    public static String runtimeMethod(MethodRemap methodRemap) {
        if (AsmUtil.isDeobfEnvironment()) {
            return methodRemap.mcpMethodName;
        }
        String obf_owner = MyAsmNameRemapper.getClassObfName(methodRemap.deobfOwner);
        String srg_name = methodRemap.srgMethodName;
        return MyAsmNameRemapper.srg2ObfMethodName(obf_owner, srg_name, AsmUtil.obfDesc(methodRemap.deobfMethodDesc));
    }

    public static String getClassDeobfName(String obfName) {
        obfName = obfName.replace('.', '/');
        return FMLDeobfuscatingRemapper.INSTANCE.map(obfName);
    }

    public static String getClassObfName(String deobfName) {
        deobfName = deobfName.replace('.', '/');
        return FMLDeobfuscatingRemapper.INSTANCE.unmap(deobfName);
    }

    public static String obf2SrgMethodName(String obfOwner, String obfName, String obfDesc) {
        BiMap<NameDescPair, NameDescPair> map = MyAsmNameRemapper.getMethodObf2SrgMap(obfOwner);
        if (map == null) {
            return obfName;
        }
        NameDescPair mcp_pair = (NameDescPair)map.get((Object)new NameDescPair(obfName, obfDesc));
        if (mcp_pair == null) {
            return obfName;
        }
        return mcp_pair.name;
    }

    public static String srg2ObfMethodName(String obfOwner, String srgName, String obfDesc) {
        BiMap<NameDescPair, NameDescPair> map = MyAsmNameRemapper.getMethodObf2SrgMap(obfOwner);
        if (map == null) {
            return srgName;
        }
        NameDescPair obf_pair = (NameDescPair)map.inverse().get((Object)new NameDescPair(srgName, obfDesc));
        if (obf_pair == null) {
            return srgName;
        }
        return obf_pair.name;
    }

    public static String obf2SrgFieldName(String obfOwner, String obfName) {
        BiMap<String, String> map = MyAsmNameRemapper.getFieldObf2SrgMap(obfOwner);
        if (map == null) {
            return obfName;
        }
        String srg_name = (String)map.get((Object)obfName);
        if (srg_name == null) {
            return obfName;
        }
        return srg_name;
    }

    public static String srg2ObfFieldName(String obfOwner, String srgName) {
        BiMap<String, String> map = MyAsmNameRemapper.getFieldObf2SrgMap(obfOwner);
        if (map == null) {
            return srgName;
        }
        String obf_name = (String)map.inverse().get((Object)srgName);
        if (obf_name == null) {
            return srgName;
        }
        return obf_name;
    }

    @Nullable
    private static BiMap<NameDescPair, NameDescPair> getMethodObf2SrgMap(String obfOwner) {
        if (!srgMcpLoadedSet.contains(obfOwner)) {
            MyAsmNameRemapper.findAndMergeSuperMaps(obfOwner);
        }
        return methodObfSrgMap.get(obfOwner);
    }

    @Nullable
    private static BiMap<String, String> getFieldObf2SrgMap(String obfOwner) {
        if (!srgMcpLoadedSet.contains(obfOwner)) {
            MyAsmNameRemapper.findAndMergeSuperMaps(obfOwner);
        }
        return fieldObfSrgMap.get(obfOwner);
    }

    private static void findAndMergeSuperMaps(String obfName) {
        try {
            String superName = null;
            String[] interfaces = new String[]{};
            byte[] classBytes = ClassPatchManager.INSTANCE.getPatchedResource(obfName, MyAsmNameRemapper.getClassDeobfName(obfName), classLoader);
            if (classBytes != null) {
                ClassReader cr = new ClassReader(classBytes);
                superName = cr.getSuperName();
                interfaces = cr.getInterfaces();
            }
            MyAsmNameRemapper.mergeSuperMaps(obfName, superName, interfaces);
            srgMcpLoadedSet.add(obfName);
        }
        catch (IOException e) {
            FMLLog.log.error("Error getting patched resource:", (Throwable)e);
        }
    }

    private static void mergeSuperMaps(String obfName, @Nullable String superName, String[] interfaces) {
        if (Strings.isNullOrEmpty((String)superName)) {
            return;
        }
        String deobf = MyAsmNameRemapper.getClassDeobfName(obfName);
        ImmutableList allParents = ImmutableList.builder().add((Object)superName).addAll(Arrays.asList(interfaces)).build();
        for (String parentThing : allParents) {
            if (fieldObfSrgMap.containsKey(parentThing)) continue;
            MyAsmNameRemapper.findAndMergeSuperMaps(parentThing);
        }
        HashBiMap method_obfsrg_map = HashBiMap.create();
        HashBiMap field_obfsrg_map = HashBiMap.create();
        for (String string : allParents) {
            String deobf_parent = MyAsmNameRemapper.getClassDeobfName(string);
            if (methodObfSrgMap.containsKey(string)) {
                method_obfsrg_map.putAll((Map)methodObfSrgMap.get(string));
            }
            if (!fieldObfSrgMap.containsKey(string)) continue;
            field_obfsrg_map.putAll((Map)fieldObfSrgMap.get(string));
        }
        if (rawMethodMaps.containsKey(obfName)) {
            for (Map.Entry entry : rawMethodMaps.get(obfName).entrySet()) {
                String[] split_obf = ((String)entry.getKey()).split("\\(");
                String name_obf = split_obf[0];
                String desc_obf = "(" + split_obf[1];
                String name_srg = (String)entry.getValue();
                method_obfsrg_map.forcePut((Object)new NameDescPair(name_obf, desc_obf), (Object)new NameDescPair(name_srg, desc_obf));
            }
        }
        if (rawFieldMaps.containsKey(obfName)) {
            for (Map.Entry entry : rawFieldMaps.get(obfName).entrySet()) {
                String name_obf = ((String)entry.getKey()).split(":")[0];
                String name_srg = ((String)entry.getValue()).split(":")[0];
                field_obfsrg_map.forcePut((Object)name_obf, (Object)name_srg);
            }
        }
        methodObfSrgMap.put(obfName, (BiMap<NameDescPair, NameDescPair>)ImmutableBiMap.copyOf((Map)method_obfsrg_map));
        fieldObfSrgMap.put(obfName, (BiMap<String, String>)ImmutableBiMap.copyOf((Map)field_obfsrg_map));
        LogManager.getLogger().debug("map : " + deobf + "  count : " + method_obfsrg_map.size() + "," + field_obfsrg_map.size());
    }

    static {
        fieldObfSrgMap = Maps.newHashMap();
        methodObfSrgMap = Maps.newHashMap();
        srgMcpLoadedSet = Sets.newHashSet();
    }

    public static class FieldRemap {
        public final String deobfOwner;
        public final String mcpFieldName;
        public final String deobfDesc;
        public final String srgFieldName;

        public FieldRemap(String deobfOwner, String mcpFieldName, String deobfDesc, @Nullable String srgFieldName) {
            this.deobfOwner = deobfOwner.replace('.', '/');
            this.mcpFieldName = mcpFieldName;
            this.deobfDesc = AsmUtil.toDesc(deobfDesc);
            this.srgFieldName = StringUtils.isEmpty((CharSequence)srgFieldName) ? mcpFieldName : srgFieldName;
        }

        public Object[] toRuntime() {
            if (AsmUtil.isDeobfEnvironment()) {
                return new Object[]{this.deobfOwner, this.mcpFieldName, this.deobfDesc};
            }
            String obf_owner = MyAsmNameRemapper.getClassObfName(this.deobfOwner);
            String obf_name = MyAsmNameRemapper.srg2ObfFieldName(obf_owner, this.srgFieldName);
            return new Object[]{obf_owner, obf_name, AsmUtil.obfDesc(this.deobfDesc)};
        }
    }

    public static class MethodRemap {
        public final String deobfOwner;
        public final String mcpMethodName;
        public final String deobfMethodDesc;
        public final String srgMethodName;

        public MethodRemap(String deobfOwner, String mcpMethodName, String deobfMethodDesc, @Nullable String srgMethodName) {
            this.deobfOwner = deobfOwner.replace('.', '/');
            this.mcpMethodName = mcpMethodName;
            this.deobfMethodDesc = deobfMethodDesc;
            this.srgMethodName = StringUtils.isEmpty((CharSequence)srgMethodName) ? mcpMethodName : srgMethodName;
        }

        public boolean isTarget(String runtimeName, String runtimeDesc) {
            String obf_methoddesc;
            if (AsmUtil.isDeobfEnvironment()) {
                return runtimeName.equals(this.mcpMethodName) && runtimeDesc.equals(this.deobfMethodDesc);
            }
            String obf_owner = MyAsmNameRemapper.getClassObfName(this.deobfOwner);
            String obf_name = MyAsmNameRemapper.srg2ObfMethodName(obf_owner, this.srgMethodName, obf_methoddesc = AsmUtil.obfDesc(this.deobfMethodDesc));
            return runtimeName.equals(obf_name) && runtimeDesc.equals(obf_methoddesc);
        }

        public Object[] toRuntime() {
            if (AsmUtil.isDeobfEnvironment()) {
                return new Object[]{this.deobfOwner, this.mcpMethodName, this.deobfMethodDesc};
            }
            String obf_owner = MyAsmNameRemapper.getClassObfName(this.deobfOwner);
            String obf_methoddesc = AsmUtil.obfDesc(this.deobfMethodDesc);
            String obf_name = MyAsmNameRemapper.srg2ObfMethodName(obf_owner, this.srgMethodName, obf_methoddesc);
            return new Object[]{obf_owner, obf_name, obf_methoddesc};
        }
    }

    public static class NameDescPair {
        public final String name;
        public final String desc;

        public NameDescPair(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NameDescPair) {
                NameDescPair other = (NameDescPair)obj;
                return this.name.equals(other.name) && this.desc.equals(other.desc);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() | this.desc.hashCode();
        }

        public String toString() {
            return this.name + " " + this.desc;
        }
    }
}

