/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.util;

import com.cleanroommc.flare.api.util.DoubleAverageInfo;
import com.cleanroommc.flare.util.FormatUtil;
import com.google.common.base.Strings;
import java.lang.management.MemoryUsage;
import java.util.Locale;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public enum StatisticFormatter {

    private static final String BAR_TRUE_CHARACTER = "\u2503";
    private static final String BAR_FALSE_CHARACTER = "\u257b";

    public static ITextComponent formatTps(double tps) {
        TextFormatting colour = tps > 18.0 ? TextFormatting.GREEN : (tps > 16.0 ? TextFormatting.YELLOW : TextFormatting.RED);
        TextComponentString component = new TextComponentString((tps > 20.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0));
        component.func_150256_b().func_150238_a(colour);
        return component;
    }

    public static ITextComponent formatTickDurations(DoubleAverageInfo average) {
        ITextComponent text = StatisticFormatter.formatTickDuration(average.min());
        TextComponentString divider = new TextComponentString(" / ");
        divider.func_150256_b().func_150238_a(TextFormatting.GRAY);
        return text.func_150257_a((ITextComponent)divider).func_150257_a(StatisticFormatter.formatTickDuration(average.median())).func_150257_a((ITextComponent)divider).func_150257_a(StatisticFormatter.formatTickDuration(average.percentile95th())).func_150257_a((ITextComponent)divider).func_150257_a(StatisticFormatter.formatTickDuration(average.max()));
    }

    public static ITextComponent formatTickDuration(double duration) {
        TextFormatting colour = duration >= 50.0 ? TextFormatting.RED : (duration >= 40.0 ? TextFormatting.YELLOW : TextFormatting.GREEN);
        TextComponentString component = new TextComponentString(String.format(Locale.ENGLISH, "%.1f", duration));
        component.func_150256_b().func_150238_a(colour);
        return component;
    }

    public static ITextComponent formatCpuUsage(double usage) {
        TextFormatting colour = usage > 0.9 ? TextFormatting.RED : (usage > 0.65 ? TextFormatting.YELLOW : TextFormatting.GREEN);
        TextComponentString component = new TextComponentString(FormatUtil.percent(usage, 1.0));
        component.func_150256_b().func_150238_a(colour);
        return component;
    }

    public static ITextComponent formatPingRtts(double min, double median, double percentile95th, double max) {
        ITextComponent text = StatisticFormatter.formatPingRtt(min);
        TextComponentString divider = new TextComponentString(" / ");
        divider.func_150256_b().func_150238_a(TextFormatting.GRAY);
        return text.func_150257_a((ITextComponent)divider).func_150257_a(StatisticFormatter.formatPingRtt(median)).func_150257_a((ITextComponent)divider).func_150257_a(StatisticFormatter.formatPingRtt(percentile95th)).func_150257_a((ITextComponent)divider).func_150257_a(StatisticFormatter.formatPingRtt(max));
    }

    public static ITextComponent formatPingRtt(double ping) {
        TextFormatting colour = ping >= 200.0 ? TextFormatting.RED : (ping >= 100.0 ? TextFormatting.YELLOW : TextFormatting.GREEN);
        TextComponentString component = new TextComponentString(String.valueOf((int)Math.ceil(ping)));
        component.func_150256_b().func_150238_a(colour);
        return component;
    }

    public static ITextComponent generateMemoryUsageDiagram(MemoryUsage usage, int length) {
        TextComponentString gray;
        double used = usage.getUsed();
        double committed = usage.getCommitted();
        double max = usage.getMax();
        int usedChars = (int)(used * (double)length / max);
        int committedChars = (int)(committed * (double)length / max);
        TextComponentString text = new TextComponentString(Strings.repeat((String)BAR_TRUE_CHARACTER, (int)usedChars));
        text.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        if (committedChars > usedChars) {
            gray = new TextComponentString(" " + Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(committedChars - usedChars - 1)));
            gray.func_150256_b().func_150238_a(TextFormatting.GRAY);
            text.func_150257_a((ITextComponent)gray);
            TextComponentString red = new TextComponentString(" \u257b");
            red.func_150256_b().func_150238_a(TextFormatting.RED);
            text.func_150257_a((ITextComponent)red);
        }
        if (length > committedChars) {
            gray = new TextComponentString(" " + Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(length - committedChars)));
            gray.func_150256_b().func_150238_a(TextFormatting.GRAY);
            text.func_150257_a((ITextComponent)gray);
        }
        TextComponentString openingBracket = new TextComponentString("[ ");
        openingBracket.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        TextComponentString closingBracket = new TextComponentString(" ]");
        closingBracket.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return openingBracket.func_150257_a((ITextComponent)text).func_150257_a((ITextComponent)closingBracket);
    }

    public static ITextComponent generateMemoryPoolDiagram(MemoryUsage usage, MemoryUsage collectionUsage, int length) {
        TextComponentString gray;
        TextComponentString yellow;
        double used;
        double collectionUsed = used = (double)usage.getUsed();
        if (collectionUsage != null) {
            collectionUsed = collectionUsage.getUsed();
        }
        double committed = usage.getCommitted();
        double max = usage.getMax();
        int usedChars = (int)(used * (double)length / max);
        int collectionUsedChars = (int)(collectionUsed * (double)length / max);
        int committedChars = (int)(committed * (double)length / max);
        TextComponentString text = new TextComponentString(Strings.repeat((String)BAR_TRUE_CHARACTER, (int)collectionUsedChars));
        text.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        if (usedChars > collectionUsedChars) {
            TextComponentString red = new TextComponentString(" \u2503");
            red.func_150256_b().func_150238_a(TextFormatting.RED);
            text.func_150257_a((ITextComponent)red);
            yellow = new TextComponentString(" " + Strings.repeat((String)BAR_TRUE_CHARACTER, (int)(usedChars - collectionUsedChars - 1)));
            yellow.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            text.func_150257_a((ITextComponent)yellow);
        }
        if (committedChars > usedChars) {
            gray = new TextComponentString(" " + Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(committedChars - usedChars - 1)));
            gray.func_150256_b().func_150238_a(TextFormatting.GRAY);
            text.func_150257_a((ITextComponent)gray);
            yellow = new TextComponentString(" \u257b");
            yellow.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            text.func_150257_a((ITextComponent)yellow);
        }
        if (length > committedChars) {
            gray = new TextComponentString(" " + Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(length - committedChars)));
            gray.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            text.func_150257_a((ITextComponent)gray);
        }
        TextComponentString openingBracket = new TextComponentString("[ ");
        openingBracket.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        TextComponentString closingBracket = new TextComponentString(" ]");
        closingBracket.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return openingBracket.func_150257_a((ITextComponent)text).func_150257_a((ITextComponent)closingBracket);
    }

    public static ITextComponent generateDiskUsageDiagram(double used, double max, int length) {
        int usedChars = (int)(used * (double)length / max);
        int freeChars = length - usedChars;
        TextComponentString openingBracket = new TextComponentString("[ ");
        openingBracket.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        TextComponentString usedText = new TextComponentString(Strings.repeat((String)BAR_TRUE_CHARACTER, (int)usedChars));
        usedText.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        TextComponentString freeText = new TextComponentString(" " + Strings.repeat((String)BAR_FALSE_CHARACTER, (int)freeChars));
        freeText.func_150256_b().func_150238_a(TextFormatting.GRAY);
        TextComponentString closingBracket = new TextComponentString(" ]");
        closingBracket.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return openingBracket.func_150257_a((ITextComponent)usedText).func_150257_a((ITextComponent)freeText).func_150257_a((ITextComponent)closingBracket);
    }
}

