/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.util;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.context.Region;
import com.cleanroommc.flare.api.ping.PingStatistics;
import com.cleanroommc.flare.api.sampler.SamplerMode;
import com.cleanroommc.flare.api.sampler.node.MethodDescriptorResolver;
import com.cleanroommc.flare.api.sampler.node.type.StackTraceNode;
import com.cleanroommc.flare.api.sampler.node.type.ThreadNode;
import com.cleanroommc.flare.api.sampler.source.SourceMetadata;
import com.cleanroommc.flare.api.sampler.thread.ThreadDumper;
import com.cleanroommc.flare.api.sampler.thread.ThreadGrouper;
import com.cleanroommc.flare.api.tick.TickStatistics;
import com.cleanroommc.flare.api.util.DoubleAverageInfo;
import com.cleanroommc.flare.common.component.cpu.CpuInfo;
import com.cleanroommc.flare.common.component.cpu.CpuMonitor;
import com.cleanroommc.flare.common.component.disk.DiskUsage;
import com.cleanroommc.flare.common.component.memory.MemoryInfo;
import com.cleanroommc.flare.common.component.memory.heap.dump.HeapDumpSummary;
import com.cleanroommc.flare.common.component.memory.heap.gc.GarbageCollectorStatistics;
import com.cleanroommc.flare.common.component.network.NetworkInterfaceAverages;
import com.cleanroommc.flare.common.component.network.NetworkMonitor;
import com.cleanroommc.flare.common.component.os.OperatingSystemInfo;
import com.cleanroommc.flare.common.sampler.window.ProtoTimeEncoder;
import com.cleanroommc.flare.proto.FlareHeapProtos;
import com.cleanroommc.flare.proto.FlareProtos;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.util.DummyCommandSender;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public final class ProtoUtil {
    public static FlareProtos.PlatformMetadata getPlatformMetadataProto() {
        return (FlareProtos.PlatformMetadata)FlareProtos.PlatformMetadata.newBuilder().setName("forge").setType(FMLLaunchHandler.side().isClient() ? FlareProtos.PlatformMetadata.Type.CLIENT : FlareProtos.PlatformMetadata.Type.SERVER).setMinecraftVersion("1.12.2").setSparkVersion(2).setVersion(ForgeVersion.getVersion()).build();
    }

    public static FlareProtos.CommandSenderMetadata getCommandSenderProto(ICommandSender sender) {
        if (sender == null) {
            sender = new DummyCommandSender();
        }
        return (FlareProtos.CommandSenderMetadata)FlareProtos.CommandSenderMetadata.newBuilder().setName(sender.func_70005_c_()).setType(sender instanceof EntityPlayer ? FlareProtos.CommandSenderMetadata.Type.PLAYER : FlareProtos.CommandSenderMetadata.Type.OTHER).setUniqueId(sender instanceof EntityPlayer ? ((EntityPlayer)sender).func_110124_au().toString() : null).build();
    }

    public static FlareProtos.PlatformStatistics getPlatformStatsProto(FlareAPI flare, boolean includeWorld, @Nullable Map<String, GarbageCollectorStatistics> startingGcCollectorStats) {
        FlareProtos.WorldStatistics worldStats;
        PingStatistics pingStats;
        TickStatistics tickStats;
        FlareProtos.PlatformStatistics.Builder builder = FlareProtos.PlatformStatistics.newBuilder();
        builder.setMemory(ProtoUtil.getHeapProto());
        long uptime = System.currentTimeMillis() - flare.serverStartTime();
        builder.setUptime(uptime);
        if (startingGcCollectorStats != null) {
            GarbageCollectorStatistics.pollStatsSubtractInitial(startingGcCollectorStats).forEach((beanName, gcCollectorStats) -> builder.putGc((String)beanName, ProtoUtil.getPlatformGcProto(gcCollectorStats, uptime)));
        }
        if ((tickStats = flare.tickStats()) != null) {
            builder.setTps(ProtoUtil.getTpsProto(tickStats));
            if (tickStats.isDurationSupported()) {
                builder.setMspt(ProtoUtil.getMsptProto(tickStats));
            }
        }
        if ((pingStats = flare.pingStats()) != null && pingStats.average().getSamples() != 0) {
            builder.setPing(ProtoUtil.getPingProto(pingStats));
        }
        builder.setPlayerCount(flare.players().size());
        if (includeWorld && (worldStats = ProtoUtil.getWorldStatsProto(flare)) != null) {
            builder.setWorld(worldStats);
        }
        return (FlareProtos.PlatformStatistics)builder.build();
    }

    public static FlareProtos.WorldStatistics getWorldStatsProto(FlareAPI flare) {
        if (flare.server() == null) {
            return null;
        }
        FlareProtos.WorldStatistics.Builder statsBuilder = FlareProtos.WorldStatistics.newBuilder();
        int totalServerEntities = 0;
        Object2ObjectOpenHashMap entities = new Object2ObjectOpenHashMap();
        for (World world : flare.worlds()) {
            FlareProtos.WorldStatistics.World.Builder worldBuilder = FlareProtos.WorldStatistics.World.newBuilder();
            worldBuilder.setName(world.field_73011_w.func_186058_p().name());
            List<Region> regions = flare.regions(world);
            int totalWorldEntities = 0;
            for (Region region : regions) {
                worldBuilder.addRegions(ProtoUtil.getRegionProto(flare, region, (Map<String, Integer>)entities));
                totalWorldEntities += region.totalEntities();
            }
            worldBuilder.setTotalEntities(totalWorldEntities);
            totalServerEntities += totalWorldEntities;
            statsBuilder.addWorlds(worldBuilder);
        }
        statsBuilder.setTotalEntities(totalServerEntities);
        statsBuilder.putAllEntityCounts((Map<String, Integer>)entities);
        return (FlareProtos.WorldStatistics)statsBuilder.build();
    }

    public static FlareProtos.PlatformStatistics.Tps getTpsProto(TickStatistics tickStats) {
        return (FlareProtos.PlatformStatistics.Tps)FlareProtos.PlatformStatistics.Tps.newBuilder().setLast1M(tickStats.tps1Min()).setLast5M(tickStats.tps5Min()).setLast15M(tickStats.tps15Min()).build();
    }

    public static FlareProtos.PlatformStatistics.Mspt getMsptProto(TickStatistics tickStats) {
        return (FlareProtos.PlatformStatistics.Mspt)FlareProtos.PlatformStatistics.Mspt.newBuilder().setLast1M(ProtoUtil.rollingAvgProto(tickStats.duration1Min())).setLast5M(ProtoUtil.rollingAvgProto(tickStats.duration5Min())).build();
    }

    public static FlareProtos.PlatformStatistics.Ping getPingProto(PingStatistics pingStats) {
        return (FlareProtos.PlatformStatistics.Ping)FlareProtos.PlatformStatistics.Ping.newBuilder().setLast15M(ProtoUtil.rollingAvgProto(pingStats.average())).build();
    }

    public static FlareProtos.SystemStatistics getSystemStatsProto() {
        FlareProtos.SystemStatistics.Builder builder = FlareProtos.SystemStatistics.newBuilder().setCpu(ProtoUtil.getCpuProto()).setMemory(ProtoUtil.getMemoryProto()).setDisk(ProtoUtil.getDiskProto()).setOs(ProtoUtil.getOsProto()).setJava(ProtoUtil.getJavaProto());
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        builder.setUptime(uptime);
        GarbageCollectorStatistics.pollStats().forEach((beanName, gcCollectorStats) -> builder.putGc((String)beanName, ProtoUtil.getSystemGcProto(gcCollectorStats, uptime)));
        NetworkMonitor.systemAverages().forEach((name, networkInterfaceAverages) -> builder.putNet((String)name, ProtoUtil.getNetInterfaceProto(networkInterfaceAverages)));
        return (FlareProtos.SystemStatistics)builder.build();
    }

    public static FlareProtos.SystemStatistics.Cpu getCpuProto() {
        return (FlareProtos.SystemStatistics.Cpu)FlareProtos.SystemStatistics.Cpu.newBuilder().setThreads(Runtime.getRuntime().availableProcessors()).setProcessUsage(ProtoUtil.getProcessLoadProto()).setSystemUsage(ProtoUtil.getSystemLoadProto()).setModelName(CpuInfo.queryCpuModel()).build();
    }

    public static FlareProtos.SystemStatistics.Cpu.Usage getProcessLoadProto() {
        return (FlareProtos.SystemStatistics.Cpu.Usage)FlareProtos.SystemStatistics.Cpu.Usage.newBuilder().setLast1M(CpuMonitor.processLoad1MinAvg()).setLast15M(CpuMonitor.processLoad15MinAvg()).build();
    }

    public static FlareProtos.SystemStatistics.Cpu.Usage getSystemLoadProto() {
        return (FlareProtos.SystemStatistics.Cpu.Usage)FlareProtos.SystemStatistics.Cpu.Usage.newBuilder().setLast1M(CpuMonitor.systemLoad1MinAvg()).setLast15M(CpuMonitor.systemLoad15MinAvg()).build();
    }

    public static FlareProtos.SystemStatistics.Memory getMemoryProto() {
        return (FlareProtos.SystemStatistics.Memory)FlareProtos.SystemStatistics.Memory.newBuilder().setPhysical(ProtoUtil.getMemoryPoolProto(true)).setSwap(ProtoUtil.getMemoryPoolProto(false)).build();
    }

    public static FlareProtos.PlatformStatistics.Memory getHeapProto() {
        return (FlareProtos.PlatformStatistics.Memory)FlareProtos.PlatformStatistics.Memory.newBuilder().setHeap(ProtoUtil.getHeapMemoryPoolProto()).build();
    }

    public static FlareProtos.SystemStatistics.Memory.MemoryPool getMemoryPoolProto(boolean physical) {
        return (FlareProtos.SystemStatistics.Memory.MemoryPool)FlareProtos.SystemStatistics.Memory.MemoryPool.newBuilder().setUsed(physical ? MemoryInfo.getUsedPhysicalMemory() : MemoryInfo.getUsedSwap()).setTotal(physical ? MemoryInfo.getTotalPhysicalMemory() : MemoryInfo.getTotalSwap()).build();
    }

    public static FlareProtos.PlatformStatistics.Memory.MemoryPool getHeapMemoryPoolProto() {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return (FlareProtos.PlatformStatistics.Memory.MemoryPool)FlareProtos.PlatformStatistics.Memory.MemoryPool.newBuilder().setUsed(memoryUsage.getUsed()).setTotal(memoryUsage.getCommitted()).build();
    }

    public static FlareProtos.SystemStatistics.Disk getDiskProto() {
        return (FlareProtos.SystemStatistics.Disk)FlareProtos.SystemStatistics.Disk.newBuilder().setTotal(DiskUsage.getTotal()).setUsed(DiskUsage.getUsed()).build();
    }

    public static FlareProtos.SystemStatistics.Os getOsProto() {
        OperatingSystemInfo osInfo = OperatingSystemInfo.poll();
        return (FlareProtos.SystemStatistics.Os)FlareProtos.SystemStatistics.Os.newBuilder().setArch(osInfo.arch()).setName(osInfo.name()).setVersion(osInfo.version()).build();
    }

    public static FlareProtos.SystemStatistics.Java getJavaProto() {
        return (FlareProtos.SystemStatistics.Java)FlareProtos.SystemStatistics.Java.newBuilder().setVendor(System.getProperty("java.vendor", "unknown")).setVersion(System.getProperty("java.version", "unknown")).setVendorVersion(System.getProperty("java.vendor.version", "unknown")).setVmArgs(String.join((CharSequence)" ", ManagementFactory.getRuntimeMXBean().getInputArguments())).build();
    }

    public static FlareProtos.PlatformStatistics.Gc getPlatformGcProto(GarbageCollectorStatistics gcCollectorStats, long uptime) {
        return (FlareProtos.PlatformStatistics.Gc)FlareProtos.PlatformStatistics.Gc.newBuilder().setTotal(gcCollectorStats.getCollectionCount()).setAvgTime(gcCollectorStats.getAverageCollectionTime()).setAvgFrequency(gcCollectorStats.getAverageCollectionFrequency(uptime)).build();
    }

    public static FlareProtos.SystemStatistics.Gc getSystemGcProto(GarbageCollectorStatistics gcCollectorStats, long uptime) {
        return (FlareProtos.SystemStatistics.Gc)FlareProtos.SystemStatistics.Gc.newBuilder().setTotal(gcCollectorStats.getCollectionCount()).setAvgTime(gcCollectorStats.getAverageCollectionTime()).setAvgFrequency(gcCollectorStats.getAverageCollectionFrequency(uptime)).build();
    }

    public static FlareProtos.SystemStatistics.NetInterface getNetInterfaceProto(NetworkInterfaceAverages networkInterfaceAverages) {
        return (FlareProtos.SystemStatistics.NetInterface)FlareProtos.SystemStatistics.NetInterface.newBuilder().setRxBytesPerSecond(ProtoUtil.rollingAvgProto(networkInterfaceAverages.rxBytesPerSecond())).setRxPacketsPerSecond(ProtoUtil.rollingAvgProto(networkInterfaceAverages.rxPacketsPerSecond())).setTxBytesPerSecond(ProtoUtil.rollingAvgProto(networkInterfaceAverages.txBytesPerSecond())).setTxPacketsPerSecond(ProtoUtil.rollingAvgProto(networkInterfaceAverages.txPacketsPerSecond())).build();
    }

    public static FlareProtos.RollingAverageValues rollingAvgProto(DoubleAverageInfo info) {
        return (FlareProtos.RollingAverageValues)FlareProtos.RollingAverageValues.newBuilder().setMean(info.mean()).setMax(info.max()).setMin(info.min()).setMedian(info.median()).setPercentile95(info.percentile95th()).build();
    }

    public static FlareProtos.WorldStatistics.Chunk getChunkProto(FlareAPI flare, Chunk chunk, @Nullable Map<String, Integer> entityMapping) {
        FlareProtos.WorldStatistics.Chunk.Builder builder = FlareProtos.WorldStatistics.Chunk.newBuilder();
        builder.setX(chunk.field_76635_g);
        builder.setZ(chunk.field_76647_h);
        List<Entity> entities = flare.entities(chunk);
        builder.setTotalEntities(entities.size());
        Object2ObjectOpenHashMap nameMapping = new Object2ObjectOpenHashMap();
        for (Entity entity : entities) {
            String name = entity.func_70005_c_();
            nameMapping.compute(name, (k, v) -> v == null ? 1 : v + 1);
        }
        builder.putAllEntityCounts((Map<String, Integer>)nameMapping);
        if (entityMapping != null) {
            nameMapping.forEach((k, v) -> entityMapping.merge((String)k, (Integer)v, Integer::sum));
        }
        return (FlareProtos.WorldStatistics.Chunk)builder.build();
    }

    public static FlareProtos.WorldStatistics.Region getRegionProto(FlareAPI flare, Region region, @Nullable Map<String, Integer> entityMapping) {
        FlareProtos.WorldStatistics.Region.Builder builder = FlareProtos.WorldStatistics.Region.newBuilder();
        builder.setTotalEntities(region.totalEntities());
        for (Chunk chunk : region.chunks()) {
            builder.addChunks(ProtoUtil.getChunkProto(flare, chunk, entityMapping));
        }
        return (FlareProtos.WorldStatistics.Region)builder.build();
    }

    public static FlareSamplerProtos.SamplerMetadata.SourceMetadata getSourceMetadataProto(SourceMetadata sourceMetadata) {
        List<String> authors = sourceMetadata.authors();
        String authorsString = authors.isEmpty() ? "" : (authors.size() > 1 ? " | authors: " + String.join((CharSequence)", ", authors) : " | author: " + String.join((CharSequence)", ", authors));
        return (FlareSamplerProtos.SamplerMetadata.SourceMetadata)FlareSamplerProtos.SamplerMetadata.SourceMetadata.newBuilder().setName(sourceMetadata.name()).setVersion(sourceMetadata.version() + authorsString).build();
    }

    public static FlareHeapProtos.HeapData getHeapDataProto(FlareAPI flare, ICommandSender creator, HeapDumpSummary heapDumpSummary) {
        FlareHeapProtos.HeapData.Builder builder = FlareHeapProtos.HeapData.newBuilder();
        builder.setMetadata(ProtoUtil.getHeapMetadataProto(flare, creator));
        heapDumpSummary.entries().forEach(entry -> builder.addEntries(ProtoUtil.getHeapEntryProto(entry)));
        return (FlareHeapProtos.HeapData)builder.build();
    }

    public static FlareHeapProtos.HeapMetadata getHeapMetadataProto(FlareAPI flare, ICommandSender creator) {
        return (FlareHeapProtos.HeapMetadata)FlareHeapProtos.HeapMetadata.newBuilder().setPlatformMetadata(ProtoUtil.getPlatformMetadataProto()).setCreator(ProtoUtil.getCommandSenderProto(creator)).setPlatformStatistics(ProtoUtil.getPlatformStatsProto(flare, true, null)).setSystemStatistics(ProtoUtil.getSystemStatsProto()).build();
    }

    public static FlareHeapProtos.HeapEntry getHeapEntryProto(HeapDumpSummary.Entry entry) {
        return (FlareHeapProtos.HeapEntry)FlareHeapProtos.HeapEntry.newBuilder().setOrder(entry.order()).setInstances(entry.instances()).setSize(entry.bytes()).setType(entry.type()).build();
    }

    public static FlareSamplerProtos.SamplerMetadata.SamplerMode getSamplerModeProto(SamplerMode samplerMode) {
        return samplerMode == SamplerMode.EXECUTION ? FlareSamplerProtos.SamplerMetadata.SamplerMode.EXECUTION : FlareSamplerProtos.SamplerMetadata.SamplerMode.ALLOCATION;
    }

    public static FlareSamplerProtos.SamplerMetadata.ThreadDumper getThreadDumperProto(ThreadDumper threadDumper) {
        FlareSamplerProtos.SamplerMetadata.ThreadDumper.Builder builder = FlareSamplerProtos.SamplerMetadata.ThreadDumper.newBuilder();
        if (threadDumper == ThreadDumper.ALL) {
            return (FlareSamplerProtos.SamplerMetadata.ThreadDumper)builder.setType(FlareSamplerProtos.SamplerMetadata.ThreadDumper.Type.ALL).build();
        }
        if (threadDumper instanceof ThreadDumper.Specific) {
            return (FlareSamplerProtos.SamplerMetadata.ThreadDumper)builder.setType(FlareSamplerProtos.SamplerMetadata.ThreadDumper.Type.SPECIFIC).addAllIds((Iterable<? extends Long>)((ThreadDumper.Specific)threadDumper).threadIds()).build();
        }
        if (threadDumper instanceof ThreadDumper.Regex) {
            return (FlareSamplerProtos.SamplerMetadata.ThreadDumper)builder.setType(FlareSamplerProtos.SamplerMetadata.ThreadDumper.Type.REGEX).addAllPatterns(((ThreadDumper.Regex)threadDumper).namePatterns().stream().map(Pattern::pattern).collect(Collectors.toList())).build();
        }
        return null;
    }

    public static FlareSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper getThreadGrouperProto(ThreadGrouper grouper) {
        if (grouper == ThreadGrouper.BY_NAME) {
            return FlareSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_NAME;
        }
        if (grouper == ThreadGrouper.BY_POOL) {
            return FlareSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_POOL;
        }
        return FlareSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.AS_ONE;
    }

    public static FlareSamplerProtos.ThreadNode getThreadNodeProto(ThreadNode threadNode, ProtoTimeEncoder timeEncoder, MethodDescriptorResolver resolver, boolean separateParentCalls) {
        FlareSamplerProtos.ThreadNode.Builder proto = FlareSamplerProtos.ThreadNode.newBuilder().setName(threadNode.label());
        double[] times = threadNode.encodeTimesForProto(timeEncoder);
        FlareAPI.getInstance().logger().warn("[{}] Time Windows: {}", (Object)threadNode.label(), (Object)Arrays.toString(times));
        for (double time : times) {
            proto.addTimes(time);
        }
        ArrayList<FlareSamplerProtos.StackTraceNode> nodesArray = new ArrayList<FlareSamplerProtos.StackTraceNode>();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        LinkedList childrenRefs = new LinkedList();
        for (StackTraceNode stackTraceNode : threadNode.exportChildren(resolver, separateParentCalls)) {
            stack.push(new Node(stackTraceNode, childrenRefs));
        }
        while (!stack.isEmpty()) {
            Node node = (Node)stack.peek();
            if (node.firstVisit) {
                for (StackTraceNode child : node.stackTraceNode.exportChildren(resolver, separateParentCalls)) {
                    stack.push(new Node(child, node.childrenRefs));
                }
                node.firstVisit = false;
                continue;
            }
            FlareSamplerProtos.StackTraceNode stackTraceNode = ProtoUtil.getStackTraceNodeProto(node.stackTraceNode, resolver, separateParentCalls, timeEncoder, node.childrenRefs);
            int childIndex = nodesArray.size();
            nodesArray.add(stackTraceNode);
            node.parentChildrenRefs.add(childIndex);
            stack.pop();
        }
        proto.addAllChildrenRefs(childrenRefs);
        proto.addAllChildren(nodesArray);
        return (FlareSamplerProtos.ThreadNode)proto.build();
    }

    public static FlareSamplerProtos.StackTraceNode getStackTraceNodeProto(StackTraceNode stackTraceNode, MethodDescriptorResolver resolver, boolean separateParentCalls, ProtoTimeEncoder timeEncoder, Iterable<Integer> childrenRefs) {
        FlareSamplerProtos.StackTraceNode.Builder proto = FlareSamplerProtos.StackTraceNode.newBuilder().setClassName(stackTraceNode.className()).setMethodName(stackTraceNode.methodName());
        double[] times = stackTraceNode.encodeTimesForProto(timeEncoder);
        FlareAPI.getInstance().logger().warn("[{}.{}()] Time Windows: {}", (Object)stackTraceNode.className(), (Object)stackTraceNode.methodName(), (Object)Arrays.toString(times));
        for (double time : times) {
            proto.addTimes(time);
        }
        if (stackTraceNode.lineNumber() >= 0) {
            proto.setLineNumber(stackTraceNode.lineNumber());
        }
        if (separateParentCalls && stackTraceNode.parentLineNumber() >= 0) {
            proto.setParentLineNumber(stackTraceNode.parentLineNumber());
        }
        if (stackTraceNode.methodDescription() != null) {
            proto.setMethodDesc(stackTraceNode.methodDescription());
        } else {
            String methodDesc = resolver.resolve(stackTraceNode);
            if (methodDesc != null) {
                proto.setMethodDesc(methodDesc);
            }
        }
        proto.addAllChildrenRefs(childrenRefs);
        return (FlareSamplerProtos.StackTraceNode)proto.build();
    }

    private ProtoUtil() {
    }

    private static final class Node {
        private final StackTraceNode stackTraceNode;
        private boolean firstVisit = true;
        private final List<Integer> childrenRefs = new LinkedList<Integer>();
        private final List<Integer> parentChildrenRefs;

        private Node(StackTraceNode node, List<Integer> parentChildrenRefs) {
            this.stackTraceNode = node;
            this.parentChildrenRefs = parentChildrenRefs;
        }
    }
}

