/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.websocket;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.common.websocket.CryptoAlgorithm;
import com.cleanroommc.flare.proto.FlareWebSocketProtos;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import java.util.function.Consumer;
import me.lucko.bytesocks.client.BytesocksClient;

public class ViewerSocketConnection
implements BytesocksClient.Listener,
AutoCloseable {
    public static final int VERSION_1 = 1;
    public static final CryptoAlgorithm CRYPTO = CryptoAlgorithm.RSA2048;
    private final FlareAPI flare;
    private final Listener listener;
    private final PrivateKey privateKey;
    private final BytesocksClient.Socket socket;

    public ViewerSocketConnection(FlareAPI flare, BytesocksClient client, Listener listener) throws Exception {
        this.flare = flare;
        this.listener = listener;
        this.privateKey = flare.trustedKeyStore().getLocalPrivateKey();
        this.socket = client.createAndConnect(this);
    }

    public String getChannelId() {
        return this.socket.getChannelId();
    }

    public boolean isOpen() {
        return this.socket.isOpen();
    }

    @Override
    public void onText(CharSequence data) {
        try {
            FlareWebSocketProtos.RawPacket packet = this.decodeRawPacket(data);
            this.handleRawPacket(packet);
        }
        catch (Exception e) {
            this.flare.logger().warn("Exception occurred while reading data from the socket", (Throwable)e);
        }
    }

    @Override
    public void onError(Throwable error) {
        this.flare.logger().error("Socket error: {} {}", (Object)error.getClass().getName(), (Object)error.getMessage(), (Object)error);
    }

    @Override
    public void onClose(int statusCode, String reason) {
        this.flare.logger().warn("Socket closed with status: {}, with reason: {}", (Object)statusCode, (Object)reason);
    }

    public void sendPacket(Consumer<FlareWebSocketProtos.PacketWrapper.Builder> packetBuilder) {
        FlareWebSocketProtos.PacketWrapper.Builder builder = FlareWebSocketProtos.PacketWrapper.newBuilder();
        packetBuilder.accept(builder);
        FlareWebSocketProtos.PacketWrapper wrapper = (FlareWebSocketProtos.PacketWrapper)builder.build();
        try {
            this.sendPacket(wrapper);
        }
        catch (Exception e) {
            this.flare.logger().error("Exception occurred while sending data to the socket.", (Throwable)e);
        }
    }

    private void sendPacket(FlareWebSocketProtos.PacketWrapper packet) throws Exception {
        ByteString msg = packet.toByteString();
        Signature sign = CRYPTO.createSignature();
        sign.initSign(this.privateKey);
        sign.update(msg.asReadOnlyByteBuffer());
        byte[] signature = sign.sign();
        this.sendRawPacket((FlareWebSocketProtos.RawPacket)FlareWebSocketProtos.RawPacket.newBuilder().setVersion(1).setSignature(ByteString.copyFrom(signature)).setMessage(msg).build());
    }

    private void sendRawPacket(FlareWebSocketProtos.RawPacket packet) throws IOException {
        byte[] buf = packet.toByteArray();
        String encoded = Base64.getEncoder().encodeToString(buf);
        this.socket.send(encoded);
    }

    private FlareWebSocketProtos.RawPacket decodeRawPacket(CharSequence data) throws IOException {
        byte[] buf = Base64.getDecoder().decode(data.toString());
        return FlareWebSocketProtos.RawPacket.parseFrom(buf);
    }

    private void handleRawPacket(FlareWebSocketProtos.RawPacket packet) throws Exception {
        int version = packet.getVersion();
        if (version != 1) {
            throw new IllegalArgumentException("Unsupported packet version " + version);
        }
        ByteString message = packet.getMessage();
        PublicKey publicKey = CRYPTO.decodePublicKey(packet.getPublicKey());
        ByteString signature = packet.getSignature();
        boolean verified = false;
        if (signature != null && publicKey != null && this.listener.isKeyTrusted(publicKey)) {
            Signature sign = CRYPTO.createSignature();
            sign.initVerify(publicKey);
            sign.update(message.asReadOnlyByteBuffer());
            verified = sign.verify(signature.toByteArray());
        }
        FlareWebSocketProtos.PacketWrapper wrapper = FlareWebSocketProtos.PacketWrapper.parseFrom(message);
        this.listener.onPacket(wrapper, verified, publicKey);
    }

    @Override
    public void close() {
        this.socket.close(1001, "spark plugin disconnected");
    }

    public static interface Listener {
        public boolean isKeyTrusted(PublicKey var1);

        public void onPacket(FlareWebSocketProtos.PacketWrapper var1, boolean var2, PublicKey var3) throws Exception;
    }
}

