/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.websocket;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.sampler.Sampler;
import com.cleanroommc.flare.common.sampler.AbstractSampler;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.common.websocket.ViewerSocketConnection;
import com.cleanroommc.flare.proto.FlareProtos;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.proto.FlareWebSocketProtos;
import com.google.protobuf.ByteString;
import java.security.PublicKey;
import java.util.concurrent.TimeUnit;
import me.lucko.bytesocks.client.BytesocksClient;

public class ViewerSocket
implements ViewerSocketConnection.Listener,
AutoCloseable {
    private static final long SOCKET_INITIAL_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    private static final long SOCKET_ESTABLISHED_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private final FlareAPI flare;
    private final ExportProps exportProps;
    private final ViewerSocketConnection socket;
    private boolean closed = false;
    private final long socketOpenTime = System.currentTimeMillis();
    private long lastPing = 0L;
    private String lastPayloadId = null;

    public ViewerSocket(FlareAPI flare, BytesocksClient client, ExportProps exportProps) throws Exception {
        this.flare = flare;
        this.exportProps = exportProps;
        this.socket = new ViewerSocketConnection(flare, client, this);
    }

    private void log(String message) {
        this.flare.logger().info("[Viewer - {}] {}", (Object)this.socket.getChannelId(), (Object)message);
    }

    public FlareSamplerProtos.SocketChannelInfo getPayload() {
        return (FlareSamplerProtos.SocketChannelInfo)FlareSamplerProtos.SocketChannelInfo.newBuilder().setChannelId(this.socket.getChannelId()).setPublicKey(ByteString.copyFrom(this.flare.trustedKeyStore().getLocalPublicKey().getEncoded())).build();
    }

    public boolean isOpen() {
        return !this.closed && this.socket.isOpen();
    }

    public void processWindowRotate(AbstractSampler sampler) {
        if (this.closed) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.socketOpenTime > SOCKET_INITIAL_TIMEOUT && time - this.lastPing > SOCKET_ESTABLISHED_TIMEOUT) {
            this.log("No clients have pinged for 30s, closing socket.");
            this.close();
            return;
        }
        if (this.lastPing == 0L) {
            return;
        }
        try {
            FlareSamplerProtos.SamplerData samplerData = sampler.toProto(this.flare, this.exportProps, false);
            this.log("Sending updated sampler data.");
            String key = this.flare.bytebinClient().postContent("application/x-spark-sampler", "live", samplerData);
            this.sendUpdatedSamplerData(key);
        }
        catch (Throwable t) {
            this.flare.logger().warn("Error whilst sending updated sampler data to the socket.", t);
        }
    }

    public void processSamplerStopped(Sampler sampler) {
        if (this.closed) {
            return;
        }
        this.close();
    }

    @Override
    public void close() {
        this.socket.sendPacket(builder -> builder.setServerPong((FlareWebSocketProtos.ServerPong)FlareWebSocketProtos.ServerPong.newBuilder().setOk(false).build()));
        this.socket.close();
        this.closed = true;
    }

    @Override
    public boolean isKeyTrusted(PublicKey publicKey) {
        return this.flare.trustedKeyStore().isKeyTrusted(publicKey);
    }

    public void sendClientTrustedMessage(String clientId) {
        this.socket.sendPacket(builder -> builder.setServerConnectResponse((FlareWebSocketProtos.ServerConnectResponse)FlareWebSocketProtos.ServerConnectResponse.newBuilder().setClientId(clientId).setState(FlareWebSocketProtos.ServerConnectResponse.State.ACCEPTED).build()));
    }

    public void sendUpdatedSamplerData(String payloadId) {
        this.socket.sendPacket(builder -> builder.setServerUpdateSampler((FlareWebSocketProtos.ServerUpdateSamplerData)FlareWebSocketProtos.ServerUpdateSamplerData.newBuilder().setPayloadId(payloadId).build()));
        this.lastPayloadId = payloadId;
    }

    public void sendUpdatedStatistics(FlareProtos.PlatformStatistics platform, FlareProtos.SystemStatistics system) {
        this.socket.sendPacket(builder -> builder.setServerUpdateStatistics((FlareWebSocketProtos.ServerUpdateStatistics)FlareWebSocketProtos.ServerUpdateStatistics.newBuilder().setPlatform(platform).setSystem(system).build()));
    }

    @Override
    public void onPacket(FlareWebSocketProtos.PacketWrapper packet, boolean verified, PublicKey publicKey) {
        switch (packet.getPacketCase()) {
            case CLIENT_PING: {
                this.onClientPing(packet.getClientPing(), publicKey);
                break;
            }
            case CLIENT_CONNECT: {
                this.onClientConnect(packet.getClientConnect(), verified, publicKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected packet: " + (Object)((Object)packet.getPacketCase()));
            }
        }
    }

    private void onClientPing(FlareWebSocketProtos.ClientPing packet, PublicKey publicKey) {
        this.lastPing = System.currentTimeMillis();
        this.socket.sendPacket(builder -> builder.setServerPong((FlareWebSocketProtos.ServerPong)FlareWebSocketProtos.ServerPong.newBuilder().setOk(!this.closed).setData(packet.getData()).build()));
    }

    private void onClientConnect(FlareWebSocketProtos.ClientConnect packet, boolean verified, PublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalStateException("Missing public key");
        }
        this.lastPing = System.currentTimeMillis();
        String clientId = packet.getClientId();
        this.log("Client connected: clientId=" + clientId + ", keyhash=" + ViewerSocket.hashPublicKey(publicKey) + ", desc=" + packet.getDescription());
        FlareWebSocketProtos.ServerConnectResponse.Builder resp = FlareWebSocketProtos.ServerConnectResponse.newBuilder().setClientId(clientId).setSettings((FlareWebSocketProtos.ServerConnectResponse.Settings)FlareWebSocketProtos.ServerConnectResponse.Settings.newBuilder().setSamplerInterval(10).setStatisticsInterval(10).build());
        if (this.lastPayloadId != null) {
            resp.setLastPayloadId(this.lastPayloadId);
        }
        if (this.closed) {
            resp.setState(FlareWebSocketProtos.ServerConnectResponse.State.REJECTED);
        } else if (verified) {
            resp.setState(FlareWebSocketProtos.ServerConnectResponse.State.ACCEPTED);
        } else {
            resp.setState(FlareWebSocketProtos.ServerConnectResponse.State.UNTRUSTED);
            this.flare.trustedKeyStore().addPendingKey(clientId, publicKey);
        }
        this.socket.sendPacket(builder -> builder.setServerConnectResponse((FlareWebSocketProtos.ServerConnectResponse)resp.build()));
    }

    private static String hashPublicKey(PublicKey publicKey) {
        return publicKey == null ? "null" : Integer.toHexString(publicKey.hashCode());
    }
}

