/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.websocket;

import com.cleanroommc.flare.common.config.FlareConfiguration;
import com.cleanroommc.flare.common.websocket.ViewerSocketConnection;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;

public class TrustedKeyStore {
    private final CompletableFuture<KeyPair> localKeyPair;
    private final Set<PublicKey> remoteTrustedKeys;
    private final Map<String, PublicKey> remotePendingKeys = new HashMap<String, PublicKey>();

    public TrustedKeyStore() {
        this.localKeyPair = CompletableFuture.supplyAsync(ViewerSocketConnection.CRYPTO::generateKeyPair);
        this.remoteTrustedKeys = new HashSet<PublicKey>();
        this.readTrustedKeys();
    }

    public PublicKey getLocalPublicKey() {
        return this.localKeyPair.join().getPublic();
    }

    public PrivateKey getLocalPrivateKey() {
        return this.localKeyPair.join().getPrivate();
    }

    public boolean isKeyTrusted(PublicKey publicKey) {
        return publicKey != null && this.remoteTrustedKeys.contains(publicKey);
    }

    public void addPendingKey(String clientId, PublicKey publicKey) {
        this.remotePendingKeys.put(clientId, publicKey);
    }

    public boolean trustPendingKey(String clientId) {
        PublicKey key = this.remotePendingKeys.remove(clientId);
        if (key == null) {
            return false;
        }
        this.remoteTrustedKeys.add(key);
        this.writeTrustedKeys();
        ConfigManager.sync((String)"flare", (Config.Type)Config.Type.INSTANCE);
        return true;
    }

    private void readTrustedKeys() {
        for (String encodedKey : FlareConfiguration.trustedKeys) {
            try {
                PublicKey publicKey = ViewerSocketConnection.CRYPTO.decodePublicKey(Base64.getDecoder().decode(encodedKey));
                this.remoteTrustedKeys.add(publicKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeTrustedKeys() {
        FlareConfiguration.trustedKeys = (String[])this.remoteTrustedKeys.stream().map(key -> Base64.getEncoder().encodeToString(key.getEncoded())).toArray(String[]::new);
    }
}

