/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.java;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.sampler.SamplerMode;
import com.cleanroommc.flare.api.sampler.thread.ThreadDumper;
import com.cleanroommc.flare.api.sampler.thread.ThreadGrouper;
import com.cleanroommc.flare.api.sampler.window.ProfilingWindowUtils;
import com.cleanroommc.flare.api.tick.TickRoutine;
import com.cleanroommc.flare.common.sampler.AbstractSampler;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.common.sampler.java.JavaDataAggregator;
import com.cleanroommc.flare.common.sampler.window.WindowStatisticsCollector;
import com.cleanroommc.flare.common.websocket.ViewerSocket;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.util.FlareThreadFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;

public class JavaSampler
extends AbstractSampler
implements Runnable {
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private final JavaDataAggregator dataAggregator;
    private final AtomicInteger lastWindow = new AtomicInteger();
    ScheduledExecutorService workerPool = this.service();
    private ScheduledFuture<?> samplingTask;
    private ScheduledFuture<?> socketStatisticsTask;

    public JavaSampler(FlareAPI flare, int interval, ThreadDumper threadDumper, long endTime, boolean runningInBackground, ThreadGrouper grouper, boolean ignoreSleeping, boolean ignoreNative) {
        super(flare, interval, threadDumper, endTime, runningInBackground);
        this.dataAggregator = JavaDataAggregator.simple(this, grouper, interval, ignoreSleeping, ignoreNative);
    }

    public JavaSampler(FlareAPI flare, int interval, ThreadDumper threadDumper, long endTime, boolean runningInBackground, boolean ignoreSleeping, boolean ignoreNative, ThreadGrouper threadGrouper, TickRoutine tickRoutine, int tickLengthThreshold) {
        super(flare, interval, threadDumper, endTime, runningInBackground);
        this.dataAggregator = JavaDataAggregator.ticked(this, threadGrouper, interval, ignoreSleeping, ignoreNative, tickRoutine, tickLengthThreshold);
    }

    @Override
    public SamplerMode mode() {
        return SamplerMode.EXECUTION;
    }

    @Override
    protected void startWork() {
        TickRoutine tickRoutine = this.flare.tickRoutine();
        if (tickRoutine != null) {
            if (this.dataAggregator.ticked()) {
                WindowStatisticsCollector.ExplicitTickCounter counter = this.windowStatisticsCollector.startCountingTicksExplicit(tickRoutine);
                ((JavaDataAggregator.Ticked)this.dataAggregator).setTickCounter(counter);
            } else {
                this.windowStatisticsCollector.startCountingTicks(tickRoutine);
            }
        }
        this.windowStatisticsCollector.recordWindowStartTime(ProfilingWindowUtils.unixMillisToWindow(this.startTime));
        this.samplingTask = this.workerPool.scheduleAtFixedRate(this, 0L, this.interval, TimeUnit.MICROSECONDS);
    }

    @Override
    protected void stopWork(boolean cancelled) {
        this.samplingTask.cancel(false);
        if (this.socketStatisticsTask != null) {
            this.socketStatisticsTask.cancel(false);
        }
        if (!cancelled) {
            this.windowStatisticsCollector.measureNow(this.lastWindow.get());
        }
        this.workerPool.shutdown();
    }

    @Override
    public void attachSocket(ViewerSocket socket) {
        super.attachSocket(socket);
        if (this.socketStatisticsTask == null) {
            this.socketStatisticsTask = this.workerPool.scheduleAtFixedRate(this::sendStatisticsToSocket, 10L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public FlareSamplerProtos.SamplerData toProto(FlareAPI flare, ExportProps exportProps, boolean stop) {
        this.windowStatisticsCollector.measureNow(this.lastWindow.get());
        FlareSamplerProtos.SamplerData.Builder builder = FlareSamplerProtos.SamplerData.newBuilder();
        if (exportProps.channelInfo() != null) {
            builder.setChannelInfo(exportProps.channelInfo());
        }
        this.writeMetadataToProto(builder, exportProps, this.dataAggregator);
        this.stopService();
        this.writeDataToProto(builder, this.dataAggregator, exportProps);
        if (!stop) {
            this.resumeService();
        }
        return (FlareSamplerProtos.SamplerData)builder.build();
    }

    @Override
    public void run() {
        try {
            long time = System.currentTimeMillis();
            if (this.autoEndTime != -1L && this.autoEndTime <= time) {
                this.stop(false);
                this.future.complete(this);
                return;
            }
            int window = ProfilingWindowUtils.unixMillisToWindow(time);
            ThreadInfo[] threadDumps = this.threadDumper.dump(this.threadBean);
            this.workerPool.execute(new GatherDataTask(threadDumps, window));
        }
        catch (Throwable t) {
            this.stop(false);
            this.future.completeExceptionally(t);
        }
    }

    void stopService() {
        this.workerPool.shutdown();
        try {
            this.workerPool.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void resumeService() {
        this.workerPool = this.service();
        this.samplingTask = this.samplingTask();
    }

    private ScheduledExecutorService service() {
        return Executors.newScheduledThreadPool(6, new FlareThreadFactory(FlareAPI.getInstance(), "flare-java-sampler"));
    }

    private ScheduledFuture<?> samplingTask() {
        return this.workerPool.scheduleAtFixedRate(this, 0L, this.interval, TimeUnit.MICROSECONDS);
    }

    private final class GatherDataTask
    implements Runnable {
        private final JavaSampler $;
        private final ThreadInfo[] threadDumps;
        private final int window;

        private GatherDataTask(ThreadInfo[] threadDumps, int window) {
            this.$ = JavaSampler.this;
            this.threadDumps = threadDumps;
            this.window = window;
        }

        @Override
        public void run() {
            for (ThreadInfo threadInfo : this.threadDumps) {
                if (threadInfo.getThreadName() == null || threadInfo.getStackTrace() == null) continue;
                this.$.dataAggregator.insertData(threadInfo, this.window);
            }
            int previousWindow = this.$.lastWindow.getAndUpdate(previous -> Math.max(this.window, previous));
            if (previousWindow != 0 && previousWindow != this.window) {
                this.$.windowStatisticsCollector.recordWindowStartTime(this.window);
                this.$.windowStatisticsCollector.measureNow(previousWindow);
                IntPredicate predicate = ProfilingWindowUtils.keepHistoryBefore(this.window);
                this.$.dataAggregator.pruneData(predicate);
                this.$.windowStatisticsCollector.pruneStatistics(predicate);
                this.$.workerPool.execute(this.$::processWindowRotate);
            }
        }
    }
}

