/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.java;

import com.cleanroommc.flare.api.sampler.node.description.NodeDescriber;
import com.cleanroommc.flare.api.sampler.node.description.NodeDescription;
import com.cleanroommc.flare.api.sampler.node.type.ThreadNode;
import com.cleanroommc.flare.api.sampler.thread.ThreadGrouper;
import com.cleanroommc.flare.api.tick.TickRoutine;
import com.cleanroommc.flare.common.sampler.aggregator.AbstractDataAggregator;
import com.cleanroommc.flare.common.sampler.java.JavaSampler;
import com.cleanroommc.flare.common.sampler.window.WindowStatisticsCollector;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.util.ProtoUtil;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class JavaDataAggregator
extends AbstractDataAggregator {
    private static final NodeDescriber<StackTraceElement> DESCRIBER = (element, parent) -> {
        int parentLineNumber = parent == null ? -1 : parent.getLineNumber();
        return new NodeDescription(element.getClassName(), element.getMethodName(), element.getLineNumber(), parentLineNumber);
    };
    protected final JavaSampler sampler;
    protected final int interval;
    private final boolean ignoreSleeping;
    private final boolean ignoreNative;

    public static JavaDataAggregator simple(JavaSampler sampler, ThreadGrouper threadGrouper, int interval, boolean ignoreSleeping, boolean ignoreNative) {
        return new JavaDataAggregator(sampler, threadGrouper, interval, ignoreSleeping, ignoreNative);
    }

    public static JavaDataAggregator ticked(JavaSampler sampler, ThreadGrouper threadGrouper, int interval, boolean ignoreSleeping, boolean ignoreNative, TickRoutine tickRoutine, int tickLengthThreshold) {
        return new Ticked(sampler, threadGrouper, interval, ignoreSleeping, ignoreNative, tickRoutine, tickLengthThreshold);
    }

    private static boolean isSleeping(ThreadInfo thread) {
        if (thread.getThreadState() == Thread.State.WAITING || thread.getThreadState() == Thread.State.TIMED_WAITING) {
            return true;
        }
        StackTraceElement[] stackTrace = thread.getStackTrace();
        if (stackTrace.length == 0) {
            return false;
        }
        StackTraceElement call = stackTrace[0];
        String clazz = call.getClassName();
        String method = call.getMethodName();
        return "park".equals(method) && ("sun.misc.Unsafe".equals(clazz) || "jdk.internal.misc.Unsafe".equals(clazz)) || "yield".equals(method) && "java.lang.Thread".equals(clazz);
    }

    private JavaDataAggregator(JavaSampler sampler, ThreadGrouper threadGrouper, int interval, boolean ignoreSleeping, boolean ignoreNative) {
        super(threadGrouper);
        this.sampler = sampler;
        this.interval = interval;
        this.ignoreSleeping = ignoreSleeping;
        this.ignoreNative = ignoreNative;
    }

    public boolean ticked() {
        return false;
    }

    public void insertData(ThreadInfo threadInfo, int window) {
        this.writeData(threadInfo, window);
    }

    @Override
    public FlareSamplerProtos.SamplerMetadata.DataAggregator toProto() {
        return (FlareSamplerProtos.SamplerMetadata.DataAggregator)FlareSamplerProtos.SamplerMetadata.DataAggregator.newBuilder().setType(FlareSamplerProtos.SamplerMetadata.DataAggregator.Type.SIMPLE).setThreadGrouper(ProtoUtil.getThreadGrouperProto(this.threadGrouper)).build();
    }

    protected void writeData(ThreadInfo threadInfo, int window) {
        if (this.ignoreSleeping && JavaDataAggregator.isSleeping(threadInfo)) {
            return;
        }
        if (this.ignoreNative && threadInfo.isInNative()) {
            return;
        }
        try {
            ThreadNode node = this.getNode(this.threadGrouper.group(threadInfo.getThreadId(), threadInfo.getThreadName()));
            node.trace(DESCRIBER, threadInfo.getStackTrace(), this.interval, window);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class Ticked
    extends JavaDataAggregator {
        private final TickRoutine tickRoutine;
        private final long tickLengthThreshold;
        private final int expectedSize;
        private WindowStatisticsCollector.ExplicitTickCounter tickCounter;
        private int currentTick = -1;
        private TickList currentData = null;
        private final Object mutex = new Object();

        private Ticked(JavaSampler sampler, ThreadGrouper threadGrouper, int interval, boolean ignoreSleeping, boolean ignoreNative, TickRoutine tickRoutine, int tickLengthThreshold) {
            super(sampler, threadGrouper, interval, ignoreSleeping, ignoreNative);
            this.tickRoutine = tickRoutine;
            this.tickLengthThreshold = TimeUnit.MILLISECONDS.toMicros(tickLengthThreshold);
            double intervalMilliseconds = (double)interval / 1000.0;
            this.expectedSize = (int)(50.0 / intervalMilliseconds + 10.0);
        }

        @Override
        public boolean ticked() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertData(ThreadInfo threadInfo, int window) {
            Object object = this.mutex;
            synchronized (object) {
                int tick = this.tickRoutine.currentTick();
                if (this.currentTick != tick || this.currentData == null) {
                    this.pushCurrentTick(this.sampler.workerPool);
                    this.currentTick = tick;
                    this.currentData = new TickList(this.expectedSize, window);
                }
                this.currentData.addData(threadInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ThreadNode> exportData() {
            Object object = this.mutex;
            synchronized (object) {
                this.pushCurrentTick(Runnable::run);
            }
            return super.exportData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FlareSamplerProtos.SamplerMetadata.DataAggregator toProto() {
            Object object = this.mutex;
            synchronized (object) {
                this.pushCurrentTick(Runnable::run);
                this.currentData = null;
            }
            return (FlareSamplerProtos.SamplerMetadata.DataAggregator)FlareSamplerProtos.SamplerMetadata.DataAggregator.newBuilder().setType(FlareSamplerProtos.SamplerMetadata.DataAggregator.Type.TICKED).setThreadGrouper(ProtoUtil.getThreadGrouperProto(this.threadGrouper)).setTickLengthThreshold(this.tickLengthThreshold).setNumberOfIncludedTicks(this.tickCounter.getTotalCountedTicks()).build();
        }

        public void setTickCounter(WindowStatisticsCollector.ExplicitTickCounter tickCounter) {
            this.tickCounter = tickCounter;
        }

        private void pushCurrentTick(Executor executor) {
            TickList currentData = this.currentData;
            if (currentData == null) {
                return;
            }
            int tickLengthMicros = currentData.getList().size() * this.interval;
            if ((long)tickLengthMicros < this.tickLengthThreshold) {
                return;
            }
            executor.execute(currentData);
            this.tickCounter.increment();
        }

        private final class TickList
        implements Runnable {
            private final List<ThreadInfo> list;
            private final int window;

            TickList(int expectedSize, int window) {
                this.list = new ArrayList<ThreadInfo>(expectedSize);
                this.window = window;
            }

            @Override
            public void run() {
                for (ThreadInfo data : this.list) {
                    Ticked.this.writeData(data, this.window);
                }
            }

            public List<ThreadInfo> getList() {
                return this.list;
            }

            public void addData(ThreadInfo data) {
                this.list.add(data);
            }
        }
    }
}

