/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.disk;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;

public final class DiskUsage {
    private static final FileStore FILE_STORE;

    public static long getUsed() {
        if (FILE_STORE == null) {
            return 0L;
        }
        try {
            long total = FILE_STORE.getTotalSpace();
            return total - FILE_STORE.getUsableSpace();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static long getTotal() {
        if (FILE_STORE == null) {
            return 0L;
        }
        try {
            return FILE_STORE.getTotalSpace();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private DiskUsage() {
    }

    static {
        FileStore fileStore = null;
        try {
            fileStore = Files.getFileStore(Paths.get(".", new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FILE_STORE = fileStore;
    }
}

