/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.cpu;

import com.cleanroommc.flare.common.component.os.LinuxProc;
import com.cleanroommc.flare.common.component.os.WindowsWmic;
import java.util.regex.Pattern;

public final class CpuInfo {
    private static final Pattern SPACE_COLON_SPACE_PATTERN = Pattern.compile("\\s+:\\s");

    public static String queryCpuModel() {
        for (String line : LinuxProc.CPUINFO.read()) {
            String[] splitLine = SPACE_COLON_SPACE_PATTERN.split(line);
            if (!splitLine[0].equals("model name") && !splitLine[0].equals("Processor")) continue;
            return splitLine[1];
        }
        for (String line : WindowsWmic.CPU_GET_NAME.read()) {
            if (!line.startsWith("Name")) continue;
            return line.substring(5).trim();
        }
        return "";
    }

    private CpuInfo() {
    }
}

