/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.sampler.sub;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.sampler.Sampler;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.sampler.AbstractSampler;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.util.LangKeys;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.util.text.event.ClickEvent;

public final class SamplerUtil {
    static String upload(FlareAPI flare, ExportProps exportProps, Sampler sampler, boolean live, boolean stop) throws Throwable {
        FlareSamplerProtos.SamplerData samplerData = SamplerUtil.getSamplerProto(flare, exportProps, sampler, stop);
        String key = live ? flare.bytebinClient().postContent("application/x-spark-sampler", "live", samplerData) : flare.bytebinClient().postContent("application/x-spark-sampler", samplerData);
        String url = flare.viewerUrl() + key;
        return url;
    }

    static Path save(FlareAPI flare, ExportProps exportProps, Sampler sampler, boolean stop) throws IOException {
        Path profilerPath = flare.saveDirectory().resolve("profiler");
        String fileName = DateTimeFormatter.ofPattern("yyyy-MM-dd-hh_mm_ss").format(LocalDateTime.now()) + ".sparkprofile";
        Path profilerFile = profilerPath.resolve(fileName);
        Files.createDirectories(profilerPath, new FileAttribute[0]);
        Files.write(profilerFile, SamplerUtil.getSamplerProto(flare, exportProps, sampler, stop).toByteArray(), new OpenOption[0]);
        return profilerFile;
    }

    static void upload(FlareAPI flare, ExportProps exportProps, FlareSubCommand.CommandSender sender, Sampler sampler, boolean live, boolean stop) {
        if (!exportProps.saveToFile()) {
            flare.runAsync(() -> {
                try {
                    String url = SamplerUtil.upload(flare, exportProps, sampler, live, stop);
                    flare.syncWithServer(() -> sender.accept(LangKeys.SAMPLER_UPLOADED_REPORT, msg -> msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url)), url));
                }
                catch (Throwable t) {
                    flare.syncWithServer(() -> {
                        sender.accept(LangKeys.SAMPLER_CANNOT_UPLOAD_REPORT, t.toString());
                        flare.logger().fatal((Object)t);
                    });
                    SamplerUtil.save(flare, exportProps, sender, sampler, stop);
                }
            });
        } else {
            SamplerUtil.save(flare, exportProps, sender, sampler, stop);
        }
    }

    static void save(FlareAPI flare, ExportProps exportProps, FlareSubCommand.CommandSender sender, Sampler sampler, boolean stop) {
        flare.runAsync(() -> {
            try {
                String profilerFile = SamplerUtil.save(flare, exportProps, sampler, stop).toFile().getAbsolutePath();
                flare.syncWithServer(() -> {
                    sender.accept(LangKeys.SAMPLER_SAVED_REPORT, msg -> msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, profilerFile)), profilerFile);
                    sender.accept(LangKeys.SAMPLER_SAVED_REPORT_HINT, flare.viewerUrl());
                });
            }
            catch (IOException e) {
                flare.syncWithServer(() -> {
                    sender.accept(LangKeys.CANNOT_SAVE_TO_DISK, e.toString());
                    flare.logger().fatal((Object)e);
                });
            }
        });
    }

    private static FlareSamplerProtos.SamplerData getSamplerProto(FlareAPI flare, ExportProps exportProps, Sampler sampler, boolean stop) {
        return ((AbstractSampler)sampler).toProto(flare, exportProps, stop);
    }

    private SamplerUtil() {
    }
}

