/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.sampler.sub;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.sampler.SamplerContainer;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.command.sub.sampler.sub.SamplerUtil;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.util.LangKeys;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class SamplerStopCommand
extends FlareSubCommand {
    private final boolean cancel;

    public SamplerStopCommand(FlareAPI flare, boolean cancel) {
        super(flare);
        this.cancel = cancel;
    }

    public String func_71517_b() {
        return this.cancel ? "cancel" : "stop";
    }

    public String func_71518_a(ICommandSender sender) {
        if (this.cancel) {
            return "/flare sampler cancel";
        }
        return "/flare sampler stop [--arguments]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        SamplerContainer samplerContainer = this.flare.samplerContainer();
        if (samplerContainer.isSamplerActive()) {
            if (this.cancel) {
                this.sendMessage(sender, LangKeys.SAMPLER_CANCELLING, new Object[0]);
                samplerContainer.stopSampler(true);
                return;
            }
            String comment = this.getArgValue(args, "comment");
            boolean separateParentCalls = this.hasArg(args, "separate-parent-calls");
            boolean saveToFile = this.hasArg(args, "save-to-file");
            ExportProps exportProps = samplerContainer.getExportProps();
            if (comment != null) {
                exportProps.comment(comment);
            }
            if (separateParentCalls && !exportProps.separateParentCalls()) {
                exportProps.separateParentCalls(true);
            }
            if (saveToFile) {
                exportProps.saveToFile(true);
            }
            try {
                this.sendMessage(sender, LangKeys.SAMPLER_STOPPING, new Object[0]);
                Object sampler = samplerContainer.stopSampler(false);
                SamplerUtil.upload(this.flare, samplerContainer.getExportProps(), (k, c, a) -> this.sendMessage(sender, k, c, a), sampler, false, true);
            }
            catch (Throwable t) {
                this.sendMessage(sender, LangKeys.SAMPLER_FAILED_UNEXPECTEDLY, new Object[0]);
                this.flare.logger().fatal((Object)t);
            }
        } else {
            this.sendMessage(sender, LangKeys.SAMPLER_HAS_NOT_STARTED, new Object[0]);
        }
    }
}

