/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.sampler.sub;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.sampler.Sampler;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.util.FormatUtil;
import com.cleanroommc.flare.util.LangKeys;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class SamplerInfoCommand
extends FlareSubCommand {
    public SamplerInfoCommand(FlareAPI flare) {
        super(flare);
    }

    public String func_71517_b() {
        return "info";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare sampler info";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Sampler sampler = this.flare.samplerContainer().activeSampler();
        if (sampler == null) {
            this.sendMessage(sender, LangKeys.SAMPLER_INFO_START, new Object[0]);
        } else {
            long runningTime = (System.currentTimeMillis() - sampler.startTime()) / 1000L;
            this.sendMessage(sender, LangKeys.SAMPLER_INFO_STARTED, FormatUtil.formatSeconds(runningTime));
            this.sendMessage(sender, LangKeys.SAMPLER_INFO_VIEW, new Object[0]);
            long timeout = sampler.autoEndTime();
            if (timeout == -1L) {
                this.sendMessage(sender, LangKeys.SAMPLER_INFO_STOP, new Object[0]);
            } else {
                this.sendMessage(sender, LangKeys.SAMPLER_INFO_STOPPING, FormatUtil.formatSeconds((timeout - System.currentTimeMillis()) / 1000L) + ".");
            }
            this.sendMessage(sender, LangKeys.SAMPLER_INFO_CANCEL, new Object[0]);
        }
    }
}

