/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.statistic;

import java.time.Duration;
import javax.annotation.Nonnull;

public interface StatisticWindow {
    @Nonnull
    public Duration length();

    public static enum MillisPerTick implements StatisticWindow
    {
        SECONDS_10(Duration.ofSeconds(10L)),
        MINUTES_1(Duration.ofMinutes(1L)),
        MINUTES_5(Duration.ofMinutes(5L));

        private final Duration value;

        private MillisPerTick(Duration value) {
            this.value = value;
        }

        @Override
        @Nonnull
        public Duration length() {
            return this.value;
        }
    }

    public static enum TicksPerSecond implements StatisticWindow
    {
        SECONDS_5(Duration.ofSeconds(5L)),
        SECONDS_10(Duration.ofSeconds(10L)),
        MINUTES_1(Duration.ofMinutes(1L)),
        MINUTES_5(Duration.ofMinutes(5L)),
        MINUTES_15(Duration.ofMinutes(15L));

        private final Duration value;

        private TicksPerSecond(Duration value) {
            this.value = value;
        }

        @Override
        @Nonnull
        public Duration length() {
            return this.value;
        }
    }

    public static enum CpuUsage implements StatisticWindow
    {
        SECONDS_10(Duration.ofSeconds(10L)),
        MINUTES_1(Duration.ofMinutes(1L)),
        MINUTES_15(Duration.ofMinutes(15L));

        private final Duration value;

        private CpuUsage(Duration value) {
            this.value = value;
        }

        @Override
        @Nonnull
        public Duration length() {
            return this.value;
        }
    }
}

