/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.sampler.thread;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface ThreadGrouper {
    public static final ThreadGrouper BY_NAME = new ThreadGrouper(){

        @Override
        public String group(long threadId, String threadName) {
            return threadName;
        }

        @Override
        public String label(String group) {
            return group;
        }
    };
    public static final ThreadGrouper BY_POOL = new ThreadGrouper(){
        private final Pattern pattern = Pattern.compile("^(.*?)[-# ]+\\d+$");
        private final Map<Long, String> cache = new ConcurrentHashMap<Long, String>();
        private final Map<String, Set<Long>> seen = new ConcurrentHashMap<String, Set<Long>>();

        @Override
        public String group(long threadId, String threadName) {
            String cached = this.cache.get(threadId);
            if (cached != null) {
                return cached;
            }
            Matcher matcher = this.pattern.matcher(threadName);
            if (!matcher.matches()) {
                return threadName;
            }
            String group = matcher.group(1).trim();
            this.cache.put(threadId, group);
            this.seen.computeIfAbsent(group, g -> ConcurrentHashMap.newKeySet()).add(threadId);
            return group;
        }

        @Override
        public String label(String group) {
            int count = this.seen.getOrDefault(group, Collections.emptySet()).size();
            if (count == 0) {
                return group;
            }
            return group + " (x" + count + ")";
        }
    };
    public static final ThreadGrouper AS_ONE = new ThreadGrouper(){
        private final Set<Long> seen = ConcurrentHashMap.newKeySet();

        @Override
        public String group(long threadId, String threadName) {
            this.seen.add(threadId);
            return "root";
        }

        @Override
        public String label(String group) {
            return "All (x" + this.seen.size() + ")";
        }
    };

    public String group(long var1, String var3);

    public String label(String var1);
}

