/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.sampler.node.description;

import java.util.Objects;

public class NodeDescription {
    private final String className;
    private final String methodName;
    private final String methodDescription;
    private final int lineNumber;
    private final int parentLineNumber;
    private final int hash;

    public NodeDescription(String className, String methodName, int lineNumber, int parentLineNumber) {
        this.className = className;
        this.methodName = methodName;
        this.methodDescription = null;
        this.lineNumber = lineNumber;
        this.parentLineNumber = parentLineNumber;
        this.hash = Objects.hash(this.className, this.methodName, this.lineNumber, this.parentLineNumber);
    }

    public NodeDescription(String className, String methodName, String methodDescription) {
        this.className = className;
        this.methodName = methodName;
        this.methodDescription = methodDescription;
        this.lineNumber = -1;
        this.parentLineNumber = -1;
        this.hash = Objects.hash(this.className, this.methodName, this.methodDescription);
    }

    public String className() {
        return this.className;
    }

    public String methodName() {
        return this.methodName;
    }

    public String methodDescription() {
        return this.methodDescription;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public int parentLineNumber() {
        return this.parentLineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeDescription description = (NodeDescription)o;
        return this.hash == description.hash && this.lineNumber == description.lineNumber && this.parentLineNumber == description.parentLineNumber && this.className.equals(description.className) && this.methodName.equals(description.methodName) && Objects.equals(this.methodDescription, description.methodDescription);
    }

    public int hashCode() {
        return this.hash;
    }
}

