/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.context;

import com.cleanroommc.flare.api.context.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public interface FlareServerContext {
    public MinecraftServer server();

    public long serverStartTime();

    public <T> Future<T> callAsync(Callable<T> var1);

    public void syncWithServer(Runnable var1);

    default public void runAsync(Runnable runnable) {
        this.callAsync(Executors.callable(runnable));
    }

    default public List<World> worlds() {
        return Arrays.asList(this.server().field_71305_c);
    }

    default public List<Chunk> chunks() {
        return this.worlds().stream().map(this::chunks).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public List<Chunk> chunks(World world) {
        return new ArrayList<Chunk>(((ChunkProviderServer)world.func_72863_F()).func_189548_a());
    }

    default public List<Region> regions(World world) {
        return Region.mapChunks(this.chunks(world));
    }

    default public List<EntityPlayerMP> players() {
        return this.server().func_184103_al().func_181057_v();
    }

    default public List<Entity> entities() {
        return this.worlds().stream().map(this::entities).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    default public List<Entity> entities(World world) {
        return world.field_72996_f;
    }

    default public List<Entity> entities(Chunk chunk) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (ClassInheritanceMultiMap map : chunk.func_177429_s()) {
            entities.addAll((Collection<Entity>)map);
        }
        return entities;
    }

    default public List<TileEntity> tileEntities() {
        return this.worlds().stream().map(this::tileEntities).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    default public List<TileEntity> tileEntities(World world) {
        return world.field_147482_g;
    }

    default public List<TileEntity> tileEntities(Chunk chunk) {
        return new ArrayList<TileEntity>(chunk.func_177434_r().values());
    }
}

