/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api;

import com.cleanroommc.flare.api.activity.ActivityLog;
import com.cleanroommc.flare.api.content.BytebinClient;
import com.cleanroommc.flare.api.context.FlareServerContext;
import com.cleanroommc.flare.api.metadata.MetadataProvider;
import com.cleanroommc.flare.api.ping.PingStatistics;
import com.cleanroommc.flare.api.sampler.Sampler;
import com.cleanroommc.flare.api.sampler.SamplerBuilder;
import com.cleanroommc.flare.api.sampler.SamplerContainer;
import com.cleanroommc.flare.api.sampler.node.MethodDescriptorResolver;
import com.cleanroommc.flare.api.sampler.source.ClassSourceLookup;
import com.cleanroommc.flare.api.sampler.source.SourceMetadata;
import com.cleanroommc.flare.api.sampler.thread.ThreadDumper;
import com.cleanroommc.flare.api.tick.TickRoutine;
import com.cleanroommc.flare.api.tick.TickStatistics;
import com.cleanroommc.flare.common.websocket.TrustedKeyStore;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Logger;

public interface FlareAPI
extends FlareServerContext {
    public static FlareAPI getInstance(String key) {
        Object flare = Launch.blackboard.get(key + "FlareInstance");
        if (flare == null) {
            return null;
        }
        return (FlareAPI)flare;
    }

    public static FlareAPI getInstance() {
        FlareAPI flare = FlareAPI.getInstance("Main");
        if (flare == null) {
            throw new IllegalStateException("Flare not instantiated yet!");
        }
        return flare;
    }

    public static <T> T getIfPresent(String key, Function<FlareAPI, T> function) {
        FlareAPI flare = FlareAPI.getInstance(key);
        if (flare != null) {
            return function.apply(flare);
        }
        return null;
    }

    public static <T> T getIfPresent(Function<FlareAPI, T> function) {
        return FlareAPI.getIfPresent("", function);
    }

    public static void runIfPresent(String key, Consumer<FlareAPI> consumer) {
        FlareAPI flare = FlareAPI.getInstance(key);
        if (flare != null) {
            consumer.accept(flare);
        }
    }

    public static void runIfPresent(Consumer<FlareAPI> consumer) {
        FlareAPI.runIfPresent("", consumer);
    }

    public <T> T get(Class<T> var1);

    public Logger logger();

    public Path saveDirectory();

    public ActivityLog activityLog();

    public String viewerUrl();

    public BytebinClient bytebinClient();

    public TrustedKeyStore trustedKeyStore();

    public ThreadDumper serverThreadDumper();

    public SamplerBuilder samplerBuilder();

    public <T extends Sampler> SamplerContainer<T> samplerContainer();

    public TickStatistics tickStats();

    public PingStatistics pingStats();

    public TickRoutine tickRoutine();

    public MethodDescriptorResolver methodDescriptorResolver();

    public ClassSourceLookup classSourceLookup();

    public MetadataProvider metadataProvider();

    public List<SourceMetadata> sourceMetadata();
}

