/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.dimstack.Main;
import cd4017be.dimstack.Objects;
import cd4017be.dimstack.block.Portal;
import cd4017be.dimstack.command.Regen;
import cd4017be.dimstack.core.PortalConfiguration;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class PortalGen
implements IWorldGenerator {
    static boolean genImmediate = false;

    public PortalGen() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)Integer.MAX_VALUE);
        Regen.generators.put("portals", this);
    }

    public void generate(Random random, int cx, int cz, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        PortalConfiguration pc = PortalConfiguration.get(world);
        Chunk chunk = world.func_72964_e(cx, cz);
        PortalConfiguration pc1 = pc.nextFloor();
        if (pc1 != null) {
            PortalGen.placePortals(chunk, 0, false, pc1, pc.flipped ^ pc1.flipped ? 0 : pc1.ceilY);
        }
        if ((pc1 = pc.nextCeil()) != null) {
            int yc = pc.ceilY;
            if (genImmediate || chunk.func_76625_h() >= yc - 15) {
                PortalGen.placePortals(chunk, yc, false, pc1, pc.flipped ^ pc1.flipped ? pc1.ceilY : 0);
            } else {
                pc.setTopOpen();
            }
        }
    }

    public static void fixCeil(World world, BlockPos pos, int y, PortalConfiguration other, int Y) {
        int x0 = pos.func_177958_n() - 8;
        int x1 = x0 + 16;
        int z0 = pos.func_177952_p() - 8;
        int z1 = z0 + 16;
        IChunkProvider cp = world.func_72863_F();
        Chunk chunk = cp.func_186026_b(x0 >> 4, z0 >> 4);
        if (chunk != null && chunk.func_186032_a(x0, y, z0).func_185904_a() != Objects.M_PORTAL) {
            PortalGen.placePortals(chunk, y, true, other, Y);
        }
        if ((chunk = cp.func_186026_b(x1 >> 4, z0 >> 4)) != null && chunk.func_186032_a(x1, y, z0).func_185904_a() != Objects.M_PORTAL) {
            PortalGen.placePortals(chunk, y, true, other, Y);
        }
        if ((chunk = cp.func_186026_b(x0 >> 4, z1 >> 4)) != null && chunk.func_186032_a(x0, y, z1).func_185904_a() != Objects.M_PORTAL) {
            PortalGen.placePortals(chunk, y, true, other, Y);
        }
        if ((chunk = cp.func_186026_b(x1 >> 4, z1 >> 4)) != null && chunk.func_186032_a(x1, y, z1).func_185904_a() != Objects.M_PORTAL) {
            PortalGen.placePortals(chunk, y, true, other, Y);
        }
    }

    public static void placePortals(Chunk chunk, int y, boolean update, PortalConfiguration neighb, int Y) {
        Chunk chunk_;
        if (update && PortalConfiguration.retrogen > 1) {
            PortalGen.retrogenBedrock(chunk);
        }
        IBlockState state = Objects.PORTAL.func_176223_P();
        boolean s0 = (Boolean)state.func_177229_b((IProperty)Portal.solidOther1);
        boolean s_ = (Boolean)state.func_177229_b((IProperty)Portal.solidOther2);
        boolean s1 = (Boolean)state.func_177229_b((IProperty)Portal.solidThis1);
        boolean s2 = (Boolean)state.func_177229_b((IProperty)Portal.solidThis2);
        int y1 = y == 0 ? 1 : y - 1;
        int y2 = y1 + y1 - y;
        int x0 = chunk.field_76635_g << 4;
        int x1 = x0 + 16;
        int z0 = chunk.field_76647_h << 4;
        int z1 = z0 + 16;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        World world = chunk.func_177412_p();
        WorldServer world_ = DimensionManager.getWorld((int)neighb.dimId);
        if (world_ != null && (chunk_ = world_.func_72863_F().func_186026_b(chunk.field_76635_g, chunk.field_76647_h)) != null && (genImmediate || chunk_.func_76625_h() >= Y - 15)) {
            if (update && PortalConfiguration.retrogen > 1) {
                PortalGen.retrogenBedrock(chunk_);
            }
            IBlockState state_ = state.func_177226_a((IProperty)Portal.solidOther1, (Comparable)Boolean.valueOf(s1)).func_177226_a((IProperty)Portal.solidOther2, (Comparable)Boolean.valueOf(s2)).func_177226_a((IProperty)Portal.solidThis1, (Comparable)Boolean.valueOf(s0)).func_177226_a((IProperty)Portal.solidThis2, (Comparable)Boolean.valueOf(s_));
            int y0 = Y == 0 ? 1 : Y - 1;
            int y_ = y0 + y0 - Y;
            for (int z = z0; z < z1; ++z) {
                for (int x = x0; x < x1; ++x) {
                    IBlockState olds = chunk.func_186032_a(x, y, z);
                    if (olds.func_185904_a() == Objects.M_PORTAL) continue;
                    if (s2 ^ Portal.isSolid(chunk.func_186032_a(x, y2, z))) {
                        s2 = !s2;
                        state = state.func_177226_a((IProperty)Portal.solidThis2, (Comparable)Boolean.valueOf(s2));
                        state_ = state_.func_177226_a((IProperty)Portal.solidOther2, (Comparable)Boolean.valueOf(s2));
                    }
                    if (s1 ^ Portal.isSolid(chunk.func_186032_a(x, y1, z))) {
                        s1 = !s1;
                        state = state.func_177226_a((IProperty)Portal.solidThis1, (Comparable)Boolean.valueOf(s1));
                        state_ = state_.func_177226_a((IProperty)Portal.solidOther1, (Comparable)Boolean.valueOf(s1));
                    }
                    if (s_ ^ Portal.isSolid(chunk_.func_186032_a(x, y_, z))) {
                        s_ = !s_;
                        state = state.func_177226_a((IProperty)Portal.solidOther2, (Comparable)Boolean.valueOf(s_));
                        state_ = state_.func_177226_a((IProperty)Portal.solidThis2, (Comparable)Boolean.valueOf(s_));
                    }
                    if (s0 ^ Portal.isSolid(chunk_.func_186032_a(x, y0, z))) {
                        s0 = !s0;
                        state = state.func_177226_a((IProperty)Portal.solidOther1, (Comparable)Boolean.valueOf(s0));
                        state_ = state_.func_177226_a((IProperty)Portal.solidThis1, (Comparable)Boolean.valueOf(s0));
                    }
                    chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), state);
                    if (update) {
                        world.func_184138_a((BlockPos)pos, olds, state, 2);
                    }
                    if ((olds = chunk_.func_186032_a(x, Y, z)) == state_) continue;
                    chunk_.func_177436_a((BlockPos)pos.func_181079_c(x, Y, z), state_);
                    world_.func_184138_a((BlockPos)pos, olds, state_, 2);
                }
            }
            return;
        }
        for (int z = z0; z < z1; ++z) {
            for (int x = x0; x < x1; ++x) {
                IBlockState olds = chunk.func_186032_a(x, y, z);
                if (olds.func_185904_a() == Objects.M_PORTAL) continue;
                if (s2 ^ Portal.isSolid(chunk.func_186032_a(x, y2, z))) {
                    s2 = !s2;
                    state = state.func_177226_a((IProperty)Portal.solidThis2, (Comparable)Boolean.valueOf(s2));
                }
                if (s1 ^ Portal.isSolid(chunk.func_186032_a(x, y1, z))) {
                    s1 = !s1;
                    state = state.func_177226_a((IProperty)Portal.solidThis1, (Comparable)Boolean.valueOf(s1));
                }
                if (s0 ^ Portal.isSolid(chunk.func_186032_a(x, y, z))) {
                    s0 = !s0;
                    state = state.func_177226_a((IProperty)Portal.solidOther1, (Comparable)Boolean.valueOf(s0)).func_177226_a((IProperty)Portal.solidOther2, (Comparable)Boolean.valueOf(s0));
                }
                chunk.func_177436_a((BlockPos)pos.func_181079_c(x, y, z), state);
                if (!update) continue;
                world.func_184138_a((BlockPos)pos, olds, state, 2);
            }
        }
    }

    public static void retrogenBedrock(Chunk chunk) {
        Main.proxy.worldgenBedrock.generate(null, chunk.field_76635_g, chunk.field_76647_h, chunk.func_177412_p(), null, null);
    }

    public void initConfig(RecipeScriptContext.ConfigConstants cfg) {
        genImmediate = cfg.getNumber("ceil_on_demand", 1.0) < 1.0;
    }
}

