/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.dimstack.Main;
import cd4017be.dimstack.api.DisableVanillaOres;
import cd4017be.dimstack.api.OreGeneration;
import cd4017be.dimstack.api.gen.IOreGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.command.Regen;
import cd4017be.dimstack.core.PortalConfiguration;
import cd4017be.dimstack.worldgen.OreGenCentered;
import cd4017be.dimstack.worldgen.OreGenEven;
import cd4017be.dimstack.worldgen.OreGenGaussian;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class OreGenHandler
implements IWorldGenerator,
RecipeAPI.IRecipeHandler {
    private static final String OREGEN = "oregen";
    static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        MinecraftForge.ORE_GEN_BUS.register((Object)Main.proxy.worldgenOres);
    }

    public OreGenHandler() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0);
        RecipeAPI.Handlers.put(OREGEN, this);
        OreGeneration.REGISTRY.put("even", OreGenEven::new);
        OreGeneration.REGISTRY.put("center", OreGenCentered::new);
        OreGeneration.REGISTRY.put("gauss", OreGenGaussian::new);
        Regen.generators.put("ores", this);
    }

    @SubscribeEvent
    public void onGenerate(OreGenEvent.GenerateMinable event) {
        DisableVanillaOres cfg = PortalConfiguration.get(event.getWorld()).getSettings(DisableVanillaOres.class, false);
        if (cfg == null) {
            return;
        }
        if (cfg.disabled(event.getType())) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void initConfig(RecipeScriptContext.ConfigConstants cfg) {
        DisableVanillaOres d = PortalConfiguration.get(0).getSettings(DisableVanillaOres.class, true);
        for (OreGenEvent.GenerateMinable.EventType t : OreGenEvent.GenerateMinable.EventType.values()) {
            String id = "disable_" + t.name().toLowerCase();
            d.setDisabled(t, (Boolean)cfg.get(id, Boolean.class, (Object)Boolean.FALSE));
            cfg.get(id, OreDisableInfo.class, (Object)new OreDisableInfo(t));
        }
        if (d.disabled(OreGenEvent.GenerateMinable.EventType.QUARTZ)) {
            PortalConfiguration.get(-1).getSettings(DisableVanillaOres.class, true).setDisabled(OreGenEvent.GenerateMinable.EventType.QUARTZ, true);
        }
    }

    public void generate(Random random, int cx, int cy, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        OreGeneration cfg = PortalConfiguration.get(world).getSettings(OreGeneration.class, false);
        if (cfg == null) {
            return;
        }
        Chunk chunk = chunkProvider.func_186025_d(cx, cy);
        for (IOreGenerator og : cfg.entries) {
            og.generate(chunk, random);
        }
    }

    public void addRecipe(Parameters param) {
        OreGeneration cfg = PortalConfiguration.get(param.getIndex(1)).getSettings(OreGeneration.class, true);
        BlockPredicate target = BlockPredicate.parse(param.get(2));
        float veins = (float)param.getNumber(3);
        int count = param.getIndex(4);
        IBlockState ore = BlockPredicate.parse((String)param.get(5, String.class));
        double[] heights = param.getVectorOrAll(7);
        String type = param.getString(6);
        if (type.startsWith("even")) {
            cfg.entries.add(new OreGenEven(ore, count, veins, target, (int)heights[0], (int)heights[1]));
        } else if (type.startsWith("center")) {
            cfg.entries.add(new OreGenCentered(ore, count, veins, target, (int)heights[0], (int)heights[1], (int)heights[2]));
        } else if (type.startsWith("gauss")) {
            cfg.entries.add(new OreGenGaussian(ore, count, veins, target, (float)heights[0], (float)heights[1]));
        } else {
            throw new IllegalArgumentException("invalid ore distribution mode: " + type);
        }
    }

    private static class OreDisableInfo
    implements IOperand {
        private final OreGenEvent.GenerateMinable.EventType type;

        OreDisableInfo(OreGenEvent.GenerateMinable.EventType type) {
            this.type = type;
        }

        public boolean asBool() throws Error {
            return true;
        }

        public Object value() {
            return this;
        }

        public IOperand get(IOperand idx) {
            DisableVanillaOres cfg = PortalConfiguration.get(idx.asIndex()).getSettings(DisableVanillaOres.class, false);
            return cfg != null && cfg.disabled(this.type) ? Number.TRUE : Number.FALSE;
        }

        public void put(IOperand idx, IOperand val) {
            try {
                boolean disable = val.asBool();
                DisableVanillaOres cfg = PortalConfiguration.get(idx.asIndex()).getSettings(DisableVanillaOres.class, disable);
                if (cfg != null) {
                    cfg.setDisabled(this.type, disable);
                }
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
    }
}

