/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.dimstack.api.TerrainGeneration;
import cd4017be.dimstack.api.gen.ITerrainGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.api.util.NoiseField;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class NetherTop
implements ITerrainGenerator {
    public static final String ID = "nether";
    private double[] pr;
    private double[] ssr;
    private double[] gvr;
    private double[] p3r;
    private double[] ar;
    private double[] br;
    private double[] buffer;
    private double[] vWaves;
    private final IBlockState main;
    private final IBlockState liquid;
    private final IBlockState sand1B;
    private final IBlockState sand1;
    private final IBlockState sand2B;
    private final IBlockState sand2;
    private final int minY;
    private final int maxY;
    private final int lakeLvl;
    private final int sandLvl;
    private final int border;
    private int fieldSize;
    private int fieldOfs;

    public NetherTop(int minY, int maxY, int border, int lakeLvl, int sandLvl, IBlockState main, IBlockState liquid, IBlockState sand1b, IBlockState sand1, IBlockState sand2b, IBlockState sand2) {
        this.main = main;
        this.liquid = liquid;
        this.sand1B = sand1b;
        this.sand1 = sand1;
        this.sand2B = sand2b;
        this.sand2 = sand2;
        this.minY = minY;
        this.maxY = maxY;
        this.lakeLvl = lakeLvl;
        this.sandLvl = sandLvl;
        this.border = border;
        this.initVertTerrain();
    }

    public NetherTop(NBTTagCompound nbt) {
        this.main = BlockPredicate.parse(nbt.func_74779_i("main"));
        this.liquid = BlockPredicate.parse(nbt.func_74779_i("liquid"));
        this.sand1B = BlockPredicate.parse(nbt.func_74779_i("sand1B"));
        this.sand1 = BlockPredicate.parse(nbt.func_74779_i("sand1"));
        this.sand2B = BlockPredicate.parse(nbt.func_74779_i("sand2B"));
        this.sand2 = BlockPredicate.parse(nbt.func_74779_i("sand2"));
        this.lakeLvl = nbt.func_74771_c("lakeY") & 0xFF;
        this.sandLvl = nbt.func_74771_c("sandY") & 0xFF;
        this.minY = nbt.func_74771_c("minY") & 0xFF;
        this.maxY = (nbt.func_74771_c("maxY") & 0xFF) + 1;
        this.border = nbt.func_74771_c("border");
        this.initVertTerrain();
    }

    private void initVertTerrain() {
        int ny;
        int y0 = this.minY / 8;
        int y1 = (this.maxY - 1) / 8 + 1;
        this.fieldSize = ny = y1 - y0 + 1;
        this.fieldOfs = y0;
        double[] vWaves = new double[ny];
        double b = (double)this.border / 8.0;
        for (int y = 0; y < ny; ++y) {
            vWaves[y] = Math.cos((double)(y + y0) * Math.PI * 6.0 / 16.0) * 2.0;
            double yEdge = y;
            if (y > ny / 2) {
                yEdge = ny - 1 - y;
            }
            if (!(yEdge < b)) continue;
            yEdge = 1.0 - yEdge / b;
            int n = y;
            vWaves[n] = vWaves[n] - yEdge * yEdge * yEdge * 640.0;
        }
        this.vWaves = vWaves;
    }

    @Override
    public String getRegistryName() {
        return ID;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("main", BlockPredicate.serialize(this.main));
        nbt.func_74778_a("liquid", BlockPredicate.serialize(this.liquid));
        nbt.func_74778_a("sand1B", BlockPredicate.serialize(this.sand1B));
        nbt.func_74778_a("sand1", BlockPredicate.serialize(this.sand1));
        nbt.func_74778_a("sand2B", BlockPredicate.serialize(this.sand2B));
        nbt.func_74778_a("sand2", BlockPredicate.serialize(this.sand2));
        nbt.func_74774_a("lakeY", (byte)this.lakeLvl);
        nbt.func_74774_a("sandY", (byte)this.sandLvl);
        nbt.func_74774_a("minY", (byte)this.minY);
        nbt.func_74774_a("maxY", (byte)(this.maxY - 1));
        nbt.func_74774_a("border", (byte)this.border);
        return nbt;
    }

    @Override
    public void generate(World world, ChunkPrimer cp, int cx, int cz, TerrainGeneration cfg) {
        this.buffer = this.getHeights(this.buffer, cx * 4, this.fieldOfs, cz * 4, 5, this.fieldSize, 5, cfg);
        IBlockState main = this.main;
        IBlockState liquid = this.liquid;
        int msl = this.lakeLvl;
        NoiseField.interpolate3D(this.buffer, 4, 8, this.fieldOfs * 8, this.minY, this.maxY, (x, y, z, f) -> cp.func_177855_a(x, y, z, (IBlockState)(f > 0.0 ? main : (y < msl ? liquid : null))));
        this.buildSurfaces(cx, cz, cp, cfg);
    }

    private double[] getHeights(double[] data, int ox, int oy, int oz, int nx, int ny, int nz, TerrainGeneration cfg) {
        if (data == null) {
            data = new double[nx * ny * nz];
        }
        double dh = 684.412;
        double dv = 2053.236;
        this.pr = cfg.perlin.func_76304_a(this.pr, ox, oy, oz, nx, ny, nz, 8.555150000000001, 34.2206, 8.555150000000001);
        double[] pr = this.pr;
        this.ar = cfg.l_perlin1.func_76304_a(this.ar, ox, oy, oz, nx, ny, nz, 684.412, 2053.236, 684.412);
        double[] ar = this.ar;
        this.br = cfg.l_perlin2.func_76304_a(this.br, ox, oy, oz, nx, ny, nz, 684.412, 2053.236, 684.412);
        double[] br = this.br;
        double[] vWaves = this.vWaves;
        int i = 0;
        for (int x = 0; x < nx; ++x) {
            for (int z = 0; z < nz; ++z) {
                for (int y = 0; y < ny; ++y) {
                    double a = ar[i] / 512.0;
                    double b = br[i] / 512.0;
                    double weight = (pr[i] / 10.0 + 1.0) / 2.0;
                    double val = weight < 0.0 ? a : (weight > 1.0 ? b : a + (b - a) * weight);
                    data[i++] = val - vWaves[y];
                }
            }
        }
        return data;
    }

    public void buildSurfaces(int chunkX, int chunkZ, ChunkPrimer primer, TerrainGeneration cfg) {
        int msl = this.sandLvl;
        double scale = 0.03125;
        this.ssr = cfg.perlin2.func_76304_a(this.ssr, chunkX * 16, chunkZ * 16, 128, 16, 16, 1, 0.03125, 0.03125, 1.0);
        double[] ssr = this.ssr;
        this.gvr = cfg.perlin2.func_76304_a(this.gvr, chunkX * 16, 237, chunkZ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        double[] gvr = this.gvr;
        this.p3r = cfg.perlin3.func_76304_a(this.p3r, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        double[] p3r = this.p3r;
        Random rand = cfg.rand;
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        IBlockState main = this.main;
        IBlockState liquid = this.liquid;
        IBlockState sand1 = this.sand1;
        IBlockState sand1B = this.sand1B;
        IBlockState sand2 = this.sand2;
        IBlockState sand2B = this.sand2B;
        int y1 = this.maxY - 1;
        int y0 = this.minY;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                boolean genSs = ssr[z + x * 16] + rand.nextDouble() * 0.2 > 0.0;
                boolean genGv = gvr[z + x * 16] + rand.nextDouble() * 0.2 > 0.0;
                int thick = (int)(p3r[z + x * 16] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int str = -1;
                IBlockState stateT = main;
                IBlockState stateB = main;
                for (int y = y1; y >= y0; --y) {
                    IBlockState state = primer.func_177856_a(x, y, z);
                    if (state.func_177230_c() != null && state.func_185904_a() != Material.field_151579_a) {
                        if (state != main) continue;
                        if (str == -1) {
                            if (thick <= 0) {
                                stateT = air;
                                stateB = main;
                            } else if (y >= msl - 4 && y <= msl + 1) {
                                stateT = main;
                                stateB = main;
                                if (genGv) {
                                    stateT = sand2;
                                    stateB = sand2B;
                                }
                                if (genSs) {
                                    stateT = sand1;
                                    stateB = sand1B;
                                }
                            }
                            if (y < msl && (stateT == null || stateT.func_185904_a() == Material.field_151579_a)) {
                                stateT = liquid;
                            }
                            str = thick;
                            if (y >= msl - 1) {
                                primer.func_177855_a(x, y, z, stateT);
                                continue;
                            }
                            primer.func_177855_a(x, y, z, stateB);
                            continue;
                        }
                        if (str <= 0) continue;
                        --str;
                        primer.func_177855_a(x, y, z, stateB);
                        continue;
                    }
                    str = -1;
                }
            }
        }
    }
}

