/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.api;

import cd4017be.dimstack.api.API;
import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.SharedNoiseFields;
import cd4017be.dimstack.api.gen.ITerrainGenerator;
import cd4017be.dimstack.api.util.CfgList;
import cd4017be.dimstack.api.util.NoiseField;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;

public class TerrainGeneration
extends CfgList<ITerrainGenerator> {
    public static final HashMap<String, Function<NBTTagCompound, ITerrainGenerator>> REGISTRY = new HashMap();
    public NoiseGeneratorOctaves depth;
    public NoiseGeneratorOctaves l_perlin1;
    public NoiseGeneratorOctaves l_perlin2;
    public NoiseGeneratorOctaves scale;
    public NoiseGeneratorOctaves perlin;
    public NoiseGeneratorOctaves forest;
    public NoiseGeneratorOctaves perlin2;
    public NoiseGeneratorOctaves perlin3;
    public NoiseGeneratorPerlin height;
    public NoiseGeneratorSimplex islands;
    public Random rand;
    public NoiseField[] noiseFields;
    public int offsetY;
    public int dimId;

    public void deserializeNBT(NBTBase nbt) {
        this.deserializeNBT((NBTTagList)nbt, REGISTRY);
    }

    public void setupNoiseGens(IDimension dim, InitNoiseGensEvent.Context c, Random rand) {
        int h;
        this.depth = c.getDepth();
        this.scale = c.getScale();
        this.perlin = c.getPerlin();
        this.l_perlin1 = c.getLPerlin1();
        this.l_perlin2 = c.getLPerlin2();
        if (c instanceof InitNoiseGensEvent.ContextOverworld) {
            InitNoiseGensEvent.ContextOverworld co = (InitNoiseGensEvent.ContextOverworld)c;
            this.forest = co.getForest();
            this.height = co.getHeight();
        } else if (c instanceof InitNoiseGensEvent.ContextHell) {
            InitNoiseGensEvent.ContextHell ch = (InitNoiseGensEvent.ContextHell)c;
            this.perlin2 = ch.getPerlin2();
            this.perlin3 = ch.getPerlin3();
        } else if (c instanceof InitNoiseGensEvent.ContextEnd) {
            InitNoiseGensEvent.ContextEnd ce = (InitNoiseGensEvent.ContextEnd)c;
            this.islands = ce.getIsland();
        }
        this.rand = rand;
        this.dimId = dim.id();
        int y = 0;
        for (h = dim.height(); h > 0; --h) {
            dim = dim.down();
            y += dim.ceilHeight() - 1;
        }
        while (h < 0) {
            y -= dim.ceilHeight() - 1;
            dim = dim.up();
            ++h;
        }
        this.offsetY = y;
        this.initNoiseFields();
    }

    private void initNoiseFields() {
        SharedNoiseFields snf = API.INSTANCE.getSettings(SharedNoiseFields.class, false);
        int l = snf.noiseFields.length;
        this.noiseFields = new NoiseField[l];
        for (int i = 0; i < l; ++i) {
            NoiseGeneratorOctaves gen;
            NoiseField nf = snf.noiseFields[i].clone();
            byte id = snf.source[i];
            switch (id) {
                case -1: {
                    gen = this.depth;
                    break;
                }
                case -2: {
                    gen = this.scale;
                    break;
                }
                case -3: {
                    gen = this.perlin;
                    break;
                }
                case -4: {
                    gen = this.l_perlin1;
                    break;
                }
                case -5: {
                    gen = this.l_perlin2;
                    break;
                }
                case -6: {
                    gen = this.forest;
                    break;
                }
                case -7: {
                    gen = this.height;
                    break;
                }
                case -8: {
                    gen = this.perlin2;
                    break;
                }
                case -9: {
                    gen = this.perlin3;
                    break;
                }
                default: {
                    gen = nf.gen;
                }
            }
            nf.setGenerator((NoiseGenerator)gen).setOffsetY(this.offsetY);
            this.noiseFields[i] = nf;
        }
        for (ITerrainGenerator g : this.entries) {
            g.initNoise(this);
        }
    }

    public void generate(World world, IChunkGenerator gen, ChunkPrimer cp, int cx, int cz) {
        for (NoiseField f : this.noiseFields) {
            f.prepareFor(cx, cz);
        }
        for (ITerrainGenerator tg : this.entries) {
            tg.generate(world, cp, cx, cz, this);
        }
    }
}

