/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.dimstack.Main;
import cd4017be.dimstack.Objects;
import cd4017be.dimstack.api.DisabledPortals;
import cd4017be.dimstack.block.Portal;
import cd4017be.dimstack.block.ProgressionBarrier;
import cd4017be.dimstack.core.ChunkLoader;
import cd4017be.dimstack.core.Dimensionstack;
import cd4017be.dimstack.worldgen.BlockReplacer;
import cd4017be.dimstack.worldgen.OreGenHandler;
import cd4017be.dimstack.worldgen.PortalGen;
import cd4017be.dimstack.worldgen.TerrainGenHandler;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.script.Module;
import cd4017be.lib.util.FileUtil;
import java.io.File;

public class CommonProxy {
    public PortalGen worldgenPortal;
    public BlockReplacer worldgenBedrock;
    public TerrainGenHandler worldgenTerrain;
    public OreGenHandler worldgenOres;

    public void init() {
        TickRegistry.register();
        this.worldgenTerrain = new TerrainGenHandler();
        this.worldgenPortal = new PortalGen();
        this.worldgenBedrock = new BlockReplacer();
        this.worldgenOres = new OreGenHandler();
        this.setConfig(new RecipeScriptContext.ConfigConstants((Module)RecipeScriptContext.instance.modules.get("verticalDimensionStack")));
    }

    protected void setConfig(RecipeScriptContext.ConfigConstants cfg) {
        String override = (String)cfg.get("override_default", String.class, null);
        if (override != null && Main.dimstack.loadPreset(new File(FileUtil.configDir, override))) {
            Main.LOG.info("Dimension stack default configuration initialized from preset file. Config settings will be ignored!");
        } else {
            Dimensionstack.initConfig(cfg);
            this.worldgenTerrain.initConfig(cfg);
            this.worldgenOres.initConfig(cfg);
        }
        ChunkLoader.initConfig(cfg);
        this.worldgenPortal.initConfig(cfg);
        cfg.get("barrier_block", ProgressionBarrier.class, (Object)Objects.BEDROCK);
        if (cfg.getNumber("disable_nether_portal", 0.0) != 0.0) {
            Main.dimstack.getSettings(DisabledPortals.class, true).add("nether");
        }
        Portal.CREATE_PLATTFORM = (int)cfg.getNumber("create_plattform", (double)Portal.CREATE_PLATTFORM);
    }

    public void registerRenderers() {
    }
}

