/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.handles.object.tileentity;

import com.vandendaelen.handles.config.HandlesConfig;
import com.vandendaelen.handles.tardis.SystemAprioritron;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.tardis.mod.common.systems.SystemStabilizers;
import net.tardis.mod.common.tileentity.TileEntityDoor;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.SpaceTimeCoord;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class TileTardisInterfaceBase
extends TileEntity {
    private UUID ownerID = null;
    public static final String peripheralName = "tardisinterface";
    public static final List<String> METHODS = Arrays.asList("getTardisPos", "setTardisDestination", "startFlight", "setDoors", "isInFlight", "setFueling", "getArtron", "isDoorsOpened", "canFly", "getTravelTime", "getWaypoint", "setWaypoint", "getHealthComponent", "getDimensionsID", "getDimensionName", "setRelativePos", "setDimensionPos", "getTardisDestination", "getDimension", "getTargetDimension", "setField", "getField", "getSystemName", "setStealth", "getStealth", "setStabilizers", "getStabilizers");

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_186855_b("placer")) {
            this.ownerID = compound.func_186857_a("placer");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.ownerID != null) {
            compound.func_186854_a("placer", this.ownerID);
        }
        return compound;
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    public void setOwnerID(UUID ownerID) {
        this.ownerID = ownerID;
        this.func_70296_d();
    }

    public TileEntityTardis getTardis() {
        BlockPos pos = TardisHelper.getTardis((UUID)this.ownerID);
        TileEntityTardis te = (TileEntityTardis)this.field_145850_b.func_175625_s(pos);
        return te;
    }

    public TileEntityDoor getTardisDoor(TileEntityTardis tardis) {
        TileEntity te;
        WorldServer ser;
        if (!this.field_145850_b.field_72995_K && (ser = this.field_145850_b.func_73046_m().func_71218_a(tardis.dimension)) != null && (te = ser.func_175625_s(tardis.getLocation())) instanceof TileEntityDoor) {
            return (TileEntityDoor)te;
        }
        return null;
    }

    public void damageAprioritron() {
        ((SystemAprioritron)((Object)this.getTardis().getSystem(SystemAprioritron.class))).damage();
    }

    protected boolean canRun() {
        if (HandlesConfig.GAMEPLAY.subsystem) {
            if (((SystemAprioritron)((Object)this.getTardis().getSystem(SystemAprioritron.class))).getHealth() <= 0.0f) {
                return false;
            }
            this.damageAprioritron();
        }
        return true;
    }

    public Object[] getTardisPos(TileEntityTardis te) {
        BlockPos tardisPos = te.getLocation();
        return new Object[]{tardisPos.func_177958_n(), tardisPos.func_177956_o(), tardisPos.func_177952_p(), te.dimension};
    }

    public Object[] setTardisDestination(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        Double x = (Double)arguments[0];
        Double y = (Double)arguments[1];
        Double z = (Double)arguments[2];
        Double dimID = arguments.length > 3 ? (Double)arguments[3] : Double.valueOf(te.dimension);
        BlockPos pos = new BlockPos(x.doubleValue(), y.doubleValue(), z.doubleValue());
        te.setDesination(pos, dimID.intValue());
        return new Object[0];
    }

    public Object[] getTardisDestination(TileEntityTardis te) {
        BlockPos destination = te.getDestination();
        int dimension = te.getTargetDim();
        return new Object[]{destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p(), dimension};
    }

    public Object[] startFlight(TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        te.startFlight();
        return new Object[0];
    }

    public Object[] setDoors(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        te.getDoor().setOpen(((Boolean)arguments[0]).booleanValue());
        te.getDoor().setOtherDoors(((Boolean)arguments[0]).booleanValue());
        return new Object[0];
    }

    public Object[] isInFlight(TileEntityTardis te) {
        return new Object[]{te.isInFlight()};
    }

    public Object[] getFuel(TileEntityTardis te) {
        return new Object[]{Float.valueOf(te.getArtron()).doubleValue()};
    }

    public Object[] setFueling(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        te.setFueling(((Boolean)arguments[0]).booleanValue());
        return new Object[0];
    }

    public Object[] isDoorsOpened(TileEntityTardis te) {
        return new Object[]{te.getDoor().isOpen()};
    }

    public Object[] canFly(TileEntityTardis te) {
        return new Object[]{te.getCanFly()};
    }

    public Object[] getTravelTime(TileEntityTardis te) {
        return new Object[]{te.getTimeLeft() / 20};
    }

    public Object[] getWaypoint(Object[] arguments, TileEntityTardis te) {
        if ((Double)arguments[0] < (double)te.saveCoords.size()) {
            int id = (int)Math.round((Double)arguments[0]);
            SpaceTimeCoord spaceTimeCoord = (SpaceTimeCoord)te.saveCoords.get(id);
            return new Object[]{spaceTimeCoord.getPos().func_177958_n(), spaceTimeCoord.getPos().func_177956_o(), spaceTimeCoord.getPos().func_177952_p(), spaceTimeCoord.getDimension(), spaceTimeCoord.name};
        }
        return new Object[]{0};
    }

    public Object[] setWaypoint(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        if ((Double)arguments[0] < (double)te.saveCoords.size()) {
            SpaceTimeCoord spaceTimeCoord = new SpaceTimeCoord(new BlockPos(((Double)arguments[1]).doubleValue(), ((Double)arguments[2]).doubleValue(), ((Double)arguments[3]).doubleValue()), (int)Math.round((Double)arguments[4]), (String)arguments[5]);
            te.saveCoords.set((int)Math.round((Double)arguments[0]), (Object)spaceTimeCoord);
            return new Object[]{true};
        }
        return new Object[]{false};
    }

    public Object[] getHealthComponent(Object[] arguments, TileEntityTardis te) {
        if ((Double)arguments[0] < (double)te.systems.length) {
            return new Object[]{(double)te.systems[(int)Math.round((Double)arguments[0])].getHealth()};
        }
        return new Object[]{null};
    }

    public Object[] getDimensionsID() {
        List<Object> ids = Arrays.asList((Object[])DimensionManager.getStaticDimensionIDs());
        return ids.toArray();
    }

    public Object[] getDimensionName(Object[] arguments) {
        return new Object[]{DimensionManager.getProviderType((int)((int)Math.round((Double)arguments[0]))).func_186065_b()};
    }

    public Object[] setRelativePos(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        BlockPos pos = te.getDestination();
        BlockPos relativePos = new BlockPos((double)pos.func_177958_n() + (Double)arguments[0], (double)pos.func_177956_o() + (Double)arguments[1], (double)pos.func_177952_p() + (Double)arguments[2]);
        te.setDesination(relativePos, te.getTargetDim());
        return new Object[]{null};
    }

    public Object[] setDimensionPos(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        te.setDesination(te.getDestination(), (int)Math.round((Double)arguments[0]));
        return new Object[]{null};
    }

    public Object[] getDimension(TileEntityTardis te) {
        return new Object[]{te.dimension};
    }

    public Object[] getTargetDimension(TileEntityTardis te) {
        return new Object[]{te.getTargetDim()};
    }

    public Object[] setField(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        te.setForceFieldEnabled(((Boolean)arguments[0]).booleanValue());
        TileEntityDoor td = this.getTardisDoor(te);
        if (td != null) {
            td.setForcefield(((Boolean)arguments[0]).booleanValue());
        }
        return new Object[]{null};
    }

    public Object[] getField(TileEntityTardis te) {
        return new Object[]{te.isForceFieldEnabled()};
    }

    public Object[] getSystemName(Object[] arguments, TileEntityTardis te) {
        if ((Double)arguments[0] < (double)te.systems.length) {
            return new Object[]{te.systems[(int)Math.round((Double)arguments[0])].getNameKey()};
        }
        return new Object[]{null};
    }

    public Object[] setStealth(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        te.setStealthMode(((Boolean)arguments[0]).booleanValue());
        return new Object[]{null};
    }

    public Object[] getStealth(TileEntityTardis te) {
        return new Object[]{te.isStealthMode()};
    }

    public Object[] setStabilizers(Object[] arguments, TileEntityTardis te) {
        if (!this.canRun()) {
            return new Object[]{"Aprioritron broken"};
        }
        ((SystemStabilizers)te.getSystem(SystemStabilizers.class)).setOn(((Boolean)arguments[0]).booleanValue());
        return new Object[]{null};
    }

    public Object[] getStabilizers(TileEntityTardis te) {
        return new Object[]{((SystemStabilizers)te.getSystem(SystemStabilizers.class)).isOn()};
    }
}

