/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.handles.event;

import com.vandendaelen.handles.config.HandlesConfig;
import com.vandendaelen.handles.init.Registries;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.tardis.mod.common.entities.EntityCyberman;

@Mod.EventBusSubscriber(modid="handles")
public class CommonEvent {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (HandlesConfig.PROPERTIES.updateChecker) {
            EntityPlayer player = e.player;
            if (!player.field_70170_p.field_72995_K) {
                ForgeVersion.CheckResult version = ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer());
                if (version.status == ForgeVersion.Status.OUTDATED) {
                    TextComponentString url = new TextComponentString(TextFormatting.DARK_AQUA + TextFormatting.BOLD.toString() + "UPDATE");
                    url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/handles"));
                    url.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Open link")));
                    player.func_145747_a(new TextComponentString(TextFormatting.DARK_RED + "[Handles] : ").func_150257_a((ITextComponent)url));
                    String changes = String.valueOf(version.changes).replace("{" + version.target + "=", "").replace("}", "");
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_AQUA + "Changelog: " + TextFormatting.AQUA + changes));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMobKilled(LivingDropsEvent event) {
        Random random;
        if (event.getEntityLiving() instanceof EntityCyberman && (random = new Random()).nextInt(HandlesConfig.DROP.chanceHandlesDrop) == 0) {
            event.getEntityLiving().func_145779_a(Item.func_150898_a((Block)Registries.block_handles), 1);
        }
    }
}

