/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.zoesteria;

import net.minecraft.world.biome.Biome;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.BumpyHillsEffect;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.world.biome.realistic.zoesteria.RealisticBiomeZOEBase;

public class RealisticBiomeZOEHighInhabitedWoodlands
extends RealisticBiomeZOEBase {
    public RealisticBiomeZOEHighInhabitedWoodlands(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPHighland();
    }

    public static class TerrainBOPHighland
    extends TerrainBase {
        private final float baseHeight = 90.0f;
        private final BumpyHillsEffect onTop = new BumpyHillsEffect();
        private final JitterEffect withJitter;

        public TerrainBOPHighland() {
            this.onTop.hillHeight = 30.0f;
            this.onTop.hillWavelength = 60.0f;
            this.onTop.spikeHeight = 20.0f;
            this.onTop.spikeWavelength = 10.0f;
            this.withJitter = new JitterEffect();
            this.withJitter.amplitude = 2.0f;
            this.withJitter.wavelength = 5.0f;
            this.withJitter.jittered = this.onTop;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPHighland.riverized(90.0f + this.withJitter.added(rtgWorld, x, y) + TerrainBOPHighland.groundNoise(x, y, 6.0f, rtgWorld), river);
        }
    }
}

