/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoCobwebs;
import rtg.api.world.deco.DecoDeadBush;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoMushrooms;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.DecoWorldGen;
import rtg.api.world.deco.helper.DecoHelperRandomSplit;
import rtg.api.world.deco.helper.DecoHelperThisOrThat;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGAcaciaBucheri;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGCeibaPentandra;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGRhizophoraMucronata;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.GroundEffect;

public class RealisticBiomeVanillaRoofedForest
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_150585_R;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaRoofedForest() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.5f);
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().ALLOW_COBWEBS).set(true);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaRoofedForest();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaRoofedForest(this.getConfig(), RealisticBiomeVanillaRoofedForest.biome.field_76752_A, RealisticBiomeVanillaRoofedForest.biome.field_76753_B, 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, BlockUtil.getStateDirt(BlockDirt.DirtType.PODZOL), 0.15f);
    }

    @Override
    public void initDecos() {
        DecoMushrooms decoMushrooms = new DecoMushrooms();
        decoMushrooms.setChance(4);
        decoMushrooms.setMaxY(90);
        decoMushrooms.setRandomType(DecoMushrooms.RandomType.ALWAYS_GENERATE);
        this.addDeco(decoMushrooms);
        TreeRTGRhizophoraMucronata mucronataTree = new TreeRTGRhizophoraMucronata(3, 4, 13.0f, 0.32f, 0.1f);
        mucronataTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK));
        mucronataTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.DARK_OAK));
        mucronataTree.setMinTrunkSize(2);
        mucronataTree.setMaxTrunkSize(3);
        mucronataTree.setMinCrownSize(9);
        mucronataTree.setMaxCrownSize(18);
        mucronataTree.setNoLeaves(false);
        this.addTree(mucronataTree);
        DecoTree mangroveTree = new DecoTree(mucronataTree);
        mangroveTree.setTreeType(DecoTree.TreeType.RTG_TREE);
        mangroveTree.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        mangroveTree.setTreeConditionChance(1);
        mangroveTree.setStrengthFactorForLoops(14.0f);
        mangroveTree.setMaxY(110);
        TreeRTGCeibaPentandra pentandraTree = new TreeRTGCeibaPentandra(13.0f, 3, 0.32f, 0.1f);
        pentandraTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK));
        pentandraTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.DARK_OAK));
        pentandraTree.setMinTrunkSize(2);
        pentandraTree.setMaxTrunkSize(3);
        pentandraTree.setMinCrownSize(9);
        pentandraTree.setMaxCrownSize(18);
        pentandraTree.setNoLeaves(false);
        this.addTree(pentandraTree);
        DecoTree ceibaPentandraTree = new DecoTree(pentandraTree);
        ceibaPentandraTree.setTreeType(DecoTree.TreeType.RTG_TREE);
        ceibaPentandraTree.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        ceibaPentandraTree.setTreeConditionChance(1);
        ceibaPentandraTree.setStrengthFactorForLoops(14.0f);
        ceibaPentandraTree.setMaxY(110);
        TreeRTGAcaciaBucheri bucheriTree = new TreeRTGAcaciaBucheri();
        bucheriTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK));
        bucheriTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.DARK_OAK));
        bucheriTree.setMinTrunkSize(6);
        bucheriTree.setMaxTrunkSize(14);
        this.addTree(bucheriTree);
        DecoTree bucheriTrees = new DecoTree(bucheriTree);
        bucheriTrees.setLoops(2);
        bucheriTrees.setTreeType(DecoTree.TreeType.RTG_TREE);
        bucheriTrees.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        bucheriTrees.setTreeConditionChance(1);
        DecoHelperRandomSplit decoHelperRandomSplit = new DecoHelperRandomSplit();
        decoHelperRandomSplit.decos = new DecoBase[]{mangroveTree, ceibaPentandraTree, bucheriTrees};
        decoHelperRandomSplit.chances = new int[]{11, 11, 2};
        this.addDeco(decoHelperRandomSplit);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(80.0f);
        decoFallenTree.getDistribution().setNoiseFactor(60.0f);
        decoFallenTree.getDistribution().setNoiseAddend(-15.0f);
        decoFallenTree.setLogConditionChance(16);
        decoFallenTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK));
        decoFallenTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.DARK_OAK));
        decoFallenTree.setMinSize(4);
        decoFallenTree.setMaxSize(9);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoShrub darkOakShrub = new DecoShrub();
        darkOakShrub.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK));
        darkOakShrub.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.DARK_OAK));
        darkOakShrub.setMaxY(100);
        darkOakShrub.setLoopMultiplier(6.0f);
        DecoShrub oakShrub = new DecoShrub();
        oakShrub.setLogBlock(Blocks.field_150364_r.func_176223_P());
        oakShrub.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        oakShrub.setMaxY(100);
        oakShrub.setLoopMultiplier(6.0f);
        this.addDeco(new DecoHelperThisOrThat(4, DecoHelperThisOrThat.ChanceType.NOT_EQUALS_ZERO, darkOakShrub, oakShrub));
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150341_Y.func_176223_P());
        decoBoulder.setChance(16);
        decoBoulder.setMaxY(80);
        decoBoulder.setStrengthFactor(2.0f);
        this.addDeco(decoBoulder);
        DecoCobwebs decoCobwebs = new DecoCobwebs();
        decoCobwebs.setChance(1);
        decoCobwebs.setMinY(63);
        decoCobwebs.setMaxY(76);
        decoCobwebs.setStrengthFactor(24.0f);
        decoCobwebs.setAdjacentBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK));
        decoCobwebs.setMinAdjacents(2);
        this.addDeco(decoCobwebs, this.getConfig().ALLOW_COBWEBS.get());
        DecoDeadBush decoDeadBush = new DecoDeadBush();
        decoDeadBush.setMaxY(100);
        decoDeadBush.setChance(2);
        decoDeadBush.setStrengthFactor(2.0f);
        this.addDeco(decoDeadBush);
        DecoWorldGen decoBigShroom = new DecoWorldGen((WorldGenerator)new WorldGenBigMushroom(), DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM);
        decoBigShroom.setMinY(63);
        decoBigShroom.setMaxY(100);
        decoBigShroom.setChance(8);
        this.addDeco(decoBigShroom);
    }

    @Override
    public void overrideDecorations() {
        this.baseBiome().field_76760_I.field_76803_B = 3;
        this.baseBiome().field_76760_I.field_76802_A = 1;
    }

    @Override
    public boolean overridesHardcoded() {
        return true;
    }

    public static class SurfaceVanillaRoofedForest
    extends SurfaceBase {
        private final float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private final IBlockState mixBlock;
        private final float mixHeight;

        public SurfaceVanillaRoofedForest(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixSize) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.mixHeight = mixSize;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaRoofedForest
    extends TerrainBase {
        private final GroundEffect groundEffect = new GroundEffect(4.0f);

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaRoofedForest.riverized(65.0f + this.groundEffect.added(rtgWorld, x, y), river);
        }
    }
}

