/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaRiver
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_76781_i;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaRiver() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaRiver();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaRiver(this.getConfig());
    }

    @Override
    public void initDecos() {
    }

    public static class SurfaceVanillaRiver
    extends SurfaceBase {
        public SurfaceVanillaRiver(BiomeConfig config) {
            super(config, (Block)Blocks.field_150349_c, Blocks.field_150346_d);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            if (river > 0.05f && river + simplex.noise2f((float)i / 10.0f, (float)j / 10.0f) * 0.15f > 0.8f) {
                for (int k = 255; k > -1; --k) {
                    Block b = primer.func_177856_a(x, k, z).func_177230_c();
                    if (b == Blocks.field_150350_a) {
                        depth = -1;
                        continue;
                    }
                    if (b == Blocks.field_150355_j) continue;
                    if (++depth == 0 && k > 61) {
                        primer.func_177855_a(x, k, z, Blocks.field_150349_c.func_176223_P());
                        continue;
                    }
                    if (depth < 4) {
                        primer.func_177855_a(x, k, z, Blocks.field_150346_d.func_176223_P());
                        continue;
                    }
                    if (depth <= 4) continue;
                    return;
                }
            }
        }
    }

    public static class TerrainVanillaRiver
    extends TerrainBase {
        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaRiver.terrainFlatLakes(x, y, rtgWorld, river, 60.0f);
        }
    }
}

