/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoFlowersRTG;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.collection.DecoCollectionSmallPineTreesForest;
import rtg.api.world.deco.helper.DecoHelper5050;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPinusPonderosa;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaFlowerForest
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_185444_T;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaFlowerForest() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaFlowerForest();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaFlowerForest(this.getConfig(), Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150349_c.func_176223_P(), 0.05f);
    }

    @Override
    public void initDecos() {
        DecoShrub decoShrub = new DecoShrub();
        decoShrub.setMaxY(110);
        decoShrub.setLoopMultiplier(4.0f);
        decoShrub.setChance(3);
        this.addDeco(decoShrub);
        DecoFlowersRTG decoFlowers1 = new DecoFlowersRTG().addFlowers(BlockFlower.EnumFlowerType.POPPY, BlockFlower.EnumFlowerType.BLUE_ORCHID, BlockFlower.EnumFlowerType.ALLIUM, BlockFlower.EnumFlowerType.HOUSTONIA, BlockFlower.EnumFlowerType.RED_TULIP, BlockFlower.EnumFlowerType.ORANGE_TULIP, BlockFlower.EnumFlowerType.WHITE_TULIP, BlockFlower.EnumFlowerType.PINK_TULIP, BlockFlower.EnumFlowerType.OXEYE_DAISY, BlockFlower.EnumFlowerType.DANDELION).setStrengthFactor(12.0f).setHeightType(DecoFlowersRTG.HeightType.GET_HEIGHT_VALUE);
        this.addDeco(decoFlowers1);
        DecoFlowersRTG decoFlowers2 = new DecoFlowersRTG();
        decoFlowers2.addPlants(BlockDoublePlant.EnumPlantType.SUNFLOWER, BlockDoublePlant.EnumPlantType.SYRINGA, BlockDoublePlant.EnumPlantType.ROSE, BlockDoublePlant.EnumPlantType.PAEONIA);
        decoFlowers2.setChance(8);
        decoFlowers2.setHeightType(DecoFlowersRTG.HeightType.GET_HEIGHT_VALUE);
        this.addDeco(decoFlowers2);
        TreeRTGPinusPonderosa ponderosaOakTree = new TreeRTGPinusPonderosa();
        ponderosaOakTree.setLogBlock(Blocks.field_150364_r.func_176223_P());
        ponderosaOakTree.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        ponderosaOakTree.setMinTrunkSize(11);
        ponderosaOakTree.setMaxTrunkSize(21);
        ponderosaOakTree.setMinCrownSize(15);
        ponderosaOakTree.setMaxCrownSize(29);
        this.addTree(ponderosaOakTree);
        DecoTree oakPines = new DecoTree(ponderosaOakTree);
        oakPines.setStrengthNoiseFactorForLoops(true);
        oakPines.setTreeType(DecoTree.TreeType.RTG_TREE);
        oakPines.getDistribution().setNoiseDivisor(80.0f);
        oakPines.getDistribution().setNoiseFactor(60.0f);
        oakPines.getDistribution().setNoiseAddend(-15.0f);
        oakPines.setTreeCondition(DecoTree.TreeCondition.ALWAYS_GENERATE);
        oakPines.setTreeConditionNoise(0.0f);
        oakPines.setTreeConditionChance(1);
        oakPines.setMaxY(140);
        TreeRTGPinusPonderosa ponderosaSpruceTree = new TreeRTGPinusPonderosa();
        ponderosaSpruceTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE));
        ponderosaSpruceTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE));
        ponderosaSpruceTree.setMinTrunkSize(11);
        ponderosaSpruceTree.setMaxTrunkSize(21);
        ponderosaSpruceTree.setMinCrownSize(15);
        ponderosaSpruceTree.setMaxCrownSize(29);
        this.addTree(ponderosaSpruceTree);
        DecoTree sprucePines = new DecoTree(ponderosaSpruceTree);
        sprucePines.setStrengthNoiseFactorForLoops(true);
        sprucePines.setTreeType(DecoTree.TreeType.RTG_TREE);
        sprucePines.getDistribution().setNoiseDivisor(80.0f);
        sprucePines.getDistribution().setNoiseFactor(60.0f);
        sprucePines.getDistribution().setNoiseAddend(-15.0f);
        sprucePines.setTreeCondition(DecoTree.TreeCondition.ALWAYS_GENERATE);
        sprucePines.setTreeConditionNoise(0.0f);
        sprucePines.setTreeConditionChance(1);
        sprucePines.setMaxY(140);
        DecoHelper5050 decoPines = new DecoHelper5050(oakPines, sprucePines);
        this.addDeco(decoPines);
        this.addDecoCollection(new DecoCollectionSmallPineTreesForest(this.getConfig()));
        DecoFallenTree decoFallenOak = new DecoFallenTree();
        decoFallenOak.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenOak.setLogConditionChance(8);
        decoFallenOak.setMaxY(100);
        decoFallenOak.setLogBlock(Blocks.field_150364_r.func_176223_P());
        decoFallenOak.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        decoFallenOak.setMinSize(3);
        decoFallenOak.setMaxSize(6);
        DecoFallenTree decoFallenSpruce = new DecoFallenTree();
        decoFallenSpruce.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenSpruce.setLogConditionChance(8);
        decoFallenSpruce.setMaxY(100);
        decoFallenSpruce.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE));
        decoFallenSpruce.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE));
        decoFallenSpruce.setMinSize(3);
        decoFallenSpruce.setMaxSize(6);
        DecoHelper5050 decoFallenTree = new DecoHelper5050(decoFallenOak, decoFallenSpruce);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
    }

    @Override
    public void overrideDecorations() {
        this.baseBiome().field_76760_I.field_76802_A = -999;
    }

    @Override
    public boolean overridesHardcoded() {
        return true;
    }

    public static class SurfaceVanillaFlowerForest
    extends SurfaceBase {
        private final float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private final IBlockState mixBlock;
        private final float mixHeight;

        public SurfaceVanillaFlowerForest(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mix, float mixSize) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.mixHeight = mixSize;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaFlowerForest
    extends TerrainBase {
        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaFlowerForest.terrainPlains(x, y, rtgWorld, river, 160.0f, 10.0f, 60.0f, 80.0f, 65.0f);
        }
    }
}

