/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.collection.DecoCollectionDesert;
import rtg.api.world.deco.collection.DecoCollectionDesertRiver;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaDesertM
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_185442_R;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaDesertM() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_CACTUS).set(true);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaDesertM(10.0f, 20.0f, 68.0f, 200.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaDesertM(this.getConfig(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150322_A.func_176223_P(), 0.0f, 1.5f, 60.0f, 65.0f, 1.5f);
    }

    @Override
    public void rReplace(ChunkPrimer primer, int i, int j, int x, int y, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
        this.rReplaceWithRiver(primer, i, j, x, y, depth, rtgWorld, noise, river, base);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionDesertRiver(this.getConfig()));
        this.addDecoCollection(new DecoCollectionDesert(this.getConfig()));
    }

    @Override
    public void overrideDecorations() {
        this.baseBiome().field_76760_I.field_76800_F = -999;
    }

    public static class SurfaceVanillaDesertM
    extends SurfaceBase {
        private final float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;

        public SurfaceVanillaDesertM(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff) {
            super(config, top, fill);
            this.min = minCliff;
        }

        public SurfaceVanillaDesertM(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff) {
            this(config, top, fill, minCliff);
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        primer.func_177855_a(x, k, z, rand.nextInt(3) == 0 ? Blocks.field_150322_A.func_176223_P() : Blocks.field_150354_m.func_176223_P());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowDesertBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, Blocks.field_150354_m.func_176223_P());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowDesertBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaDesertM
    extends TerrainBase {
        private final float start;
        private final float height;
        private final float width;

        public TerrainVanillaDesertM(float hillStart, float landHeight, float baseHeight, float hillWidth) {
            this.start = hillStart;
            this.height = landHeight;
            this.base = baseHeight;
            this.width = hillWidth;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaDesertM.terrainHighland(x, y, rtgWorld, river, this.start, this.width, this.height, 10.0f);
        }
    }
}

