/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.collection.DecoCollectionTaiga;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaColdTaigaHills
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_150579_T;
    public static Biome river = Biomes.field_76777_m;

    public RealisticBiomeVanillaColdTaigaHills() {
        super(biome, RealisticBiomeBase.RiverType.FROZEN, RealisticBiomeBase.BeachType.COLD);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaColdTaigaHills();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaColdTaigaHills(this.getConfig(), Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), 0.2f);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionTaiga(this.getConfig(), 8.0f));
    }

    public static class SurfaceVanillaColdTaigaHills
    extends SurfaceBase {
        private final float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float iCliff = 0.3f;
        private float iHeight = 100.0f;
        private float iStrength = 50.0f;
        private float cCliff = 1.5f;

        public SurfaceVanillaColdTaigaHills(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff) {
            super(config, top, fill);
            this.min = minCliff;
        }

        public SurfaceVanillaColdTaigaHills(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float snowCliff, float snowHeight, float snowStrength, float clayCliff) {
            this(config, top, fill, minCliff);
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.iCliff = snowCliff;
            this.iHeight = snowHeight;
            this.iStrength = snowStrength;
            this.cCliff = clayCliff;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if ((float)k > 110.0f + p * 4.0f && c < this.iCliff + ((float)k - this.iHeight) / this.iStrength + p) {
                        cliff = 3;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (cliff == 3) {
                        primer.func_177855_a(x, k, z, Blocks.field_150433_aE.func_176223_P());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, Blocks.field_150349_c.func_176223_P());
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                if (cliff == 3) {
                    primer.func_177855_a(x, k, z, Blocks.field_150433_aE.func_176223_P());
                    continue;
                }
                primer.func_177855_a(x, k, z, Blocks.field_150346_d.func_176223_P());
            }
        }
    }

    public static class TerrainVanillaColdTaigaHills
    extends TerrainBase {
        public TerrainVanillaColdTaigaHills() {
            this.base = 72.0f;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaColdTaigaHills.terrainHighland(x, y, rtgWorld, river, 10.0f, 68.0f, 35.0f, this.base - 62.0f);
        }
    }
}

