/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.novamterram;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.novamterram.RealisticBiomeNTBase;

public abstract class RealisticBiomeNTBaseGlacier
extends RealisticBiomeNTBase {
    public RealisticBiomeNTBaseGlacier(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.RiverType riverType, @Nonnull RealisticBiomeBase.BeachType beachType) {
        super(baseBiome, riverType, beachType);
    }

    public RealisticBiomeNTBaseGlacier(@Nonnull Biome baseBiome) {
        this(baseBiome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    public RealisticBiomeNTBaseGlacier(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.RiverType riverType) {
        this(baseBiome, riverType, RealisticBiomeBase.BeachType.NORMAL);
    }

    public RealisticBiomeNTBaseGlacier(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.BeachType beachType) {
        this(baseBiome, RealisticBiomeBase.RiverType.NORMAL, beachType);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPGlacier(230.0f, 40.0f, 68.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPGlacier(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, Blocks.field_150403_cj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), 60.0f, -0.14f, 14.0f, 0.25f);
    }

    public static class SurfaceBOPGlacier
    extends SurfaceBase {
        private final IBlockState mixBlockTop;
        private final IBlockState mixBlockFill;
        private final IBlockState cliffBlock1;
        private final IBlockState cliffBlock2;
        private final float width;
        private final float height;
        private final float smallW;
        private final float smallS;

        public SurfaceBOPGlacier(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFill, IBlockState cliff1, IBlockState cliff2, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.mixBlockTop = mixTop;
            this.mixBlockFill = mixFill;
            this.cliffBlock1 = cliff1;
            this.cliffBlock2 = cliff2;
            this.width = mixWidth;
            this.height = mixHeight;
            this.smallW = smallWidth;
            this.smallS = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        primer.func_177855_a(x, k, z, rand.nextInt(3) == 0 ? this.cliffBlock2 : this.cliffBlock1);
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.cliffBlock1);
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) + simplex.noise2f((float)i / this.smallW, (float)j / this.smallW) * this.smallS > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlockTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.mixBlockFill);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPGlacier
    extends TerrainBase {
        private final float width;
        private final float strength;

        public TerrainBOPGlacier(float mountainWidth, float mountainStrength, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.base = height;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPGlacier.terrainLonelyMountain(x, y, rtgWorld, river, this.strength, this.width, this.base);
        }
    }
}

