/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesyougo;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.GroundEffect;
import rtg.api.world.terrain.heighteffect.HeightEffect;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.RaiseEffect;
import rtg.api.world.terrain.heighteffect.VariableRuggednessEffect;
import rtg.world.biome.realistic.biomesyougo.RealisticBiomeBYGBase;

public class RealisticBiomeBYGOutlands
extends RealisticBiomeBYGBase {
    public RealisticBiomeBYGOutlands(Biome biome) {
        super(biome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPOutback(66.0f, 50.0f, 12.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPOutback(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 40.0f, -0.15f, 10.0f, 0.5f);
    }

    public static class SurfaceBOPOutback
    extends SurfaceBase {
        private final IBlockState blockMixTop;
        private final IBlockState blockMixFiller;
        private final float floMixWidth;
        private final float floMixHeight;
        private final float floSmallWidth;
        private final float floSmallStrength;

        public SurfaceBOPOutback(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 4.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2f((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                        primer.func_177855_a(x, k, z, this.blockMixTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.blockMixFiller);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPOutback
    extends TerrainBase {
        private final float minHeight;
        private final float mesaWavelength;
        private final float hillStrength;
        private final float topBumpinessHeight = 4.0f;
        private final float topBumpinessWavelength = 25.0f;
        private final HeightEffect height;
        private final HeightEffect groundEffect;

        public TerrainBOPOutback(float minHeight, float wavelength, float hillStrength) {
            this.minHeight = minHeight;
            this.mesaWavelength = wavelength;
            this.hillStrength = hillStrength;
            this.groundEffect = new GroundEffect(4.0f);
            HeightVariation topVariation = new HeightVariation();
            topVariation.height = hillStrength / 2.0f;
            topVariation.octave = 1;
            topVariation.wavelength = VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH;
            HeightVariation topBumpiness = new HeightVariation();
            topBumpiness.height = 4.0f;
            topBumpiness.wavelength = 25.0f;
            topBumpiness.octave = 3;
            VariableRuggednessEffect mesaTops = new VariableRuggednessEffect(new RaiseEffect(0.0f), topVariation.plus(new RaiseEffect(hillStrength)).plus(topBumpiness), 0.3f, 0.15f, this.mesaWavelength);
            this.height = new VariableRuggednessEffect(new RaiseEffect(0.0f), mesaTops, -0.3f, 0.06f);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPOutback.riverized(this.minHeight + this.groundEffect.added(rtgWorld, x, y), river) + this.height.added(rtgWorld, x, y);
        }
    }
}

