/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeBOPSeasonalForest
extends RealisticBiomeBase {
    public RealisticBiomeBOPSeasonalForest(Biome biome) {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return (Biome)BOPBiomes.gravel_beach.orNull();
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPSeasonalForest(15.0f, 80.0f, 68.0f, 170.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPSeasonalForest(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 0.5f, -0.15f, 10.0f, 0.5f);
    }

    @Override
    public void initDecos() {
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder.setMaxY(80);
        decoBoulder.setChance(16);
        decoBoulder.setStrengthFactor(1.0f);
        this.addDeco(decoBoulder);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(80.0f);
        decoFallenTree.getDistribution().setNoiseFactor(60.0f);
        decoFallenTree.getDistribution().setNoiseAddend(-15.0f);
        decoFallenTree.setLogCondition(DecoFallenTree.LogCondition.RANDOM_CHANCE);
        decoFallenTree.setLogConditionChance(6);
        decoFallenTree.setRandomLogBlocks(new IBlockState[]{BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK), Blocks.field_150364_r.func_176223_P(), BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH)});
        decoFallenTree.setMinSize(3);
        decoFallenTree.setMaxSize(4);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
    }

    public static class SurfaceBOPSeasonalForest
    extends SurfaceBase {
        private IBlockState blockMixTop;
        private IBlockState blockMixFiller;
        private float floMixWidth;
        private float floMixHeight;
        private float floSmallWidth;
        private float floSmallStrength;

        public SurfaceBOPSeasonalForest(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2f((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                        primer.func_177855_a(x, k, z, this.blockMixTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.blockMixFiller);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPSeasonalForest
    extends TerrainBase {
        private float start;
        private float height;
        private float base;
        private float width;

        public TerrainBOPSeasonalForest(float hillStart, float landHeight, float baseHeight, float hillWidth) {
            this.start = hillStart;
            this.height = landHeight;
            this.base = baseHeight;
            this.width = hillWidth;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPSeasonalForest.terrainHighland(x, y, rtgWorld, river, this.start, this.width, this.height, 0.0f);
        }
    }
}

