/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.helper.DecoHelper5050;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGBetulaPapyrifera;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGPiceaSitchensis;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.JitterEffect;

public class RealisticBiomeBOPLandOfLakes
extends RealisticBiomeBase {
    public RealisticBiomeBOPLandOfLakes(Biome biome) {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return (Biome)BOPBiomes.gravel_beach.orNull();
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPLandOfLakes();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPLandOfLakes(this.getConfig(), Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), 0.0f, 1.5f, 60.0f, 65.0f, 1.5f, Blocks.field_150349_c.func_176223_P(), 0.1f);
    }

    @Override
    public void initDecos() {
        TreeRTGBetulaPapyrifera birchTree = new TreeRTGBetulaPapyrifera();
        birchTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH));
        birchTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.BIRCH));
        birchTree.setMinTrunkSize(4);
        birchTree.setMaxTrunkSize(10);
        birchTree.setMinCrownSize(8);
        birchTree.setMaxCrownSize(19);
        this.addTree(birchTree);
        DecoTree birchTrees = new DecoTree(birchTree);
        birchTrees.setStrengthFactorForLoops(9.0f);
        birchTrees.setTreeType(DecoTree.TreeType.RTG_TREE);
        birchTrees.getDistribution().setNoiseDivisor(100.0f);
        birchTrees.getDistribution().setNoiseFactor(6.0f);
        birchTrees.getDistribution().setNoiseAddend(0.8f);
        birchTrees.setTreeCondition(DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE);
        birchTrees.setTreeConditionChance(1);
        birchTrees.setTreeConditionNoise(0.0f);
        birchTrees.setMaxY(120);
        TreeRTGPiceaSitchensis sitchensisTree = new TreeRTGPiceaSitchensis();
        sitchensisTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE));
        sitchensisTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.SPRUCE));
        sitchensisTree.setMinTrunkSize(4);
        sitchensisTree.setMaxTrunkSize(9);
        sitchensisTree.setMinCrownSize(5);
        sitchensisTree.setMaxCrownSize(14);
        this.addTree(sitchensisTree);
        DecoTree smallPine = new DecoTree(sitchensisTree);
        smallPine.setStrengthFactorForLoops(9.0f);
        smallPine.setTreeType(DecoTree.TreeType.RTG_TREE);
        smallPine.getDistribution().setNoiseDivisor(100.0f);
        smallPine.getDistribution().setNoiseFactor(6.0f);
        smallPine.getDistribution().setNoiseAddend(0.8f);
        smallPine.setTreeCondition(DecoTree.TreeCondition.NOISE_GREATER_AND_RANDOM_CHANCE);
        smallPine.setTreeConditionChance(1);
        smallPine.setTreeConditionNoise(0.0f);
        smallPine.setMaxY(120);
        DecoHelper5050 decoHelper5050 = new DecoHelper5050(birchTrees, smallPine);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(100.0f);
        decoFallenTree.getDistribution().setNoiseFactor(6.0f);
        decoFallenTree.getDistribution().setNoiseAddend(0.8f);
        decoFallenTree.setLogConditionChance(12);
        decoFallenTree.setRandomLogBlocks(new IBlockState[]{Blocks.field_150364_r.func_176223_P(), BlockUtil.getStateLog(BlockPlanks.EnumType.SPRUCE), BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH)});
        decoFallenTree.setMinSize(8);
        decoFallenTree.setMaxSize(12);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoShrub decoShrub = new DecoShrub();
        decoShrub.setMaxY(110);
        decoShrub.setLoopMultiplier(3.0f);
        this.addDeco(decoShrub);
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder.setMaxY(80);
        decoBoulder.setChance(12);
        decoBoulder.setStrengthFactor(1.0f);
        this.addDeco(decoBoulder);
    }

    public static class SurfaceBOPLandOfLakes
    extends SurfaceBase {
        private final float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 1.5f;
        private final IBlockState mix;
        private final float mixHeight;

        public SurfaceBOPLandOfLakes(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff, IBlockState mixBlock, float mixSize) {
            super(config, top, fill);
            this.min = minCliff;
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
            this.mix = mixBlock;
            this.mixHeight = mixSize;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            boolean m = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight) {
                        primer.func_177855_a(x, k, z, this.mix);
                        m = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPLandOfLakes
    extends TerrainBase {
        private float minHeight;
        private float maxHeight;
        private float hillStrength;
        private HeightVariation small;
        private HeightVariation large;
        private JitterEffect largeJitter;
        private JitterEffect smallJitter;

        public TerrainBOPLandOfLakes() {
            super(63.0f);
            this.small = new HeightVariation();
            this.small.height = 2.5f;
            this.small.octave = 1;
            this.small.wavelength = 10.0f;
            this.large = new HeightVariation();
            this.large.height = 5.0f;
            this.large.octave = 2;
            this.large.wavelength = 20.0f;
            this.smallJitter = new JitterEffect();
            this.smallJitter.amplitude = 2.0f;
            this.smallJitter.wavelength = 9.0f;
            this.smallJitter.jittered = this.large.plus(this.small);
            this.largeJitter = new JitterEffect();
            this.largeJitter.amplitude = 4.0f;
            this.largeJitter.wavelength = 18.0f;
            this.largeJitter.jittered = this.smallJitter;
        }

        public TerrainBOPLandOfLakes(float minHeight, float maxHeight, float hillStrength) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight > this.rollingHillsMaxHeight ? this.rollingHillsMaxHeight : (maxHeight < this.minHeight ? this.rollingHillsMaxHeight : maxHeight);
            this.hillStrength = hillStrength;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPLandOfLakes.riverized(this.largeJitter.added(rtgWorld, x, y) + this.base, river);
        }
    }
}

