/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeBOPChaparral
extends RealisticBiomeBase {
    public RealisticBiomeBOPChaparral(Biome biome) {
        super(biome);
    }

    @Override
    public void initDecos() {
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPChaparral();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPChaparral(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, Blocks.field_150354_m.func_176223_P(), 26.0f, 0.35f);
    }

    public static class SurfaceBOPChaparral
    extends SurfaceBase {
        private final IBlockState mixBlock;
        private final float width;
        private final float height;

        public SurfaceBOPChaparral(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mix, float mixWidth, float mixHeight) {
            super(config, top, filler);
            this.mixBlock = mix;
            this.width = mixWidth;
            this.height = mixHeight;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPChaparral
    extends TerrainBase {
        private float baseHeight = 76.0f;
        private final float peakyHillWavelength = 40.0f;
        private float peakyHillStrength = 40.0f;
        private final float smoothHillWavelength = 60.0f;
        private final float smoothHillStrength = 30.0f;
        private final float wavelength = 10.0f;
        private final float amplitude = 2.0f;

        public TerrainBOPChaparral() {
        }

        public TerrainBOPChaparral(float bh, float hs) {
            this.baseHeight = bh;
            this.peakyHillStrength = hs;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            this.groundNoise = TerrainBOPChaparral.groundNoise(x, y, this.groundNoiseAmplitudeHills, rtgWorld);
            ISimplexData2D jitterData = SimplexData2D.newDerivative();
            rtgWorld.simplexInstance(1).multiEval2D((float)x / 10.0f, (float)y / 10.0f, jitterData);
            int pX = (int)Math.round((double)x + jitterData.getDeltaX() * 2.0);
            int pY = (int)Math.round((double)y + jitterData.getDeltaY() * 2.0);
            float h = TerrainBOPChaparral.terrainGrasslandHills(pX, pY, rtgWorld, river, 40.0f, this.peakyHillStrength, 60.0f, 30.0f, this.baseHeight);
            return this.groundNoise * river + h;
        }
    }
}

