/*
 * Decompiled with CFR 0.152.
 */
package rtg.world;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import rtg.RTG;
import rtg.api.RTGAPI;
import rtg.api.util.Logger;
import rtg.api.world.RTGWorld;
import rtg.world.biome.BiomeProviderRTG;
import rtg.world.gen.ChunkGeneratorRTG;

public final class WorldTypeRTG
extends WorldType {
    private static WorldTypeRTG INSTANCE;

    private WorldTypeRTG() {
        super("RTG");
    }

    public static WorldTypeRTG getInstance() {
        if (INSTANCE == null) {
            WorldTypeRTG.init();
        }
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new WorldTypeRTG();
    }

    public BiomeProvider getBiomeProvider(World world) {
        if (!world.field_72995_K) {
            DimensionType type = world.field_73011_w.func_186058_p();
            if (RTGAPI.isAllowedDimensionType(type)) {
                Logger.debug("Allowed DimensionType detected (ID:{}, Type:{}, Suffix:{}).. returning BiomeProviderRTG", type.func_186068_a(), type, type.func_186067_c());
                return new BiomeProviderRTG(RTGWorld.getInstance(world));
            }
            Logger.debug("DimensionType not in whitelist (ID:{}, Type:{}, Suffix:{}).. returning BiomeProvider", type.func_186068_a(), type, type.func_186067_c());
        }
        return new BiomeProvider(world.func_72912_H());
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        if (!world.field_72995_K) {
            DimensionType type = world.field_73011_w.func_186058_p();
            if (RTGAPI.isAllowedDimensionType(type)) {
                Logger.debug("Allowed DimensionType detected (ID:{}, Type:{}, Suffix:{}).. returning ChunkGeneratorRTG", type.func_186068_a(), type, type.func_186067_c());
                return new ChunkGeneratorRTG(RTGWorld.getInstance(world));
            }
            Logger.debug("DimensionType not in whitelist (ID:{}, Type:{}, Suffix:{}).. returning ChunkGeneratorOverworld", type.func_186068_a(), type, type.func_186067_c());
        }
        WorldInfo wi = world.func_72912_H();
        return new ChunkGeneratorOverworld(world, wi.func_76063_b(), wi.func_76089_r(), wi.func_82571_y());
    }

    public boolean isCustomizable() {
        return true;
    }

    public String func_77128_b() {
        return "gui.createWorld.worldtypename";
    }

    public void onCustomizeButton(Minecraft mc, GuiCreateWorld guiCreateWorld) {
        RTG.getProxy().displayCustomizeWorldScreen(guiCreateWorld);
    }
}

