/*
 * Decompiled with CFR 0.152.
 */
package rtg.server;

import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.server.command.CommandTreeBase;
import rtg.api.util.Logger;

public final class RTGCommandTree
extends CommandTreeBase {
    private static final int ACCESS_ALL = 0;
    private static final int ACCESS_ADMIN = 4;
    private static final String LANGKEY_BASE = "rtg.command";
    private static final String LANGKEY_PREFIX_ERROR = "rtg.command.prefix.error";
    private static final Style STYLE_ERROR = new Style().func_150238_a(TextFormatting.RED);
    private static final Style STYLE_GOLD = new Style().func_150238_a(TextFormatting.GOLD);
    private static final String CMD_ROOT = "rtg";

    public RTGCommandTree() {
        Logger.debug("Created /{} command", CMD_ROOT);
        this.addSubcommand((ICommand)new CommandGetWhereAmI(this.func_71517_b()));
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return CMD_ROOT;
    }

    public String func_71518_a(ICommandSender sender) {
        TextComponentString ret = new TextComponentString("");
        this.getSubCommands().forEach(arg_0 -> RTGCommandTree.lambda$getUsage$1((ITextComponent)ret, sender, arg_0));
        return ret.func_150254_d();
    }

    private static /* synthetic */ void lambda$getUsage$1(ITextComponent ret, ICommandSender sender, ICommand cmd) {
        if (cmd instanceof CommandTreeBase) {
            ((CommandTreeBase)cmd).getSubCommands().forEach(rcmd -> ret.func_150258_a("\n").func_150258_a(rcmd.func_71518_a(sender)));
        } else {
            ret.func_150258_a("\n").func_150258_a(cmd.func_71518_a(sender));
        }
    }

    static final class CommandGetWhereAmI
    extends CommandBase {
        private static final String NAME = "whereami";
        private static final String LANGKEY_ERROR = "rtg.command.whereami.error";
        private final String parentName;

        CommandGetWhereAmI(String parentName) {
            this.parentName = parentName;
        }

        public int func_82362_a() {
            return 4;
        }

        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentString("/").func_150257_a((ITextComponent)new TextComponentString(this.parentName + " " + this.func_71517_b())).func_150254_d();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (!(sender instanceof EntityPlayerMP)) {
                sender.func_145747_a(new TextComponentString("  ").func_150257_a(new TextComponentTranslation(RTGCommandTree.LANGKEY_PREFIX_ERROR, new Object[0]).func_150255_a(STYLE_ERROR)).func_150258_a(": ").func_150257_a(new TextComponentTranslation(LANGKEY_ERROR, new Object[0]).func_150255_a(STYLE_GOLD)));
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            BlockPos pos = player.func_180425_c();
            World world = player.func_130014_f_();
            Chunk chunk = world.func_175726_f(pos);
            BiomeProvider provider = world.func_72959_q();
            Biome chunkBiome = chunk.func_177411_a(pos, provider);
            Biome providerBiome = provider.func_180631_a(pos);
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Biome @ %s:%s, Chunk: %s, BiomeProvider: %s", pos.func_177958_n(), pos.func_177952_p(), chunkBiome.getRegistryName(), providerBiome.getRegistryName())));
        }
    }
}

