/*
 * Decompiled with CFR 0.152.
 */
package rtg.client;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import rtg.api.util.Logger;
import rtg.api.world.gen.RTGChunkGenSettings;

public class GuiCustomizeWorldScreenRTG
extends GuiScreen
implements GuiSlider.FormatHelper,
GuiPageButtonList.GuiResponder {
    private static final int ID_OFFSET = 127;
    private static final String LANG_KEY_PREFIX = "gui.createWorld.customize.";
    private static final String LANG_KEY_PREFIX_TITLE = "gui.createWorld.customize.title.";
    private static final String LANG_KEY_PREFIX_CATEGORY = "gui.createWorld.customize.category.";
    private static final String LANG_KEY_PREFIX_SETTING = "gui.createWorld.customize.setting.";
    private static final int BUTTON_DONE = 64;
    private static final int BUTTON_CLIPBOARD = 65;
    private static final int BUTTON_DEFAULTS = 66;
    private static final int BUTTON_PREVPAGE = 67;
    private static final int BUTTON_NEXTPAGE = 68;
    private static final int BUTTON_YES = 69;
    private static final int BUTTON_NO = 70;
    private static final RTGChunkGenSettings defaults = new RTGChunkGenSettings.Factory().build();
    private final GuiCreateWorld parent;
    private String title = "";
    private String subtitle = "";
    private String pageTitle = "";
    private String[] pageNames = new String[Page.values().length];
    private GuiPageButtonList list;
    private GuiButton done;
    private GuiButton clipboard;
    private GuiButton reset;
    private GuiButton prevPage;
    private GuiButton nextPage;
    private GuiButton confirm;
    private GuiButton cancel;
    private boolean settingsModified;
    private boolean confirmDismissed;
    private int confirmMode;

    public GuiCustomizeWorldScreenRTG(GuiScreen parentScreen, String generatorSettings) {
        this.parent = (GuiCreateWorld)parentScreen;
        if (!generatorSettings.isEmpty()) {
            Setting.parseSettings(generatorSettings);
            this.settingsModified = true;
        } else {
            Setting.resetToDefaults();
        }
    }

    public void func_73866_w_() {
        int page = 0;
        int scrolled = 0;
        if (this.list != null) {
            page = this.list.func_178059_e();
            scrolled = this.list.func_148148_g();
        }
        this.title = I18n.func_135052_a((String)"gui.createWorld.customize.title.maintitle", (Object[])new Object[0]);
        this.field_146292_n.clear();
        this.done = this.func_189646_b(new GuiButton(64, this.field_146294_l / 2 + 98, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.clipboard = this.func_189646_b(new GuiButton(65, this.field_146294_l / 2 - 80, this.field_146295_m - 27, 160, 20, I18n.func_135052_a((String)"gui.createWorld.customize.clipboard", (Object[])new Object[0])));
        this.reset = this.func_189646_b(new GuiButton(66, this.field_146294_l / 2 - 187, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"createWorld.customize.custom.defaults", (Object[])new Object[0])));
        this.prevPage = this.func_189646_b(new GuiButton(67, 20, 5, 80, 20, I18n.func_135052_a((String)"createWorld.customize.custom.prev", (Object[])new Object[0])));
        this.nextPage = this.func_189646_b(new GuiButton(68, this.field_146294_l - 100, 5, 80, 20, I18n.func_135052_a((String)"createWorld.customize.custom.next", (Object[])new Object[0])));
        this.confirm = new GuiButton(69, this.field_146294_l / 2 - 55, 160, 50, 20, I18n.func_135052_a((String)"gui.yes", (Object[])new Object[0]));
        this.cancel = new GuiButton(70, this.field_146294_l / 2 + 5, 160, 50, 20, I18n.func_135052_a((String)"gui.no", (Object[])new Object[0]));
        this.clipboard.field_146124_l = this.settingsModified;
        this.reset.field_146124_l = this.settingsModified;
        this.confirm.field_146125_m = false;
        this.cancel.field_146125_m = false;
        this.field_146292_n.add(this.confirm);
        this.field_146292_n.add(this.cancel);
        if (this.confirmMode != 0) {
            this.confirm.field_146125_m = true;
            this.cancel.field_146125_m = true;
        }
        this.createPagedList();
        if (page != 0) {
            this.list.func_181156_c(page);
            this.list.func_148145_f(scrolled);
            this.updatePageControls();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    public void func_175319_a(int id, String value) {
        this.setSettingsModified(Setting.isModified());
    }

    public void func_175321_a(int id, boolean value) {
        Setting setting = Setting.getByID(id);
        if (setting != null) {
            setting.setCurValue(value);
            this.setSettingsModified(Setting.isModified());
        }
    }

    public void func_175320_a(int id, float value) {
        Setting setting = Setting.getByID(id);
        if (setting != null) {
            if (setting.getSettingType().equals((Object)SettingType.INTEGER)) {
                setting.setCurValue((int)value);
            } else {
                setting.setCurValue(value);
            }
            this.setSettingsModified(Setting.isModified());
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 64: {
                    RTGChunkGenSettings.Factory factory = RTGChunkGenSettings.Factory.jsonToFactory(Setting.buildJson().toString());
                    if (factory != null) {
                        this.parent.field_146334_a = factory.toString();
                    } else {
                        Logger.error("Error parsing RTGChunkGenSettings settings from string: {}", Setting.buildJson().toString());
                    }
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                    break;
                }
                case 65: {
                    this.copyToClipboard();
                    break;
                }
                case 66: {
                    if (!this.settingsModified) break;
                    this.enterConfirmation(66);
                    break;
                }
                case 67: {
                    this.list.func_178071_h();
                    this.updatePageControls();
                    break;
                }
                case 68: {
                    this.list.func_178064_i();
                    this.updatePageControls();
                    break;
                }
                case 69: {
                    this.exitConfirmation();
                    break;
                }
                case 70: {
                    this.confirmMode = 0;
                    this.exitConfirmation();
                }
            }
        }
    }

    private void createPagedList() {
        GuiPageButtonList.GuiListEntry[][] pages = new GuiPageButtonList.GuiListEntry[Page.values().length][];
        Lists.newArrayList((Object[])Page.values()).forEach(page -> {
            int pg = page.ordinal();
            Id id = new Id();
            this.pageNames[pg] = page.getTitle();
            pages[pg] = new GuiPageButtonList.GuiListEntry[page.getPageSize()];
            page.CATEGORIES.forEach(cat -> {
                pages[pg][id.next()] = new GuiPageButtonList.GuiLabelEntry(1127 + cat.ordinal(), cat.getTitle(), page.isPage1());
                id.next();
                List<Setting> sets = Setting.getSettingsForCategory(cat);
                sets.forEach(setting -> {
                    if (setting.getSettingType().equals((Object)SettingType.BOOLEAN)) {
                        pages[pg][id.next()] = new GuiPageButtonList.GuiButtonEntry(setting.getID(), setting.getLangKey(), setting.isPage1(), setting.curValue().getBool());
                    }
                    if (setting.getSettingType().equals((Object)SettingType.INTEGER)) {
                        pages[pg][id.next()] = new GuiPageButtonList.GuiSlideEntry(setting.getID(), setting.getLangKey(), setting.isPage1(), (fid, fname, fval) -> {
                            if (setting.equals((Object)Setting.waterSpoutChance) || setting.equals((Object)Setting.lavaSpoutChance)) {
                                return fname + ((int)fval == 0 ? ": Disabled" : ": " + String.format("%d", (int)fval));
                            }
                            return fname + ": " + String.format("%d", (int)fval);
                        }, (float)setting.minValue().getInt(), (float)setting.maxValue().getInt(), (float)setting.curValue().getInt());
                    }
                    if (setting.getSettingType().equals((Object)SettingType.FLOAT)) {
                        pages[pg][id.next()] = new GuiPageButtonList.GuiSlideEntry(setting.getID(), setting.getLangKey(), setting.isPage1(), (fid, fname, fval) -> setting.equals((Object)Setting.riverCutOffScale) ? fname + ": " + String.format("%3.3f", Float.valueOf(fval)) : fname + ": " + String.format("%1.3f", Float.valueOf(fval)), setting.minValue().getFloat(), setting.maxValue().getFloat(), setting.curValue().getFloat());
                    }
                });
                if (sets.size() % 2 != 0) {
                    id.next();
                }
            });
        });
        this.list = new GuiPageButtonList(this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 32, 25, (GuiPageButtonList.GuiResponder)this, (GuiPageButtonList.GuiListEntry[][])pages);
        this.updatePageControls();
    }

    private void updatePageControls() {
        this.prevPage.field_146124_l = this.list.func_178059_e() != 0;
        this.nextPage.field_146124_l = this.list.func_178059_e() != this.list.func_178057_f() - 1;
        this.subtitle = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.list.func_178059_e() + 1, this.list.func_178057_f()});
        this.pageTitle = this.pageNames[this.list.func_178059_e()];
    }

    private void setSettingsModified(boolean settingsModified) {
        this.settingsModified = settingsModified;
        this.clipboard.field_146124_l = settingsModified;
        this.reset.field_146124_l = settingsModified;
    }

    private void setConfirmationControls(boolean confirm) {
        this.confirm.field_146125_m = confirm;
        this.cancel.field_146125_m = confirm;
        this.done.field_146124_l = !confirm;
        this.prevPage.field_146124_l = !confirm;
        this.nextPage.field_146124_l = !confirm;
        this.reset.field_146124_l = this.settingsModified && !confirm;
        this.list.func_181155_a(!confirm);
    }

    private void enterConfirmation(int confirmMode) {
        this.confirmMode = confirmMode;
        this.setConfirmationControls(true);
    }

    private void exitConfirmation() throws IOException {
        switch (this.confirmMode) {
            case 64: {
                this.func_146284_a((GuiButton)((GuiListButton)this.list.func_178061_c(64)));
                break;
            }
            case 66: {
                Setting.resetToDefaults();
                this.createPagedList();
                this.setSettingsModified(false);
            }
        }
        this.confirmMode = 0;
        this.confirmDismissed = true;
        this.setConfirmationControls(false);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.confirmMode == 0 && !this.confirmDismissed) {
            this.list.func_148179_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.confirmDismissed) {
            this.confirmDismissed = false;
        } else if (this.confirmMode == 0) {
            this.list.func_148181_b(mouseX, mouseY, state);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 2, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.subtitle, this.field_146294_l / 2, 12, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.pageTitle, this.field_146294_l / 2, 22, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.confirmMode != 0) {
            GuiCustomizeWorldScreenRTG.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
            this.func_73730_a(this.field_146294_l / 2 - 91, this.field_146294_l / 2 + 90, 99, -2039584);
            this.func_73730_a(this.field_146294_l / 2 - 91, this.field_146294_l / 2 + 90, 185, -6250336);
            this.func_73728_b(this.field_146294_l / 2 - 91, 99, 185, -2039584);
            this.func_73728_b(this.field_146294_l / 2 + 90, 99, 185, -6250336);
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            this.field_146297_k.func_110434_K().func_110577_a(field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexbuffer.func_181662_b((double)(this.field_146294_l / 2 - 90), 185.0, 0.0).func_187315_a(0.0, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            vertexbuffer.func_181662_b((double)(this.field_146294_l / 2 + 90), 185.0, 0.0).func_187315_a(5.625, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            vertexbuffer.func_181662_b((double)(this.field_146294_l / 2 + 90), 100.0, 0.0).func_187315_a(5.625, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            vertexbuffer.func_181662_b((double)(this.field_146294_l / 2 - 90), 100.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            tessellator.func_78381_a();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.confirmTitle", (Object[])new Object[0]), this.field_146294_l / 2, 105, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.confirm1", (Object[])new Object[0]), this.field_146294_l / 2, 125, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.confirm2", (Object[])new Object[0]), this.field_146294_l / 2, 135, 0xFFFFFF);
            this.confirm.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.cancel.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }

    private void copyToClipboard() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(Setting.buildJson().toString()), null);
    }

    public String func_175318_a(int id, String name, float value) {
        return name + ": " + value;
    }

    static /* synthetic */ RTGChunkGenSettings access$000() {
        return defaults;
    }

    private static class Id {
        private int count = 0;

        private Id() {
        }

        public int next() {
            return this.count++;
        }
    }

    static enum Setting {
        useBoulders(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useBoulders, null, null, Category.SURFACE),
        boulderMult(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().boulderMult), Float.valueOf(0.2f), Float.valueOf(5.0f), Category.SURFACE),
        useSnowLayers(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useSnowLayers, null, null, Category.SURFACE),
        snowLayerTemp(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().snowLayerTemp), Float.valueOf(0.05f), Float.valueOf(0.15f), Category.SURFACE),
        sandDuneHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().sandDuneHeight, 1, 10, Category.SURFACE),
        bedrockLayers(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().bedrockLayers, 1, 10, Category.UNDERGROUND),
        useCaves(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useCaves, null, null, Category.UNDERGROUND),
        caveChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().caveChance, 4, 200, Category.UNDERGROUND),
        caveDensity(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().caveDensity, 1, 20, Category.UNDERGROUND),
        useRavines(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useRavines, null, null, Category.UNDERGROUND),
        ravineChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().ravineChance, 4, 200, Category.UNDERGROUND),
        riverSizeMult(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().riverSizeMult), Float.valueOf(0.5f), Float.valueOf(2.0f), Category.RIVERS),
        riverFrequency(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().riverFrequency), Float.valueOf(0.0f), Float.valueOf(8.0f), Category.RIVERS),
        riverBendMult(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().riverBendMult), Float.valueOf(0.5f), Float.valueOf(2.0f), Category.RIVERS),
        riverCutOffAmpl(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().riverCutOffAmpl), Float.valueOf(0.0f), Float.valueOf(2.0f), Category.RIVERS),
        riverCutOffScale(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().riverCutOffScale), Float.valueOf(50.0f), Float.valueOf(750.0f), Category.RIVERS),
        RTGlakeSizeMult(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().RTGlakeSizeMult), Float.valueOf(0.0f), Float.valueOf(2.0f), Category.RTGLAKES),
        RTGlakeFreqMult(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().RTGlakeFreqMult), Float.valueOf(0.0f), Float.valueOf(2.0f), Category.RTGLAKES),
        RTGlakeShoreBend(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().RTGlakeShoreBend), Float.valueOf(0.0f), Float.valueOf(2.0f), Category.RTGLAKES),
        useWaterLakes(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useWaterLakes, null, null, Category.VANILLASURFACELAKES),
        waterLakeChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().waterLakeChance, 1, 100, Category.VANILLASURFACELAKES),
        useLavaLakes(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useLavaLakes, null, null, Category.VANILLASURFACELAKES),
        lavaLakeChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().lavaLakeChance, 1, 100, Category.VANILLASURFACELAKES),
        useWaterUndLakes(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useWaterUndLakes, null, null, Category.VANILLAUNDERGROUNDLAKES),
        waterUndLakeChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().waterUndLakeChance, 1, 100, Category.VANILLAUNDERGROUNDLAKES),
        useLavaUndLakes(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useLavaUndLakes, null, null, Category.VANILLAUNDERGROUNDLAKES),
        lavaUndLakeChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().lavaUndLakeChance, 1, 100, Category.VANILLAUNDERGROUNDLAKES),
        waterSpoutChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().waterSpoutChance, 0, 200, Category.VANILLASPOUTS),
        lavaSpoutChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().lavaSpoutChance, 0, 200, Category.VANILLASPOUTS),
        useVillages(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useVillages, null, null, Category.VILLAGES),
        villageSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().villageSize, 0, 5, Category.VILLAGES),
        villageDistance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().villageDistance, 24, 1024, Category.VILLAGES),
        useMineShafts(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useMineShafts, null, null, Category.MINESHAFTS),
        mineShaftChance(SettingType.FLOAT, Float.valueOf(GuiCustomizeWorldScreenRTG.access$000().mineShaftChance), Float.valueOf(0.001f), Float.valueOf(0.01f), Category.MINESHAFTS),
        useDungeons(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useDungeons, null, null, Category.DUNGEONS),
        dungeonChance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dungeonChance, 5, 20, Category.DUNGEONS),
        useTemples(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useTemples, null, null, Category.TEMPLES),
        templeDistance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().templeDistance, 16, 64, Category.TEMPLES),
        useMonuments(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useMonuments, null, null, Category.MONUMENTS),
        monumentSpacing(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().monumentSpacing, 16, 64, Category.MONUMENTS),
        monumentSeparation(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().monumentSeparation, 3, 8, Category.MONUMENTS),
        useMansions(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useMansions, null, null, Category.MANSIONS),
        mansionSpacing(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().mansionSpacing, 40, 160, Category.MANSIONS),
        mansionSeparation(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().mansionSeparation, 10, 40, Category.MANSIONS),
        useStrongholds(SettingType.BOOLEAN, GuiCustomizeWorldScreenRTG.access$000().useStrongholds, null, null, Category.STRONGHOLDS),
        strongholdCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().strongholdCount, 0, 256, Category.STRONGHOLDS),
        strongholdDistance(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().strongholdDistance, 16, 64, Category.STRONGHOLDS),
        strongholdSpread(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().strongholdSpread, 2, 4, Category.STRONGHOLDS),
        dirtSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dirtSize, 1, 50, Category.DIRT),
        dirtCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dirtCount, 0, 40, Category.DIRT),
        dirtMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dirtMinHeight, 0, 255, Category.DIRT),
        dirtMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dirtMaxHeight, 0, 255, Category.DIRT),
        gravelSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().gravelSize, 1, 50, Category.GRAVEL),
        gravelCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().gravelCount, 0, 40, Category.GRAVEL),
        gravelMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().gravelMinHeight, 0, 255, Category.GRAVEL),
        gravelMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().gravelMaxHeight, 0, 255, Category.GRAVEL),
        graniteSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().graniteSize, 1, 50, Category.GRANITE),
        graniteCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().graniteCount, 0, 40, Category.GRANITE),
        graniteMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().graniteMinHeight, 0, 255, Category.GRANITE),
        graniteMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().graniteMaxHeight, 0, 255, Category.GRANITE),
        dioriteSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dioriteSize, 1, 50, Category.DIORITE),
        dioriteCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dioriteCount, 0, 40, Category.DIORITE),
        dioriteMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dioriteMinHeight, 0, 255, Category.DIORITE),
        dioriteMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().dioriteMaxHeight, 0, 255, Category.DIORITE),
        andesiteSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().andesiteSize, 1, 50, Category.ANDESITE),
        andesiteCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().andesiteCount, 0, 40, Category.ANDESITE),
        andesiteMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().andesiteMinHeight, 0, 255, Category.ANDESITE),
        andesiteMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().andesiteMaxHeight, 0, 255, Category.ANDESITE),
        coalSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().coalSize, 1, 50, Category.COAL),
        coalCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().coalCount, 0, 40, Category.COAL),
        coalMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().coalMinHeight, 0, 255, Category.COAL),
        coalMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().coalMaxHeight, 0, 255, Category.COAL),
        ironSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().ironSize, 1, 50, Category.IRON),
        ironCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().ironCount, 0, 40, Category.IRON),
        ironMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().ironMinHeight, 0, 255, Category.IRON),
        ironMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().ironMaxHeight, 0, 255, Category.IRON),
        goldSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().goldSize, 1, 50, Category.GOLD),
        goldCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().goldCount, 0, 40, Category.GOLD),
        goldMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().goldMinHeight, 0, 255, Category.GOLD),
        goldMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().goldMaxHeight, 0, 255, Category.GOLD),
        redstoneSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().redstoneSize, 1, 50, Category.REDSTONE),
        redstoneCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().redstoneCount, 0, 40, Category.REDSTONE),
        redstoneMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().redstoneMinHeight, 0, 255, Category.REDSTONE),
        redstoneMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().redstoneMaxHeight, 0, 255, Category.REDSTONE),
        diamondSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().diamondSize, 1, 50, Category.DIAMOND),
        diamondCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().diamondCount, 0, 40, Category.DIAMOND),
        diamondMinHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().diamondMinHeight, 0, 255, Category.DIAMOND),
        diamondMaxHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().diamondMaxHeight, 0, 255, Category.DIAMOND),
        lapisSize(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().lapisSize, 1, 50, Category.LAPIS),
        lapisCount(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().lapisCount, 0, 40, Category.LAPIS),
        lapisCenterHeight(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().lapisCenterHeight, 0, 255, Category.LAPIS),
        lapisSpread(SettingType.INTEGER, GuiCustomizeWorldScreenRTG.access$000().lapisSpread, 0, 255, Category.LAPIS);

        private final SettingType settingType;
        private final int id;
        private final Category category;
        private final Object defValue;
        private final Object minValue;
        private final Object maxValue;
        private boolean isPage1;
        private Object curValue;
        private Object returnValue;

        private Setting(@Nullable SettingType settingType, @Nullable Object defValue, Object minValue, Object maxValue, Category category) {
            this.settingType = settingType;
            this.id = 127 + this.ordinal();
            this.category = category;
            this.defValue = defValue;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.curValue = this.defValue;
        }

        public static List<Setting> getSettingsForCategory(Category category) {
            ArrayList ret = Lists.newArrayList();
            for (Setting setting : Setting.values()) {
                if (!setting.getCategory().equals((Object)category)) continue;
                ret.add(setting);
            }
            return ret;
        }

        @Nullable
        public static Setting getByID(int id) {
            for (Setting setting : Setting.values()) {
                if (setting.getID() != id) continue;
                return setting;
            }
            return null;
        }

        public static boolean isModified() {
            for (Setting setting : Setting.values()) {
                if (setting.getSettingType().equals((Object)SettingType.BOOLEAN) && setting.curValue().getBool() != setting.defValue().getBool()) {
                    return true;
                }
                if (setting.getSettingType().equals((Object)SettingType.INTEGER) && setting.curValue().getInt() != setting.defValue().getInt()) {
                    return true;
                }
                if (!setting.getSettingType().equals((Object)SettingType.FLOAT) || setting.curValue().getFloat() == setting.defValue().getFloat()) continue;
                return true;
            }
            return false;
        }

        public static JsonObject buildJson() {
            JsonObject ret = new JsonObject();
            for (Setting setting : Setting.values()) {
                if (setting.getSettingType().equals((Object)SettingType.BOOLEAN) && setting.curValue().getBool() != setting.defValue().getBool()) {
                    ret.addProperty(setting.name(), Boolean.valueOf(setting.curValue().getBool()));
                }
                if (setting.getSettingType().equals((Object)SettingType.INTEGER) && setting.curValue().getInt() != setting.defValue().getInt()) {
                    ret.addProperty(setting.name(), (Number)setting.curValue().getInt());
                }
                if (!setting.getSettingType().equals((Object)SettingType.FLOAT) || setting.curValue().getFloat() == setting.defValue().getFloat()) continue;
                ret.addProperty(setting.name(), (Number)Float.valueOf(setting.curValue().getFloat()));
            }
            return ret;
        }

        public static void resetToDefaults() {
            for (Setting setting : Setting.values()) {
                setting.setCurValue(setting.defValue);
            }
        }

        public static void parseSettings(String generatorSettings) {
            RTGChunkGenSettings.Factory factory = RTGChunkGenSettings.Factory.jsonToFactory(generatorSettings);
            if (factory == null) {
                Logger.error("Error parsing RTGChunkGenSettings settings from string: {}", generatorSettings);
                return;
            }
            JsonObject json = new JsonParser().parse(factory.toString()).getAsJsonObject();
            Setting[] setting = new Setting[1];
            json.entrySet().forEach(entry -> {
                try {
                    setting[0] = Setting.valueOf((String)entry.getKey());
                }
                catch (IllegalArgumentException ignored) {
                    Logger.error("GuiCustomizeWorldScreenRTG$Setting#parseSettings: Illegal argument. No enum exists for the setting: " + (String)entry.getKey(), new Object[0]);
                    setting[0] = null;
                }
                if (setting[0] != null) {
                    if (setting[0].getSettingType().equals((Object)SettingType.BOOLEAN)) {
                        setting[0].setCurValue(((JsonElement)entry.getValue()).getAsBoolean());
                    }
                    if (setting[0].getSettingType().equals((Object)SettingType.INTEGER)) {
                        setting[0].setCurValue(((JsonElement)entry.getValue()).getAsInt());
                    }
                    if (setting[0].getSettingType().equals((Object)SettingType.FLOAT)) {
                        setting[0].setCurValue(((JsonElement)entry.getValue()).getAsFloat());
                    }
                }
            });
        }

        public SettingType getSettingType() {
            return this.settingType;
        }

        public int getID() {
            return this.id;
        }

        public Category getCategory() {
            return this.category;
        }

        public String getLangKey() {
            return GuiCustomizeWorldScreenRTG.LANG_KEY_PREFIX_SETTING + this.name();
        }

        public boolean isPage1() {
            return this.isPage1;
        }

        public void setPage1() {
            this.isPage1 = true;
        }

        public Setting defValue() {
            this.returnValue = this.defValue;
            return this;
        }

        public Setting minValue() {
            this.returnValue = this.minValue;
            return this;
        }

        public Setting maxValue() {
            this.returnValue = this.maxValue;
            return this;
        }

        public Setting curValue() {
            this.returnValue = this.curValue;
            return this;
        }

        public boolean getBool() {
            return (Boolean)this.returnValue;
        }

        public int getInt() {
            if (this.returnValue instanceof Float) {
                return ((Float)this.returnValue).intValue();
            }
            return (Integer)this.returnValue;
        }

        public float getFloat() {
            if (this.returnValue instanceof Integer) {
                return ((Integer)this.returnValue).floatValue();
            }
            return ((Float)this.returnValue).floatValue();
        }

        public void setCurValue(boolean val) {
            this.curValue = val;
        }

        public void setCurValue(int val) {
            this.curValue = val;
        }

        public void setCurValue(float val) {
            this.curValue = Float.valueOf(val);
        }

        public void setCurValue(Object val) {
            this.curValue = val;
        }
    }

    static enum Category {
        WORLD,
        SURFACE,
        UNDERGROUND,
        RIVERS,
        RTGLAKES,
        VANILLASURFACELAKES,
        VANILLAUNDERGROUNDLAKES,
        VANILLASPOUTS,
        VILLAGES,
        MINESHAFTS,
        DUNGEONS,
        TEMPLES,
        MONUMENTS,
        MANSIONS,
        STRONGHOLDS,
        DIRT,
        GRAVEL,
        GRANITE,
        DIORITE,
        ANDESITE,
        COAL,
        IRON,
        GOLD,
        REDSTONE,
        DIAMOND,
        LAPIS;


        public String getTitle() {
            return I18n.func_135052_a((String)(GuiCustomizeWorldScreenRTG.LANG_KEY_PREFIX_CATEGORY + this.name()), (Object[])new Object[0]);
        }
    }

    static enum Page {
        PAGE1(Category.WORLD, Category.SURFACE, Category.UNDERGROUND),
        PAGE2(Category.RIVERS, Category.RTGLAKES, Category.VANILLASURFACELAKES, Category.VANILLAUNDERGROUNDLAKES, Category.VANILLASPOUTS),
        PAGE3(Category.VILLAGES, Category.MINESHAFTS, Category.DUNGEONS, Category.TEMPLES, Category.MONUMENTS, Category.MANSIONS, Category.STRONGHOLDS),
        PAGE4(Category.DIRT, Category.GRAVEL, Category.GRANITE, Category.DIORITE, Category.ANDESITE, Category.COAL, Category.IRON, Category.GOLD, Category.REDSTONE, Category.DIAMOND, Category.LAPIS);

        public final List<Category> CATEGORIES = new ArrayList<Category>();

        private Page(Category ... cats) {
            Collections.addAll(this.CATEGORIES, cats);
            if (this.ordinal() == 0) {
                for (Setting setting : Setting.values()) {
                    if (!this.CATEGORIES.contains((Object)setting.getCategory())) continue;
                    setting.setPage1();
                }
            }
        }

        public int getPageSize() {
            int total = this.CATEGORIES.size() * 2;
            for (Category category : this.CATEGORIES) {
                int tmp = Setting.getSettingsForCategory(category).size();
                total += tmp % 2 == 0 ? tmp : tmp + 1;
            }
            return total;
        }

        public String getTitle() {
            return I18n.func_135052_a((String)(GuiCustomizeWorldScreenRTG.LANG_KEY_PREFIX_TITLE + this.name()), (Object[])new Object[0]);
        }

        public boolean isPage1() {
            return this.equals((Object)PAGE1);
        }
    }

    static enum SettingType {
        BOOLEAN,
        INTEGER,
        FLOAT;

    }
}

