/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenVinesRTG
extends WorldGenerator {
    protected Block vineBlock = Blocks.field_150395_bd;
    protected int maxY;
    protected PropertyBool propNorth;
    protected PropertyBool propEast;
    protected PropertyBool propSouth;
    protected PropertyBool propWest;

    public WorldGenVinesRTG() {
        this.setMaxY(254);
        this.propNorth = BlockVine.field_176273_b;
        this.propEast = BlockVine.field_176278_M;
        this.propSouth = BlockVine.field_176279_N;
        this.propWest = BlockVine.field_176280_O;
    }

    public WorldGenVinesRTG(Block vineBlock, int maxY, PropertyBool propNorth, PropertyBool propEast, PropertyBool propSouth, PropertyBool propWest) {
        this();
        this.vineBlock = vineBlock;
        this.maxY = maxY;
        this.propNorth = propNorth;
        this.propEast = propEast;
        this.propSouth = propSouth;
        this.propWest = propWest;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        while (position.func_177956_o() < this.maxY) {
            if (worldIn.func_175623_d(position)) {
                Block north = worldIn.func_180495_p(position.func_177978_c()).func_177230_c();
                Block south = worldIn.func_180495_p(position.func_177968_d()).func_177230_c();
                Block east = worldIn.func_180495_p(position.func_177974_f()).func_177230_c();
                Block west = worldIn.func_180495_p(position.func_177976_e()).func_177230_c();
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
                    if (!this.vineBlock.func_176198_a(worldIn, position, enumfacing)) continue;
                    this.addVine(worldIn, rand, position, enumfacing);
                    break;
                }
            } else {
                position = position.func_177982_a(rand.nextInt(4) - rand.nextInt(4), 0, rand.nextInt(4) - rand.nextInt(4));
            }
            position = position.func_177984_a();
        }
        return true;
    }

    protected void addVine(World worldIn, Random rand, BlockPos pos, EnumFacing enumfacing) {
        IBlockState iblockstate = this.vineBlock.func_176223_P().func_177226_a((IProperty)this.propNorth, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.SOUTH)).func_177226_a((IProperty)this.propEast, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.WEST)).func_177226_a((IProperty)this.propSouth, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.NORTH)).func_177226_a((IProperty)this.propWest, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.EAST));
        this.func_175903_a(worldIn, pos, iblockstate);
        pos = pos.func_177977_b();
        for (int i = rand.nextInt(4) + 1; worldIn.func_175623_d(pos) && i > 0; --i) {
            this.func_175903_a(worldIn, pos, iblockstate);
            pos = pos.func_177977_b();
        }
    }

    public Block getVineBlock() {
        return this.vineBlock;
    }

    public WorldGenVinesRTG setVineBlock(Block vineBlock) {
        this.vineBlock = vineBlock;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public WorldGenVinesRTG setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public PropertyBool getPropNorth() {
        return this.propNorth;
    }

    public WorldGenVinesRTG setPropNorth(PropertyBool propNorth) {
        this.propNorth = propNorth;
        return this;
    }

    public PropertyBool getPropEast() {
        return this.propEast;
    }

    public WorldGenVinesRTG setPropEast(PropertyBool propEast) {
        this.propEast = propEast;
        return this;
    }

    public PropertyBool getPropSouth() {
        return this.propSouth;
    }

    public WorldGenVinesRTG setPropSouth(PropertyBool propSouth) {
        this.propSouth = propSouth;
        return this;
    }

    public PropertyBool getPropWest() {
        return this.propWest;
    }

    public WorldGenVinesRTG setPropWest(PropertyBool propWest) {
        this.propWest = propWest;
        return this;
    }
}

