/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.util.Logger;

public class WorldGenSponge
extends WorldGenerator {
    protected ArrayList<Block> validGroundBlocks;
    protected ArrayList<Block> validAdjacentBlocks;
    protected int minAdjacents;
    private final IBlockState spongeBlock;
    private final int spongeSize;

    public WorldGenSponge(IBlockState b, int s, Random rand) {
        super(false);
        this.spongeBlock = b;
        this.spongeSize = s;
        this.validGroundBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150354_m, Blocks.field_150360_v));
        this.validAdjacentBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150360_v, Blocks.field_150355_j));
        this.minAdjacents = 3;
    }

    public WorldGenSponge(IBlockState b, int s, Random rand, ArrayList<Block> validGroundBlocks) {
        this(b, s, rand);
        this.validGroundBlocks = validGroundBlocks;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        IBlockState block;
        int y;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (y = pos.func_177956_o(); y > 3 && (world.func_175623_d(new BlockPos(x, y - 1, z)) || !this.validGroundBlocks.contains((block = world.func_180495_p(new BlockPos(x, y - 1, z))).func_177230_c())); --y) {
        }
        if (y <= 3) {
            return false;
        }
        int k2 = this.spongeSize;
        for (int l = 0; k2 >= 0 && l < 3; ++l) {
            int i1 = k2 + rand.nextInt(2);
            int j1 = k2 + rand.nextInt(2);
            int k1 = k2 + rand.nextInt(2);
            float f = (float)(i1 + j1 + k1) * 0.333f + 0.5f;
            for (int l1 = x - i1; l1 <= x + i1; ++l1) {
                for (int i2 = z - k1; i2 <= z + k1; ++i2) {
                    for (int j2 = y - j1; j2 <= y + j1; ++j2) {
                        float f1 = l1 - x;
                        float f2 = i2 - z;
                        float f3 = j2 - y;
                        if (!(f1 * f1 + f2 * f2 + f3 * f3 <= f * f) || !this.hasValidAdjacentBlocks(world, l1, j2, i2)) continue;
                        world.func_180501_a(new BlockPos(l1, j2, i2), this.spongeBlock, 2);
                        Logger.rtgDebug("Sponge generated at {} {} {}", l1, j2, i2);
                    }
                }
            }
            x += -(k2 + 1) + rand.nextInt(2 + k2 * 2);
            z += -(k2 + 1) + rand.nextInt(2 + k2 * 2);
            y += 0 - rand.nextInt(2);
        }
        return true;
    }

    protected boolean hasValidAdjacentBlocks(World world, int x, int y, int z) {
        int adjacentCount = 0;
        if (this.validAdjacentBlocks.contains(world.func_180495_p(new BlockPos(x + 1, y, z)).func_177230_c())) {
            ++adjacentCount;
        }
        if (this.validAdjacentBlocks.contains(world.func_180495_p(new BlockPos(x - 1, y, z)).func_177230_c())) {
            ++adjacentCount;
        }
        if (this.validAdjacentBlocks.contains(world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c())) {
            ++adjacentCount;
        }
        if (this.validAdjacentBlocks.contains(world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c())) {
            ++adjacentCount;
        }
        if (this.validAdjacentBlocks.contains(world.func_180495_p(new BlockPos(x, y, z + 1)).func_177230_c())) {
            ++adjacentCount;
        }
        if (this.validAdjacentBlocks.contains(world.func_180495_p(new BlockPos(x, y, z - 1)).func_177230_c())) {
            ++adjacentCount;
        }
        return adjacentCount > 0 && adjacentCount >= this.minAdjacents;
    }
}

