/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenLayers
extends WorldGenerator {
    private IBlockState layerBlock;
    private PropertyInteger layerProperty;
    private int dropHeight;
    private int layerRange;
    private int scatter;
    private ArrayList<IBlockState> validGroundBlocks;

    public WorldGenLayers(IBlockState block, PropertyInteger prop, int dropHeight, int range, int scatter) {
        super(false);
        this.layerBlock = block;
        this.layerProperty = prop;
        this.dropHeight = dropHeight;
        this.layerRange = range;
        this.setScatter(scatter < 1 ? 1 : scatter);
        this.validGroundBlocks = new ArrayList<IBlockState>(Arrays.asList(Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT)));
    }

    public WorldGenLayers(IBlockState block, PropertyInteger prop, int dropHeight, int range, int scatter, ArrayList<IBlockState> validGroundBlocks) {
        this(block, prop, dropHeight, range, scatter);
        this.setValidGroundBlocks(validGroundBlocks);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        for (int x = pos.func_177958_n() - this.layerRange; x <= pos.func_177958_n() + this.layerRange; ++x) {
            for (int z = pos.func_177952_p() - this.layerRange; z <= pos.func_177952_p() + this.layerRange; ++z) {
                IBlockState state;
                blockpos.func_181079_c(x, pos.func_177956_o() + this.dropHeight, z);
                if (!world.func_175623_d((BlockPos)blockpos)) continue;
                blockpos.func_189536_c(EnumFacing.DOWN);
                while (blockpos.func_177956_o() > 0 && world.func_175623_d((BlockPos)blockpos)) {
                    blockpos.func_189536_c(EnumFacing.DOWN);
                }
                blockpos.func_189536_c(EnumFacing.UP);
                if (this.layerBlock.func_177230_c().func_176196_c(world, (BlockPos)blockpos) && rand.nextInt(this.scatter) == 0) {
                    state = world.func_180495_p(new BlockPos(blockpos.func_177958_n(), blockpos.func_177956_o() - 1, blockpos.func_177952_p()));
                    if (!this.validGroundBlocks.contains(state)) continue;
                    this.func_175903_a(world, (BlockPos)blockpos, this.layerBlock);
                    continue;
                }
                blockpos.func_189536_c(EnumFacing.DOWN);
                state = world.func_180495_p(new BlockPos((Vec3i)blockpos));
                if (state.func_177230_c() != this.layerBlock.func_177230_c()) continue;
                int layers = (Integer)state.func_177229_b((IProperty)this.layerProperty);
                this.func_175903_a(world, (BlockPos)blockpos, this.layerBlock.func_177226_a((IProperty)this.layerProperty, (Comparable)Integer.valueOf((layers & 7) + 1)));
            }
        }
        return true;
    }

    public IBlockState getLayerBlock() {
        return this.layerBlock;
    }

    public WorldGenLayers setLayerBlock(IBlockState layerBlock) {
        this.layerBlock = layerBlock;
        return this;
    }

    public PropertyInteger getLayerProperty() {
        return this.layerProperty;
    }

    public WorldGenLayers setLayerProperty(PropertyInteger layerProperty) {
        this.layerProperty = layerProperty;
        return this;
    }

    public int getDropHeight() {
        return this.dropHeight;
    }

    public WorldGenLayers setDropHeight(int dropHeight) {
        this.dropHeight = dropHeight;
        return this;
    }

    public int getLayerRange() {
        return this.layerRange;
    }

    public WorldGenLayers setLayerRange(int layerRange) {
        this.layerRange = layerRange;
        return this;
    }

    public int getScatter() {
        return this.scatter;
    }

    public WorldGenLayers setScatter(int scatter) {
        this.scatter = scatter;
        return this;
    }

    public ArrayList<IBlockState> getValidGroundBlocks() {
        return this.validGroundBlocks;
    }

    public WorldGenLayers setValidGroundBlocks(ArrayList<IBlockState> validGroundBlocks) {
        this.validGroundBlocks = validGroundBlocks;
        return this;
    }
}

