/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenCrops
extends WorldGenerator {
    private final Block farmType;
    private final int farmSize;
    private final int farmDensity;
    private final int farmHeight;
    private final boolean farmWater;

    public WorldGenCrops(int type, int size, int density, int height, Boolean water) {
        this.farmType = type == 0 ? Blocks.field_150469_bN : (type == 1 ? Blocks.field_150459_bM : (type == 2 ? Blocks.field_185773_cZ : Blocks.field_150464_aj));
        this.farmSize = size;
        this.farmDensity = density;
        this.farmHeight = height;
        this.farmWater = water;
    }

    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World world, Random rand, BlockPos blockPos) {
        return this.generate(world, rand, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        IBlockState b;
        while (y > 0) {
            b = world.func_180495_p(new BlockPos(x, y, z));
            if (!world.func_175623_d(new BlockPos(x, y, z)) || b.func_177230_c().isLeaves(b, (IBlockAccess)world, new BlockPos(x, y, z))) break;
            --y;
        }
        if ((b = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c() != Blocks.field_150349_c && b.func_177230_c() != Blocks.field_150346_d) {
            return false;
        }
        for (int j = 0; j < 4; ++j) {
            b = world.func_180495_p(new BlockPos(j == 0 ? x - 1 : (j == 1 ? x + 1 : x), y, j == 2 ? z - 1 : (j == 3 ? z + 1 : z)));
            if (b.func_185904_a() == Material.field_151578_c || b.func_185904_a() == Material.field_151577_b) continue;
            return false;
        }
        int maxGrowth = ((BlockCrops)this.farmType).func_185526_g() + 1;
        for (int i = 0; i < this.farmDensity; ++i) {
            int rz;
            int ry;
            int rx = rand.nextInt(this.farmSize) - 2;
            b = world.func_180495_p(new BlockPos(x + rx, y + (ry = rand.nextInt(this.farmHeight) - 1), z + (rz = rand.nextInt(this.farmSize) - 2)));
            if (b.func_177230_c() != Blocks.field_150349_c && b.func_177230_c() != Blocks.field_150346_d || !world.func_175623_d(new BlockPos(x + rx, y + ry + 1, z + rz))) continue;
            world.func_175656_a(new BlockPos(x + rx, y + ry, z + rz), Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(rand.nextInt(8))));
            world.func_175656_a(new BlockPos(x + rx, y + ry + 1, z + rz), ((BlockCrops)this.farmType).func_185528_e(rand.nextInt(maxGrowth)));
        }
        if (this.farmWater) {
            world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150355_j.func_176223_P());
        }
        return true;
    }
}

